/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtend.core.macro.declaration;

import com.google.common.base.Preconditions;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtend.core.macro.declaration.ExpressionImpl;
import org.eclipse.xtend.core.macro.declaration.JvmConstructorDeclarationImpl;
import org.eclipse.xtend.core.macro.declaration.JvmFieldDeclarationImpl;
import org.eclipse.xtend.core.macro.declaration.XtendConstructorDeclarationImpl;
import org.eclipse.xtend.lib.macro.declaration.CompilationStrategy;
import org.eclipse.xtend.lib.macro.declaration.ConstructorDeclaration;
import org.eclipse.xtend.lib.macro.declaration.MutableFieldDeclaration;
import org.eclipse.xtend.lib.macro.declaration.MutableTypeDeclaration;
import org.eclipse.xtend.lib.macro.declaration.TypeDeclaration;
import org.eclipse.xtend.lib.macro.declaration.TypeReference;
import org.eclipse.xtend.lib.macro.expression.Expression;
import org.eclipse.xtend2.lib.StringConcatenationClient;
import org.eclipse.xtext.common.types.JvmConstructor;
import org.eclipse.xtext.common.types.JvmField;
import org.eclipse.xtext.common.types.JvmMember;
import org.eclipse.xtext.util.Strings;
import org.eclipse.xtext.xbase.XExpression;

public class MutableJvmFieldDeclarationImpl
extends JvmFieldDeclarationImpl
implements MutableFieldDeclaration {
    public void markAsRead() {
        this.checkMutable();
        this.getCompilationUnit().getReadAndWriteTracking().markReadAccess((EObject)this.getDelegate());
    }

    public void markAsInitializedBy(ConstructorDeclaration constructorDeclaration) {
        this.checkMutable();
        JvmConstructor _switchResult = null;
        boolean _matched = false;
        if (constructorDeclaration instanceof JvmConstructorDeclarationImpl) {
            _matched = true;
            _switchResult = (JvmConstructor)((JvmConstructorDeclarationImpl)constructorDeclaration).getDelegate();
        }
        if (!_matched && constructorDeclaration instanceof XtendConstructorDeclarationImpl) {
            _matched = true;
            JvmConstructor _xblockexpression = null;
            EObject jvmElement = this.getCompilationUnit().getJvmModelAssociations().getPrimaryJvmElement((EObject)((XtendConstructorDeclarationImpl)constructorDeclaration).getDelegate());
            JvmConstructor _xifexpression = null;
            if (jvmElement instanceof JvmConstructor) {
                _xifexpression = (JvmConstructor)jvmElement;
            }
            _switchResult = _xblockexpression = _xifexpression;
        }
        JvmConstructor constructor = _switchResult;
        this.getCompilationUnit().getReadAndWriteTracking().markInitialized((EObject)this.getDelegate(), constructor);
    }

    public MutableTypeDeclaration getDeclaringType() {
        TypeDeclaration _declaringType = super.getDeclaringType();
        return (MutableTypeDeclaration)_declaringType;
    }

    public void setInitializer(Expression initializer) {
        this.checkMutable();
        if (initializer == null) {
            this.getCompilationUnit().getJvmTypesBuilder().removeExistingBody((JvmMember)this.getDelegate());
        } else {
            this.getCompilationUnit().getJvmTypesBuilder().setInitializer((JvmField)this.getDelegate(), (XExpression)((ExpressionImpl)initializer).getDelegate());
        }
    }

    public void setInitializer(CompilationStrategy initializer) {
        this.checkMutable();
        Preconditions.checkArgument((initializer != null ? 1 : 0) != 0, (Object)"initializer cannot be null");
        this.getCompilationUnit().setCompilationStrategy((JvmField)this.getDelegate(), initializer);
    }

    public void setInitializer(StringConcatenationClient template) {
        this.checkMutable();
        Preconditions.checkArgument((template != null ? 1 : 0) != 0, (Object)"template cannot be null");
        this.getCompilationUnit().setCompilationTemplate((JvmField)this.getDelegate(), template);
    }

    public void setFinal(boolean isFinal) {
        this.checkMutable();
        ((JvmField)this.getDelegate()).setFinal(isFinal);
    }

    public void setStatic(boolean isStatic) {
        this.checkMutable();
        ((JvmField)this.getDelegate()).setStatic(isStatic);
    }

    public void setTransient(boolean isTransient) {
        this.checkMutable();
        ((JvmField)this.getDelegate()).setTransient(isTransient);
    }

    public void setVolatile(boolean isVolatile) {
        this.checkMutable();
        ((JvmField)this.getDelegate()).setVolatile(isVolatile);
    }

    public void setType(TypeReference type) {
        this.checkMutable();
        Preconditions.checkArgument((type != null ? 1 : 0) != 0, (Object)"type cannot be null");
        ((JvmField)this.getDelegate()).setType(this.getCompilationUnit().toJvmTypeReference(type));
    }

    public void setConstantValueAsBoolean(final boolean value) {
        this.internalGenericSetConstantValue(value);
        StringConcatenationClient _client = new StringConcatenationClient(){

            protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                _builder.append((Object)value);
            }
        };
        this.getCompilationUnit().setCompilationTemplate((JvmField)this.getDelegate(), _client);
    }

    private void internalGenericSetConstantValue(Object value) {
        this.checkMutable();
        Preconditions.checkArgument((value != null ? 1 : 0) != 0, (Object)"value cannot be null");
        JvmField _delegate = (JvmField)this.getDelegate();
        _delegate.setConstant(true);
        JvmField _delegate_1 = (JvmField)this.getDelegate();
        _delegate_1.setFinal(true);
        JvmField _delegate_2 = (JvmField)this.getDelegate();
        _delegate_2.setStatic(true);
        JvmField _delegate_3 = (JvmField)this.getDelegate();
        _delegate_3.setConstantValue(value);
    }

    public void setConstantValueAsByte(final byte value) {
        this.internalGenericSetConstantValue(value);
        StringConcatenationClient _client = new StringConcatenationClient(){

            protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                _builder.append((Object)value);
            }
        };
        this.getCompilationUnit().setCompilationTemplate((JvmField)this.getDelegate(), _client);
    }

    public void setConstantValueAsInt(final int value) {
        this.internalGenericSetConstantValue(value);
        StringConcatenationClient _client = new StringConcatenationClient(){

            protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                _builder.append((Object)value);
            }
        };
        this.getCompilationUnit().setCompilationTemplate((JvmField)this.getDelegate(), _client);
    }

    public void setConstantValueAsShort(final short value) {
        this.internalGenericSetConstantValue(value);
        StringConcatenationClient _client = new StringConcatenationClient(){

            protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                _builder.append((Object)value);
            }
        };
        this.getCompilationUnit().setCompilationTemplate((JvmField)this.getDelegate(), _client);
    }

    public void setConstantValueAsLong(final long value) {
        this.internalGenericSetConstantValue(value);
        StringConcatenationClient _client = new StringConcatenationClient(){

            protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                _builder.append((Object)value);
                _builder.append((Object)"L");
            }
        };
        this.getCompilationUnit().setCompilationTemplate((JvmField)this.getDelegate(), _client);
    }

    public void setConstantValueAsFloat(final float value) {
        this.internalGenericSetConstantValue(Float.valueOf(value));
        StringConcatenationClient _client = new StringConcatenationClient(){

            protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                _builder.append((Object)Float.valueOf(value));
                _builder.append((Object)"f");
            }
        };
        this.getCompilationUnit().setCompilationTemplate((JvmField)this.getDelegate(), _client);
    }

    public void setConstantValueAsDouble(final double value) {
        this.internalGenericSetConstantValue(value);
        StringConcatenationClient _client = new StringConcatenationClient(){

            protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                _builder.append((Object)value);
                _builder.append((Object)"d");
            }
        };
        this.getCompilationUnit().setCompilationTemplate((JvmField)this.getDelegate(), _client);
    }

    public void setConstantValueAsChar(final char value) {
        this.internalGenericSetConstantValue(Character.valueOf(value));
        StringConcatenationClient _client = new StringConcatenationClient(){

            protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                _builder.append((Object)"'");
                String _convertToJavaString = Strings.convertToJavaString((String)Character.toString(value));
                _builder.append((Object)_convertToJavaString);
                _builder.append((Object)"'");
            }
        };
        this.getCompilationUnit().setCompilationTemplate((JvmField)this.getDelegate(), _client);
    }

    public void setConstantValueAsString(final String value) {
        this.internalGenericSetConstantValue(value);
        StringConcatenationClient _client = new StringConcatenationClient(){

            protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                _builder.append((Object)"\"");
                String _convertToJavaString = Strings.convertToJavaString((String)value);
                _builder.append((Object)_convertToJavaString);
                _builder.append((Object)"\"");
            }
        };
        this.getCompilationUnit().setCompilationTemplate((JvmField)this.getDelegate(), _client);
    }
}

