/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.common.types.util;

import com.google.common.collect.Sets;
import com.google.inject.Inject;
import java.io.Serializable;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import org.eclipse.emf.common.util.EList;
import org.eclipse.xtext.common.types.JvmAnyTypeReference;
import org.eclipse.xtext.common.types.JvmArrayType;
import org.eclipse.xtext.common.types.JvmComponentType;
import org.eclipse.xtext.common.types.JvmConstraintOwner;
import org.eclipse.xtext.common.types.JvmDeclaredType;
import org.eclipse.xtext.common.types.JvmDelegateTypeReference;
import org.eclipse.xtext.common.types.JvmGenericArrayTypeReference;
import org.eclipse.xtext.common.types.JvmLowerBound;
import org.eclipse.xtext.common.types.JvmMultiTypeReference;
import org.eclipse.xtext.common.types.JvmParameterizedTypeReference;
import org.eclipse.xtext.common.types.JvmPrimitiveType;
import org.eclipse.xtext.common.types.JvmSpecializedTypeReference;
import org.eclipse.xtext.common.types.JvmType;
import org.eclipse.xtext.common.types.JvmTypeConstraint;
import org.eclipse.xtext.common.types.JvmTypeReference;
import org.eclipse.xtext.common.types.TypesFactory;
import org.eclipse.xtext.common.types.util.TypeReferences;
import org.eclipse.xtext.common.types.util.TypesSwitch;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SuperTypeCollector {
    @Inject
    private TypesFactory factory;
    @Inject
    private TypeReferences typeReferences;

    public SuperTypeCollector() {
    }

    public SuperTypeCollector(TypesFactory factory) {
        this.factory = factory;
    }

    protected JvmTypeReference newRef(JvmType type) {
        JvmParameterizedTypeReference reference = this.factory.createJvmParameterizedTypeReference();
        reference.setType(type);
        return reference;
    }

    public Set<JvmTypeReference> collectSuperTypes(JvmType type) {
        return this.collectSuperTypes(this.newRef(type));
    }

    public Set<JvmTypeReference> collectSuperTypes(JvmTypeReference type) {
        final LinkedHashSet result = Sets.newLinkedHashSet();
        final HashSet rawTypes = Sets.newHashSet();
        this.doCollectSupertypeData(type, new SuperTypeAcceptor(){

            public boolean accept(JvmTypeReference superType, int distance) {
                JvmType rawType = superType.getType();
                if (rawType != null && !rawType.eIsProxy() && rawTypes.add(superType.getType())) {
                    result.add(superType);
                    return true;
                }
                return false;
            }
        });
        return result;
    }

    public void collectSuperTypes(JvmTypeReference type, SuperTypeAcceptor acceptor) {
        this.doCollectSupertypeData(type, acceptor);
    }

    public Set<String> collectSuperTypeNames(JvmType type) {
        return this.collectSuperTypeNames(this.newRef(type));
    }

    public Set<JvmType> collectSuperTypesAsRawTypes(JvmTypeReference type) {
        final LinkedHashSet result = Sets.newLinkedHashSet();
        this.doCollectSupertypeData(type, new SuperTypeAcceptor(){

            public boolean accept(JvmTypeReference superType, int distance) {
                JvmType rawType = superType.getType();
                if (rawType != null && !rawType.eIsProxy()) {
                    boolean notYetSeen = result.add(superType.getType());
                    return notYetSeen;
                }
                return false;
            }
        });
        return result;
    }

    public Set<String> collectSuperTypeNames(JvmTypeReference type) {
        final LinkedHashSet result = Sets.newLinkedHashSet();
        this.doCollectSupertypeData(type, new SuperTypeAcceptor(){

            public boolean accept(JvmTypeReference superType, int distance) {
                String name = this.getSuperTypeName(superType);
                if (name != null) {
                    return result.add(name);
                }
                return false;
            }

            public String getSuperTypeName(JvmTypeReference typeReference) {
                if (typeReference instanceof JvmParameterizedTypeReference) {
                    JvmType rawType = typeReference.getType();
                    if (rawType != null && !rawType.eIsProxy()) {
                        return rawType.getIdentifier();
                    }
                    return null;
                }
                return typeReference.getIdentifier();
            }
        });
        return result;
    }

    public void doCollectSupertypeData(JvmTypeReference type, SuperTypeAcceptor acceptor) {
        if (type != null) {
            Implementation implementation = new Implementation(acceptor, this.typeReferences);
            implementation.doSwitch(type);
        }
    }

    public boolean isSuperType(JvmDeclaredType subType, JvmDeclaredType superType) {
        if (subType == null || superType == null) {
            return false;
        }
        return this.collectSuperTypesAsRawTypes(this.newRef(subType)).contains(superType);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Implementation
    extends TypesSwitch<Boolean> {
        private boolean collecting = false;
        private SuperTypeAcceptor acceptor;
        private int level;
        private final TypeReferences references;

        public Implementation(SuperTypeAcceptor acceptor, TypeReferences references) {
            this.acceptor = acceptor;
            this.references = references;
            this.level = 0;
        }

        @Override
        public Boolean caseJvmTypeReference(JvmTypeReference object) {
            if (!(object.eIsProxy() || this.collecting && !this.acceptor.accept(object, this.level))) {
                this.collecting = true;
                if (object.getType() != null) {
                    this.doSwitch(object.getType());
                }
            }
            return null;
        }

        @Override
        public Boolean caseJvmGenericArrayTypeReference(JvmGenericArrayTypeReference object) {
            if (!object.eIsProxy()) {
                this.collecting = true;
                ++this.level;
                final SuperTypeAcceptor original = this.acceptor;
                try {
                    this.acceptor = new SuperTypeAcceptor(){

                        public boolean accept(JvmTypeReference superType, int distance) {
                            JvmGenericArrayTypeReference arraySuperType = Implementation.this.references.createArrayType(superType);
                            if (Implementation.this.references.is(superType, Object.class)) {
                                original.accept(superType, distance + 1);
                                original.accept(Implementation.this.references.getTypeForName(Serializable.class, superType.getType(), new JvmTypeReference[0]), distance + 1);
                                original.accept(Implementation.this.references.getTypeForName(Cloneable.class, superType.getType(), new JvmTypeReference[0]), distance + 1);
                            }
                            return original.accept(arraySuperType, distance);
                        }
                    };
                    if (object.getComponentType() != null) {
                        this.doSwitch(object.getComponentType());
                    }
                }
                finally {
                    this.acceptor = original;
                }
                JvmArrayType rawArrayType = object.getType();
                if (rawArrayType != null) {
                    JvmComponentType rawType = rawArrayType.getComponentType();
                    while (rawType instanceof JvmArrayType) {
                        rawType = ((JvmArrayType)rawType).getComponentType();
                    }
                    if (rawType instanceof JvmPrimitiveType) {
                        this.doSwitch(this.references.getTypeForName(Serializable.class, rawType, new JvmTypeReference[0]));
                        this.doSwitch(this.references.getTypeForName(Cloneable.class, rawType, new JvmTypeReference[0]));
                    }
                }
                --this.level;
            }
            return null;
        }

        @Override
        public Boolean caseJvmMultiTypeReference(JvmMultiTypeReference object) {
            if (!object.eIsProxy()) {
                this.collecting = true;
                ++this.level;
                for (JvmTypeReference reference : object.getReferences()) {
                    this.doSwitch(reference);
                }
                --this.level;
            }
            return Boolean.FALSE;
        }

        @Override
        public Boolean caseJvmDelegateTypeReference(JvmDelegateTypeReference object) {
            if (!object.eIsProxy()) {
                this.collecting = true;
                this.doSwitch(object.getDelegate());
            }
            return Boolean.FALSE;
        }

        @Override
        public Boolean caseJvmSpecializedTypeReference(JvmSpecializedTypeReference object) {
            if (!object.eIsProxy()) {
                this.collecting = true;
                ++this.level;
                this.doSwitch(object.getEquivalent());
                --this.level;
            }
            return Boolean.FALSE;
        }

        @Override
        public Boolean caseJvmAnyTypeReference(JvmAnyTypeReference object) {
            return Boolean.FALSE;
        }

        @Override
        public Boolean caseJvmDeclaredType(JvmDeclaredType object) {
            if (!object.eIsProxy()) {
                ++this.level;
                for (JvmTypeReference superType : object.getSuperTypes()) {
                    this.doSwitch(superType);
                }
                --this.level;
            }
            return null;
        }

        @Override
        public Boolean caseJvmTypeConstraint(JvmTypeConstraint object) {
            if (object.getTypeReference() != null) {
                return (Boolean)this.doSwitch(object.getTypeReference());
            }
            return Boolean.TRUE;
        }

        @Override
        public Boolean caseJvmConstraintOwner(JvmConstraintOwner object) {
            if (!object.eIsProxy()) {
                EList<JvmTypeConstraint> constraints = object.getConstraints();
                boolean boundProcessed = false;
                if (!constraints.isEmpty()) {
                    for (JvmTypeConstraint constraint : constraints) {
                        if (!(constraint instanceof JvmLowerBound)) continue;
                        this.doSwitch(constraint);
                        boundProcessed = true;
                    }
                    if (!boundProcessed) {
                        for (JvmTypeConstraint constraint : constraints) {
                            this.doSwitch(constraint);
                            boundProcessed = true;
                        }
                    }
                }
                if (!boundProcessed) {
                    JvmType objectType = this.references.findDeclaredType(Object.class, object);
                    this.doSwitch(this.references.createTypeRef(objectType, new JvmTypeReference[0]));
                }
            }
            return Boolean.TRUE;
        }
    }

    public static interface SuperTypeAcceptor {
        public boolean accept(JvmTypeReference var1, int var2);
    }
}

