/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.junit4.parameterized;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import org.eclipse.xtext.junit4.parameterized.IParameterProvider;
import org.eclipse.xtext.junit4.parameterized.TestExpectationValidator;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.util.internal.FormattingMigrator;
import org.junit.Assert;
import org.junit.ComparisonFailure;

@Retention(value=RetentionPolicy.RUNTIME)
@Target(value={ElementType.METHOD})
@TestExpectationValidator(validator=StringResultValidator.class)
public @interface XpectString {
    public boolean caseSensitive() default true;

    public boolean whitespaceSensitive() default false;

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class StringResultValidator
    implements TestExpectationValidator.ITestExpectationValidator<String> {
        protected XpectString config;

        public StringResultValidator(XpectString config) {
            this.config = config;
        }

        @Override
        public void validate(XtextResource resource, IParameterProvider.IExpectation expectation, @TestExpectationValidator.TestResult String actual) {
            String exp;
            Assert.assertNotNull((Object)resource);
            Assert.assertNotNull((Object)expectation);
            Assert.assertNotNull((Object)expectation.getExpectation());
            Assert.assertNotNull((Object)actual);
            if (!this.config.whitespaceSensitive()) {
                FormattingMigrator migrator = new FormattingMigrator();
                exp = migrator.migrate(actual, expectation.getExpectation());
            } else {
                exp = expectation.getExpectation();
            }
            if (this.config.caseSensitive() && !exp.equals(actual) || !this.config.caseSensitive() && !exp.equalsIgnoreCase(actual)) {
                String expDoc = IParameterProvider.IExpectation.Util.replace(resource, expectation, exp);
                String actDoc = IParameterProvider.IExpectation.Util.replace(resource, expectation, actual);
                throw new ComparisonFailure("", expDoc, actDoc);
            }
        }
    }
}

