/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xtend2.ui.labeling;

import com.google.inject.Inject;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.JavaPluginImages;
import org.eclipse.jdt.internal.ui.viewsupport.JavaElementImageProvider;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.xtext.common.types.JvmVisibility;
import org.eclipse.xtext.ui.IImageHelper;

public class Xtend2Images {
    @Inject
    private IImageHelper imageHelper;

    public Image forPackage() {
        return this.getJdtImage(JavaPluginImages.DESC_OBJS_PACKDECL);
    }

    public Image forImportContainer() {
        return this.getJdtImage(JavaPluginImages.DESC_OBJS_IMPCONT);
    }

    public Image forImport() {
        return this.getJdtImage(JavaPluginImages.DESC_OBJS_IMPDECL);
    }

    public Image forClass(JvmVisibility visibility) {
        return this.getJdtImage(JavaElementImageProvider.getTypeImageDescriptor((boolean)false, (boolean)false, (int)this.toFlags(visibility), (boolean)false));
    }

    public Image forConstructor(JvmVisibility visibility) {
        return this.getDecoratedJdtImage(JavaElementImageProvider.getMethodImageDescriptor((boolean)false, (int)this.toFlags(visibility)), 512);
    }

    public Image forFunction(JvmVisibility visibility, boolean isStatic) {
        ImageDescriptor descriptor = JavaElementImageProvider.getMethodImageDescriptor((boolean)false, (int)this.toFlags(visibility));
        if (isStatic) {
            return this.getDecoratedJdtImage(descriptor, 8);
        }
        return this.getJdtImage(descriptor);
    }

    public Image forField(JvmVisibility visibility, boolean isStatic, boolean isExtension) {
        ImageDescriptor descriptor = JavaElementImageProvider.getFieldImageDescriptor((boolean)false, (int)this.toFlags(visibility));
        if (isStatic) {
            return this.getDecoratedJdtImage(descriptor, 8);
        }
        return this.getJdtImage(descriptor);
    }

    public Image forDispatcherFunction(JvmVisibility visibility, boolean isStatic) {
        return this.forFunction(visibility, isStatic);
    }

    public Image forFile() {
        return this.imageHelper.getImage("xtend2.gif");
    }

    protected Image getJdtImage(ImageDescriptor descriptor) {
        return JavaPlugin.getImageDescriptorRegistry().get(descriptor);
    }

    protected Image getDecoratedJdtImage(ImageDescriptor descriptor, int adornment) {
        return JavaElementImageProvider.getDecoratedImage((ImageDescriptor)descriptor, (int)adornment, (Point)JavaElementImageProvider.SMALL_SIZE);
    }

    protected int toFlags(JvmVisibility visibility) {
        switch (visibility) {
            case PRIVATE: {
                return 2;
            }
            case PROTECTED: {
                return 4;
            }
            case PUBLIC: {
                return 1;
            }
        }
        return 0;
    }
}

