/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xtend2.formatting;

import com.google.common.collect.Iterables;
import com.google.inject.Inject;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtext.Keyword;
import org.eclipse.xtext.common.types.JvmConstructor;
import org.eclipse.xtext.common.types.JvmExecutable;
import org.eclipse.xtext.common.types.JvmFormalParameter;
import org.eclipse.xtext.common.types.JvmGenericType;
import org.eclipse.xtext.common.types.JvmOperation;
import org.eclipse.xtext.common.types.JvmType;
import org.eclipse.xtext.common.types.JvmTypeParameter;
import org.eclipse.xtext.common.types.JvmTypeReference;
import org.eclipse.xtext.common.types.JvmVisibility;
import org.eclipse.xtext.common.types.util.ITypeArgumentContext;
import org.eclipse.xtext.common.types.util.TypeArgumentContextProvider;
import org.eclipse.xtext.common.types.util.TypeReferences;
import org.eclipse.xtext.nodemodel.ICompositeNode;
import org.eclipse.xtext.nodemodel.ILeafNode;
import org.eclipse.xtext.nodemodel.util.NodeModelUtils;
import org.eclipse.xtext.util.Strings;
import org.eclipse.xtext.xbase.compiler.IAppendable;
import org.eclipse.xtext.xbase.compiler.StringBuilderBasedAppendable;
import org.eclipse.xtext.xbase.compiler.TypeReferenceSerializer;
import org.eclipse.xtext.xtend2.jvmmodel.IXtend2JvmAssociations;
import org.eclipse.xtext.xtend2.xtend2.XtendClass;

public class MemberFromSuperImplementor {
    public static final String DEFAULT_BODY = "throw new UnsupportedOperationException(\"Auto-generated function stub\")";
    @Inject
    private TypeArgumentContextProvider typeArgumentContextProvider;
    @Inject
    private TypeReferenceSerializer typeReferenceSerializer;
    @Inject
    private TypeReferences typeReferences;
    @Inject
    private IXtend2JvmAssociations associations;

    public void appendOverrideFunction(XtendClass overrider, JvmOperation overriddenOperation, IAppendable appendable) {
        this.appendExecutable(overrider, (JvmExecutable)overriddenOperation, appendable);
    }

    public void appendConstructorFromSuper(XtendClass overrider, JvmConstructor superConstructor, IAppendable appendable) {
        this.appendExecutable(overrider, (JvmExecutable)superConstructor, appendable);
    }

    protected void appendExecutable(XtendClass overrider, JvmExecutable executableFromSuper, IAppendable appendable) {
        appendable.openScope();
        boolean isOperation = executableFromSuper instanceof JvmOperation;
        final JvmGenericType overridingType = this.associations.getInferredType(overrider);
        ITypeArgumentContext typeArgumentContext = this.typeArgumentContextProvider.getTypeArgumentContext((TypeArgumentContextProvider.Request)new TypeArgumentContextProvider.AbstractRequest(){

            public JvmTypeReference getReceiverType() {
                return MemberFromSuperImplementor.this.typeReferences.createTypeRef((JvmType)overridingType, new JvmTypeReference[0]);
            }
        });
        if (isOperation) {
            appendable.append("override ");
        }
        if (executableFromSuper.getVisibility() == JvmVisibility.PROTECTED) {
            appendable.append("protected ");
        }
        this.appendSignature(executableFromSuper, (EObject)overridingType, typeArgumentContext, appendable, false);
        if (!executableFromSuper.getExceptions().isEmpty()) {
            appendable.append(" throws ");
            boolean isFirst = true;
            for (JvmTypeReference exception : executableFromSuper.getExceptions()) {
                if (!isFirst) {
                    appendable.append(", ");
                }
                isFirst = false;
                this.typeReferenceSerializer.serialize(exception, (EObject)overridingType, appendable);
            }
        }
        appendable.append(" {").increaseIndentation().append("\n");
        if (isOperation) {
            if (((JvmOperation)executableFromSuper).isAbstract()) {
                appendable.append(DEFAULT_BODY);
            } else {
                appendable.append("super.");
                this.appendSignature(executableFromSuper, (EObject)overridingType, typeArgumentContext, appendable, true);
            }
        } else if (!executableFromSuper.getParameters().isEmpty()) {
            this.appendSignature(executableFromSuper, (EObject)overridingType, typeArgumentContext, appendable, true);
        }
        appendable.decreaseIndentation().append("\n}");
        appendable.closeScope();
    }

    protected void appendSignature(JvmExecutable overridden, EObject context, ITypeArgumentContext typeArgumentContext, IAppendable appendable, boolean isCall) {
        boolean isFirst = true;
        if (!Iterables.isEmpty((Iterable)overridden.getTypeParameters())) {
            appendable.append("<");
            for (JvmTypeParameter typeParameter : overridden.getTypeParameters()) {
                if (!isFirst) {
                    appendable.append(", ");
                }
                isFirst = false;
                appendable.append((JvmType)typeParameter);
            }
            appendable.append("> ");
        }
        if (overridden instanceof JvmConstructor) {
            if (isCall) {
                appendable.append("super");
            } else {
                appendable.append("new");
            }
        } else {
            appendable.append(overridden.getSimpleName());
        }
        appendable.append("(");
        isFirst = true;
        for (JvmFormalParameter param : overridden.getParameters()) {
            if (!isFirst) {
                appendable.append(", ");
            }
            isFirst = false;
            if (isCall) {
                appendable.append(appendable.getName((Object)param));
                continue;
            }
            JvmTypeReference overriddenParameterType = typeArgumentContext.getLowerBound(param.getParameterType());
            this.typeReferenceSerializer.serialize(overriddenParameterType, context, appendable, false, false, false, true);
            String declareVariable = appendable instanceof StringBuilderBasedAppendable ? ((StringBuilderBasedAppendable)appendable).declareSyntheticVariable((Object)param, param.getName()) : appendable.declareVariable((Object)param, param.getName());
            appendable.append(" ").append(declareVariable);
        }
        appendable.append(")");
    }

    public int getFunctionInsertOffset(XtendClass clazz) {
        ICompositeNode clazzNode = NodeModelUtils.findActualNodeFor((EObject)clazz);
        int lastClosingBraceOffset = -1;
        for (ILeafNode leafNode : clazzNode.getLeafNodes()) {
            if (!(leafNode.getGrammarElement() instanceof Keyword) || !Strings.equal((String)"}", (String)((Keyword)leafNode.getGrammarElement()).getValue())) continue;
            lastClosingBraceOffset = leafNode.getOffset();
        }
        return lastClosingBraceOffset == -1 ? (lastClosingBraceOffset = clazzNode.getTotalEndOffset()) : lastClosingBraceOffset;
    }

    public int getConstructorInsertOffset(XtendClass clazz) {
        return this.getFunctionInsertOffset(clazz);
    }
}

