/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.logging;

import org.apache.log4j.AppenderSkeleton;
import org.apache.log4j.Level;
import org.apache.log4j.spi.LoggingEvent;
import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.osgi.framework.Bundle;

public class EclipseLogAppender
extends AppenderSkeleton {
    private static final String ORG_APACHE_LOG4J = "org.apache.log4j";
    private ILog log = null;

    private synchronized ILog getLog(String loggerName) {
        if (this.log == null) {
            Bundle[] bundles = Platform.getBundles((String)ORG_APACHE_LOG4J, (String)"1.2.15");
            if (bundles.length == 0) {
                throw new IllegalStateException("Host bundle not found!");
            }
            this.log = Platform.getLog((Bundle)bundles[0]);
        }
        return this.log;
    }

    protected void append(LoggingEvent event) {
        if (this.isDoLog(event.getLevel())) {
            String logString = this.layout.format(event);
            String loggerName = event.getLoggerName();
            ILog myLog = this.getLog(loggerName);
            if (myLog != null) {
                int severity = this.mapLevel(event.getLevel());
                IStatus status = this.createStatus(severity, loggerName, logString);
                myLog.log(status);
            } else {
                System.out.println("No Eclipse Log configured (you need to add a org.eclipse.xtext.logging.loggermap extension to your plugin.xml). Log message was: " + logString);
            }
        }
    }

    private boolean isDoLog(Level level) {
        return level.toInt() >= 30000;
    }

    private int mapLevel(Level level) {
        switch (level.toInt()) {
            case 10000: {
                return 1;
            }
            case 20000: {
                return 1;
            }
            case 30000: {
                return 2;
            }
            case 40000: {
                return 4;
            }
            case 50000: {
                return 4;
            }
        }
        return 1;
    }

    private IStatus createStatus(int severity, String loggerName, String message) {
        return this.createStatus(severity, loggerName, message, null);
    }

    private IStatus createStatus(int severity, String loggerName, String message, Throwable throwable) {
        return new Status(severity, ORG_APACHE_LOG4J, message, throwable);
    }

    public void close() {
    }

    public boolean requiresLayout() {
        return true;
    }
}

