/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.internal.qvt.oml.stdlib;

import java.util.Collection;
import java.util.List;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.m2m.internal.qvt.oml.ast.env.QvtOperationalEvaluationEnv;
import org.eclipse.m2m.internal.qvt.oml.evaluator.ModuleInstance;
import org.eclipse.m2m.internal.qvt.oml.stdlib.AbstractContextualOperations;
import org.eclipse.m2m.internal.qvt.oml.stdlib.AbstractQVTStdlib;
import org.eclipse.m2m.internal.qvt.oml.stdlib.CallHandler;
import org.eclipse.m2m.internal.qvt.oml.stdlib.CallHandlerAdapter;
import org.eclipse.m2m.internal.qvt.oml.stdlib.CallHandlerMutator;
import org.eclipse.m2m.qvt.oml.util.MutableList;
import org.eclipse.ocl.Environment;
import org.eclipse.ocl.types.OCLStandardLibrary;
import org.eclipse.ocl.util.CollectionUtil;
import org.eclipse.ocl.util.TypeUtil;

public class ListOperations
extends AbstractContextualOperations {
    public static final String ADD_NAME = "add";
    public static final String APPEND_SYNONYM = "append";
    public static final String PREPEND_NAME = "prepend";
    public static final String INSERT_AT_NAME = "insertAt";
    public static final String JOINFIELDS_NAME = "joinfields";
    public static final String AS_SET_NAME = "asSet";
    public static final String AS_ORDERED_SET_NAME = "asOrderedSet";
    public static final String AS_SEQUENCE_NAME = "asSequence";
    public static final String AS_BAG_NAME = "asBag";
    public static final String FLATTEN_NAME = "flatten";
    static CallHandler ADD = new CallHandlerMutator(){

        public Object invoke(ModuleInstance module, Object source, Object[] args, QvtOperationalEvaluationEnv evalEnv) {
            List list = (List)source;
            Object element = args[0];
            if (element != CallHandlerAdapter.getInvalidResult(evalEnv)) {
                list.add(element);
            }
            return null;
        }
    };
    static CallHandler PREPEND = new CallHandlerMutator(){

        public Object invoke(ModuleInstance module, Object source, Object[] args, QvtOperationalEvaluationEnv evalEnv) {
            List list = (List)source;
            Object element = args[0];
            if (element != CallHandlerAdapter.getInvalidResult(evalEnv)) {
                list.add(0, element);
            }
            return null;
        }
    };
    static CallHandler INSERT_AT = new CallHandlerMutator(){

        public Object invoke(ModuleInstance module, Object source, Object[] args, QvtOperationalEvaluationEnv evalEnv) {
            MutableList list = (MutableList)source;
            Object element = args[0];
            if (element != CallHandlerAdapter.getInvalidResult(evalEnv)) {
                Integer at = (Integer)args[1];
                list.insertAt(element, at);
            }
            return null;
        }
    };
    static CallHandler JOINFIELDS = new CallHandler(){

        public Object invoke(ModuleInstance module, Object source, Object[] args, QvtOperationalEvaluationEnv evalEnv) {
            MutableList list = (MutableList)source;
            String sep = (String)args[0];
            String begin = (String)args[1];
            String end = (String)args[2];
            return list.joinfields(sep, begin, end);
        }
    };
    static CallHandler AS_SET = new CallHandler(){

        public Object invoke(ModuleInstance module, Object source, Object[] args, QvtOperationalEvaluationEnv evalEnv) {
            MutableList list = (MutableList)source;
            return CollectionUtil.createNewSet((Collection)list);
        }
    };
    static CallHandler AS_ORDERED_SET = new CallHandler(){

        public Object invoke(ModuleInstance module, Object source, Object[] args, QvtOperationalEvaluationEnv evalEnv) {
            MutableList list = (MutableList)source;
            return CollectionUtil.createNewOrderedSet((Collection)list);
        }
    };
    static CallHandler AS_SEQUENCE = new CallHandler(){

        public Object invoke(ModuleInstance module, Object source, Object[] args, QvtOperationalEvaluationEnv evalEnv) {
            MutableList list = (MutableList)source;
            return CollectionUtil.createNewSequence((Collection)list);
        }
    };
    static CallHandler AS_BAG = new CallHandler(){

        public Object invoke(ModuleInstance module, Object source, Object[] args, QvtOperationalEvaluationEnv evalEnv) {
            MutableList list = (MutableList)source;
            return CollectionUtil.createNewBag((Collection)list);
        }
    };
    static CallHandler FLATTEN = new CallHandler(){

        public Object invoke(ModuleInstance module, Object source, Object[] args, QvtOperationalEvaluationEnv evalEnv) {
            MutableList list = (MutableList)source;
            return CollectionUtil.flatten((Collection)list);
        }
    };

    public ListOperations(AbstractQVTStdlib library) {
        super(library, library.getList());
    }

    protected AbstractContextualOperations.OperationProvider[] getOperations() {
        OCLStandardLibrary oclStdlib = this.getStdlib().getEnvironment().getOCLStandardLibrary();
        return new AbstractContextualOperations.OperationProvider[]{(AbstractContextualOperations)this.new AbstractContextualOperations.OperationProvider(ADD, ADD_NAME, new String[]{"object"}, (EClassifier)oclStdlib.getOclVoid(), (EClassifier)oclStdlib.getT()), (AbstractContextualOperations)this.new AbstractContextualOperations.OperationProvider(ADD, APPEND_SYNONYM, new String[]{"object"}, (EClassifier)oclStdlib.getOclVoid(), (EClassifier)oclStdlib.getT()), (AbstractContextualOperations)this.new AbstractContextualOperations.OperationProvider(PREPEND, PREPEND_NAME, new String[]{"object"}, (EClassifier)oclStdlib.getOclVoid(), (EClassifier)oclStdlib.getT()), (AbstractContextualOperations)this.new AbstractContextualOperations.OperationProvider(INSERT_AT, INSERT_AT_NAME, new String[]{"object", "pos"}, (EClassifier)oclStdlib.getOclVoid(), (EClassifier)oclStdlib.getT(), (EClassifier)oclStdlib.getInteger()), (AbstractContextualOperations)this.new AbstractContextualOperations.OperationProvider(JOINFIELDS, JOINFIELDS_NAME, new String[]{"sep", "begin", "end"}, (EClassifier)oclStdlib.getString(), (EClassifier)oclStdlib.getString(), (EClassifier)oclStdlib.getString(), (EClassifier)oclStdlib.getString()), (AbstractContextualOperations)this.new AbstractContextualOperations.OperationProvider(AS_SET, AS_SET_NAME, new String[0], (EClassifier)oclStdlib.getSet(), new EClassifier[0]), (AbstractContextualOperations)this.new AbstractContextualOperations.OperationProvider(AS_ORDERED_SET, AS_ORDERED_SET_NAME, new String[0], (EClassifier)oclStdlib.getOrderedSet(), new EClassifier[0]), (AbstractContextualOperations)this.new AbstractContextualOperations.OperationProvider(AS_SEQUENCE, AS_SEQUENCE_NAME, new String[0], (EClassifier)oclStdlib.getSequence(), new EClassifier[0]), (AbstractContextualOperations)this.new AbstractContextualOperations.OperationProvider(AS_BAG, AS_BAG_NAME, new String[0], (EClassifier)oclStdlib.getBag(), new EClassifier[0]), (AbstractContextualOperations)this.new AbstractContextualOperations.OperationProvider(FLATTEN, FLATTEN_NAME, new String[0], (EClassifier)TypeUtil.resolveSequenceType((Environment)this.getStdlib().getEnvironment(), (Object)((EClassifier)oclStdlib.getT2())), new EClassifier[0])};
    }
}

