/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.runtime;

import org.antlr.runtime.BaseRecognizer;
import org.antlr.runtime.CharStream;
import org.antlr.runtime.CommonToken;
import org.antlr.runtime.EarlyExitException;
import org.antlr.runtime.MismatchedNotSetException;
import org.antlr.runtime.MismatchedRangeException;
import org.antlr.runtime.MismatchedSetException;
import org.antlr.runtime.MismatchedTokenException;
import org.antlr.runtime.NoViableAltException;
import org.antlr.runtime.RecognitionException;
import org.antlr.runtime.Token;
import org.antlr.runtime.TokenSource;

public abstract class Lexer
extends BaseRecognizer
implements TokenSource {
    protected CharStream input;
    protected Token token;
    protected int tokenStartCharIndex = -1;
    protected int tokenStartLine;
    protected int tokenStartCharPositionInLine;
    protected int channel;
    protected int type;
    protected String text;

    public Lexer() {
    }

    public Lexer(CharStream charStream) {
        this.input = charStream;
    }

    public void reset() {
        super.reset();
        this.token = null;
        this.type = 0;
        this.channel = 0;
        this.tokenStartCharIndex = -1;
        this.tokenStartCharPositionInLine = -1;
        this.tokenStartLine = -1;
        this.text = null;
        if (this.input != null) {
            this.input.seek(0);
        }
    }

    public Token nextToken() {
        while (true) {
            this.token = null;
            this.channel = 0;
            this.tokenStartCharIndex = this.input.index();
            this.tokenStartCharPositionInLine = this.input.getCharPositionInLine();
            this.tokenStartLine = this.input.getLine();
            this.text = null;
            if (this.input.LA(1) == -1) {
                return Token.EOF_TOKEN;
            }
            try {
                this.mTokens();
                if (this.token == null) {
                    this.emit();
                } else if (this.token == Token.SKIP_TOKEN) continue;
                return this.token;
            }
            catch (RecognitionException recognitionException) {
                this.reportError(recognitionException);
                this.recover(recognitionException);
                continue;
            }
            break;
        }
    }

    public void skip() {
        this.token = Token.SKIP_TOKEN;
    }

    public abstract void mTokens() throws RecognitionException;

    public void setCharStream(CharStream charStream) {
        this.input = null;
        this.reset();
        this.input = charStream;
    }

    public void emit(Token token) {
        this.token = token;
    }

    public Token emit() {
        CommonToken commonToken = new CommonToken(this.input, this.type, this.channel, this.tokenStartCharIndex, this.getCharIndex() - 1);
        commonToken.setLine(this.tokenStartLine);
        commonToken.setText(this.text);
        commonToken.setCharPositionInLine(this.tokenStartCharPositionInLine);
        this.emit(commonToken);
        return commonToken;
    }

    public void match(String string) throws MismatchedTokenException {
        for (int i = 0; i < string.length(); ++i) {
            if (this.input.LA(1) != string.charAt(i)) {
                if (this.backtracking > 0) {
                    this.failed = true;
                    return;
                }
                MismatchedTokenException mismatchedTokenException = new MismatchedTokenException(string.charAt(i), this.input);
                this.recover(mismatchedTokenException);
                throw mismatchedTokenException;
            }
            this.input.consume();
            this.failed = false;
        }
    }

    public void matchAny() {
        this.input.consume();
    }

    public void match(int n) throws MismatchedTokenException {
        if (this.input.LA(1) != n) {
            if (this.backtracking > 0) {
                this.failed = true;
                return;
            }
            MismatchedTokenException mismatchedTokenException = new MismatchedTokenException(n, this.input);
            this.recover(mismatchedTokenException);
            throw mismatchedTokenException;
        }
        this.input.consume();
        this.failed = false;
    }

    public void matchRange(int n, int n2) throws MismatchedRangeException {
        if (this.input.LA(1) < n || this.input.LA(1) > n2) {
            if (this.backtracking > 0) {
                this.failed = true;
                return;
            }
            MismatchedRangeException mismatchedRangeException = new MismatchedRangeException(n, n2, this.input);
            this.recover(mismatchedRangeException);
            throw mismatchedRangeException;
        }
        this.input.consume();
        this.failed = false;
    }

    public int getLine() {
        return this.input.getLine();
    }

    public int getCharPositionInLine() {
        return this.input.getCharPositionInLine();
    }

    public int getCharIndex() {
        return this.input.index();
    }

    public String getText() {
        if (this.text != null) {
            return this.text;
        }
        return this.input.substring(this.tokenStartCharIndex, this.getCharIndex() - 1);
    }

    public void setText(String string) {
        this.text = string;
    }

    public void reportError(RecognitionException recognitionException) {
        this.displayRecognitionError(this.getTokenNames(), recognitionException);
    }

    public String getErrorMessage(RecognitionException recognitionException, String[] stringArray) {
        String string = null;
        if (recognitionException instanceof MismatchedTokenException) {
            MismatchedTokenException mismatchedTokenException = (MismatchedTokenException)recognitionException;
            string = "mismatched character " + this.getCharErrorDisplay(recognitionException.c) + " expecting " + this.getCharErrorDisplay(mismatchedTokenException.expecting);
        } else if (recognitionException instanceof NoViableAltException) {
            NoViableAltException noViableAltException = (NoViableAltException)recognitionException;
            string = "no viable alternative at character " + this.getCharErrorDisplay(recognitionException.c);
        } else if (recognitionException instanceof EarlyExitException) {
            EarlyExitException earlyExitException = (EarlyExitException)recognitionException;
            string = "required (...)+ loop did not match anything at character " + this.getCharErrorDisplay(recognitionException.c);
        } else if (recognitionException instanceof MismatchedSetException) {
            MismatchedSetException mismatchedSetException = (MismatchedSetException)recognitionException;
            string = "mismatched character " + this.getCharErrorDisplay(recognitionException.c) + " expecting set " + mismatchedSetException.expecting;
        } else if (recognitionException instanceof MismatchedNotSetException) {
            MismatchedNotSetException mismatchedNotSetException = (MismatchedNotSetException)recognitionException;
            string = "mismatched character " + this.getCharErrorDisplay(recognitionException.c) + " expecting set " + mismatchedNotSetException.expecting;
        } else if (recognitionException instanceof MismatchedRangeException) {
            MismatchedRangeException mismatchedRangeException = (MismatchedRangeException)recognitionException;
            string = "mismatched character " + this.getCharErrorDisplay(recognitionException.c) + " expecting set " + this.getCharErrorDisplay(mismatchedRangeException.a) + ".." + this.getCharErrorDisplay(mismatchedRangeException.b);
        } else {
            string = super.getErrorMessage(recognitionException, stringArray);
        }
        return string;
    }

    public String getCharErrorDisplay(int n) {
        String string = String.valueOf((char)n);
        switch (n) {
            case -1: {
                string = "<EOF>";
                break;
            }
            case 10: {
                string = "\\n";
                break;
            }
            case 9: {
                string = "\\t";
                break;
            }
            case 13: {
                string = "\\r";
            }
        }
        return "'" + string + "'";
    }

    public void recover(RecognitionException recognitionException) {
        this.input.consume();
    }

    public void traceIn(String string, int n) {
        String string2 = (char)this.input.LT(1) + " line=" + this.getLine() + ":" + this.getCharPositionInLine();
        super.traceIn(string, n, string2);
    }

    public void traceOut(String string, int n) {
        String string2 = (char)this.input.LT(1) + " line=" + this.getLine() + ":" + this.getCharPositionInLine();
        super.traceOut(string, n, string2);
    }
}

