/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.atl.adt.launching;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.AbstractLaunchConfigurationTab;
import org.eclipse.m2m.atl.adt.debug.Messages;
import org.eclipse.m2m.atl.adt.launching.AtlLauncherTools;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class RemoteAtlTab
extends AbstractLaunchConfigurationTab
implements ModifyListener {
    protected static Logger logger = Logger.getLogger("org.eclipse.m2m.atl");
    private Composite container;
    private Group group1;
    private Combo listProject;
    private Label labelProject;
    private Combo listFile;
    private Label labelFile;
    private Group group2;
    private Text textHost;
    private Label labelHost;
    private Text textPort;
    private Label labelPort;

    public void createControl(Composite parent) {
        this.container = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        this.container.setLayout((Layout)layout);
        layout.numColumns = 1;
        layout.verticalSpacing = 9;
        layout.makeColumnsEqualWidth = true;
        this.group1 = new Group(this.container, 0);
        this.labelProject = new Label((Composite)this.group1, 0);
        this.listProject = new Combo((Composite)this.group1, 8);
        this.labelFile = new Label((Composite)this.group1, 0);
        this.listFile = new Combo((Composite)this.group1, 8);
        this.group2 = new Group(this.container, 0);
        this.labelHost = new Label((Composite)this.group2, 0);
        this.textHost = new Text((Composite)this.group2, 2052);
        this.labelPort = new Label((Composite)this.group2, 0);
        this.textPort = new Text((Composite)this.group2, 2052);
        GridData gd = new GridData(768);
        GridData gd2 = new GridData(768);
        this.group1.setLayoutData((Object)gd);
        this.group2.setLayoutData((Object)gd2);
        FormData labelLData = AtlLauncherTools.createFormData(15, 35, 10, 40);
        FormData textLData = AtlLauncherTools.createFormData(45, 75, 10, 40);
        FormData label2LData = AtlLauncherTools.createFormData(15, 35, 60, 90);
        FormData text2LData = AtlLauncherTools.createFormData(45, 75, 60, 90);
        FormLayout groupLayout = new FormLayout();
        this.group1.setText(Messages.getString("RemoteAtlTab.PROJECT"));
        this.labelProject.setLayoutData((Object)labelLData);
        this.labelProject.setText(Messages.getString("RemoteAtlTab.PROJECTNAME"));
        this.listProject.setLayoutData((Object)textLData);
        this.listProject.setItems(AtlLauncherTools.projectNames());
        this.listProject.addModifyListener((ModifyListener)this);
        this.listProject.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                RemoteAtlTab.this.listFile.setItems(AtlLauncherTools.fileNames(RemoteAtlTab.this.listProject.getText()));
            }
        });
        this.labelFile.setLayoutData((Object)label2LData);
        this.labelFile.setText(Messages.getString("RemoteAtlTab.ATLFILENAME"));
        this.listFile.setLayoutData((Object)text2LData);
        this.listFile.addModifyListener((ModifyListener)this);
        this.group1.setLayout((Layout)groupLayout);
        this.group1.layout();
        this.group2.setText(Messages.getString("RemoteAtlTab.CONNECTIONPROPERTIES"));
        this.labelHost.setLayoutData((Object)labelLData);
        this.labelHost.setText(Messages.getString("RemoteAtlTab.HOSTNAME"));
        this.textHost.setLayoutData((Object)textLData);
        this.textHost.addModifyListener((ModifyListener)this);
        this.labelPort.setLayoutData((Object)label2LData);
        this.labelPort.setText(Messages.getString("RemoteAtlTab.PORT"));
        this.textPort.setLayoutData((Object)text2LData);
        this.textPort.addModifyListener((ModifyListener)this);
        this.group2.setLayout((Layout)groupLayout);
        this.group2.layout();
        this.group1.pack();
        this.group2.pack();
        this.container.layout();
        this.container.pack();
        this.setControl((Control)this.container);
        this.canSave();
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy configuration) {
    }

    public void initializeFrom(ILaunchConfiguration configuration) {
        try {
            this.listProject.setText(configuration.getAttribute("Project Name", ""));
            this.listFile.setText(configuration.getAttribute("ATL File Name", ""));
            this.textPort.setText(configuration.getAttribute("Port", ""));
            this.textHost.setText(configuration.getAttribute("Host", ""));
            this.canSave();
            this.updateLaunchConfigurationDialog();
        }
        catch (CoreException e) {
            this.listProject.setText("");
            this.listFile.setText("");
            this.textPort.setText("");
            this.textHost.setText("");
            logger.log(Level.SEVERE, e.getLocalizedMessage(), e);
        }
    }

    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
        configuration.setAttribute("Project Name", this.listProject.getText());
        configuration.setAttribute("ATL File Name", this.listFile.getText());
        configuration.setAttribute("Port", this.textPort.getText());
        configuration.setAttribute("Host", this.textHost.getText());
    }

    public String getName() {
        return AtlLauncherTools.REMOTEATLNAME;
    }

    public boolean canSave() {
        if (this.listProject.getText().equals("")) {
            this.setErrorMessage(Messages.getString("RemoteAtlTab.GIVEPROJECTNAME"));
            return false;
        }
        if (this.listFile.getText().equals("")) {
            this.setErrorMessage(Messages.getString("RemoteAtlTab.GIVETRANSFORMATIONNAME"));
            return false;
        }
        try {
            if (!this.textPort.getText().equals("")) {
                Integer.parseInt(this.textPort.getText());
            }
        }
        catch (NumberFormatException numberFormatException) {
            this.setErrorMessage(Messages.getString("RemoteAtlTab.PORTNOTINTEGER"));
            return false;
        }
        this.setErrorMessage(null);
        return true;
    }

    public Image getImage() {
        return AtlLauncherTools.createImage("icons/atllogo_icon.gif");
    }

    public void modifyText(ModifyEvent e) {
        this.canSave();
        this.updateLaunchConfigurationDialog();
    }
}

