/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.toolsmiths.validation.common.utils;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.DiagnosticChain;
import org.eclipse.papyrus.toolsmiths.validation.common.checkers.DiagnosticEquivalence;
import org.eclipse.papyrus.toolsmiths.validation.common.checkers.IPluginChecker2;

public final class CheckerDiagnosticChain
implements DiagnosticChain,
Iterable<Diagnostic> {
    private final DiagnosticEquivalence diagnosticEquivalence;
    private final List<Diagnostic> diagnostics = new ArrayList<Diagnostic>();
    private int severity;

    public CheckerDiagnosticChain(DiagnosticEquivalence diagnosticEquivalence) {
        this.diagnosticEquivalence = diagnosticEquivalence;
    }

    public CheckerDiagnosticChain() {
        this(DiagnosticEquivalence.DEFAULT);
    }

    public void add(Diagnostic diagnostic) {
        Optional<Diagnostic> existing = !IPluginChecker2.hasDynamicMessage(diagnostic) ? Optional.empty() : this.stream().filter(diag -> this.diagnosticEquivalence.equals((Diagnostic)diag, diagnostic)).findFirst();
        existing.ifPresentOrElse(target -> {
            List targetArgs = IPluginChecker2.MessageArgument.stream(target).collect(Collectors.toList());
            List sourceArgs = IPluginChecker2.MessageArgument.stream(diagnostic).collect(Collectors.toList());
            IntStream.range(0, targetArgs.size()).forEach((int i) -> ((IPluginChecker2.MessageArgument)targetArgs.get(i)).merge((IPluginChecker2.MessageArgument)sourceArgs.get(i)));
        }, () -> {
            this.diagnostics.add(diagnostic);
            this.severity = Math.max(this.severity, diagnostic.getSeverity());
        });
    }

    public void addAll(Diagnostic diagnostic) {
        diagnostic.getChildren().forEach(this::add);
    }

    public void merge(Diagnostic diagnostic) {
        if (diagnostic.getChildren().isEmpty()) {
            this.add(diagnostic);
        } else {
            this.addAll(diagnostic);
        }
    }

    @Override
    public Iterator<Diagnostic> iterator() {
        return Collections.unmodifiableList(this.diagnostics).iterator();
    }

    public Stream<Diagnostic> stream() {
        return this.diagnostics.stream();
    }

    public int getSeverity() {
        return this.severity;
    }
}

