/**
 * Copyright (c) 2008, 2020 Borland Software Corporation, CEA LIST, Artal and others
 * 
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License 2.0
 * which accompanies this distribution, and is available at
 * https://www.eclipse.org/legal/epl-2.0/
 * 
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Contributors:
 *    Artem Tikhomirov (Borland) - initial API and implementation
 *    Michael Golubev (Montages) - #386838 - migrate to Xtend2
 *    Aurelien Didier (ARTAL) - aurelien.didier51@gmail.com - Bug 569174
 */
package impl.actions;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.Arrays;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.papyrus.gmf.codegen.gmfgen.GenAction;
import org.eclipse.papyrus.gmf.codegen.gmfgen.GenDiagram;
import org.eclipse.papyrus.gmf.codegen.gmfgen.GenEditorGenerator;
import org.eclipse.papyrus.gmf.codegen.gmfgen.InitDiagramAction;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.XbaseGenerated;
import xpt.Common_qvto;
import xpt.editor.InitDiagramFileAction;

@Singleton
@SuppressWarnings("all")
public class PredefinedAction {
  @Inject
  @Extension
  private Common_qvto _common_qvto;

  @Inject
  private LoadResourceAction xptLoadResourceAction;

  @Inject
  private CreateShortcutAction xptCreateShortcutAction;

  @Inject
  private InitDiagramFileAction xptInitDiagramFileAction;

  protected CharSequence _Main(final GenAction it) {
    StringConcatenation _builder = new StringConcatenation();
    this._common_qvto.ERROR(("Abstract template for " + it));
    return _builder;
  }

  protected CharSequence _Main(final org.eclipse.papyrus.gmf.codegen.gmfgen.LoadResourceAction it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _Main = this.xptLoadResourceAction.Main(it);
    _builder.append(_Main);
    return _builder;
  }

  protected CharSequence _qualifiedClassName(final GenAction it) {
    StringConcatenation _builder = new StringConcatenation();
    this._common_qvto.ERROR(("Action not supported " + it));
    return _builder;
  }

  protected CharSequence _qualifiedClassName(final org.eclipse.papyrus.gmf.codegen.gmfgen.LoadResourceAction it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _qualifiedClassName = this.xptLoadResourceAction.qualifiedClassName(it);
    _builder.append(_qualifiedClassName);
    return _builder;
  }

  protected CharSequence _className(final org.eclipse.papyrus.gmf.codegen.gmfgen.LoadResourceAction it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _className = this.xptLoadResourceAction.className(it);
    _builder.append(_className);
    return _builder;
  }

  protected CharSequence _fullPath(final org.eclipse.papyrus.gmf.codegen.gmfgen.LoadResourceAction it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _qualifiedClassName = this.qualifiedClassName(it);
    _builder.append(_qualifiedClassName);
    return _builder;
  }

  protected CharSequence _qualifiedClassName(final org.eclipse.papyrus.gmf.codegen.gmfgen.CreateShortcutAction it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _qualifiedClassName = this.xptCreateShortcutAction.qualifiedClassName(it);
    _builder.append(_qualifiedClassName);
    return _builder;
  }

  protected CharSequence _className(final org.eclipse.papyrus.gmf.codegen.gmfgen.CreateShortcutAction it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _className = this.xptCreateShortcutAction.className(it);
    _builder.append(_className);
    return _builder;
  }

  protected CharSequence _fullPath(final org.eclipse.papyrus.gmf.codegen.gmfgen.CreateShortcutAction it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _qualifiedClassName = this.qualifiedClassName(it);
    _builder.append(_qualifiedClassName);
    return _builder;
  }

  protected CharSequence _qualifiedClassName(final GenDiagram it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _qualifiedClassName = this.xptInitDiagramFileAction.qualifiedClassName(it);
    _builder.append(_qualifiedClassName);
    return _builder;
  }

  protected CharSequence _className(final GenDiagram it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _className = this.xptInitDiagramFileAction.className(it);
    _builder.append(_className);
    return _builder;
  }

  protected CharSequence _fullPath(final GenDiagram it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _qualifiedClassName = this.qualifiedClassName(it);
    _builder.append(_qualifiedClassName);
    return _builder;
  }

  /**
   * XXX The reason we need editorGen here as an arument (not xptSelf.owner.editorGen)
   * is we don't have 'honest' InitDiagramAction at the moment, and create it on the fly
   */
  public CharSequence Main(final InitDiagramAction it, final GenEditorGenerator editorGen) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _InitDiagramFileAction = this.xptInitDiagramFileAction.InitDiagramFileAction(it, editorGen);
    _builder.append(_InitDiagramFileAction);
    return _builder;
  }

  /**
   * This one is legal version of the above method
   */
  protected CharSequence _Main(final InitDiagramAction it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _InitDiagramFileAction = this.xptInitDiagramFileAction.InitDiagramFileAction(it, it.getOwner().getEditorGen());
    _builder.append(_InitDiagramFileAction);
    return _builder;
  }

  protected CharSequence _Main(final org.eclipse.papyrus.gmf.codegen.gmfgen.CreateShortcutAction it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _Main = this.xptCreateShortcutAction.Main(it);
    _builder.append(_Main);
    return _builder;
  }

  @XbaseGenerated
  public CharSequence Main(final GenAction it) {
    if (it instanceof org.eclipse.papyrus.gmf.codegen.gmfgen.CreateShortcutAction) {
      return _Main((org.eclipse.papyrus.gmf.codegen.gmfgen.CreateShortcutAction)it);
    } else if (it instanceof InitDiagramAction) {
      return _Main((InitDiagramAction)it);
    } else if (it instanceof org.eclipse.papyrus.gmf.codegen.gmfgen.LoadResourceAction) {
      return _Main((org.eclipse.papyrus.gmf.codegen.gmfgen.LoadResourceAction)it);
    } else if (it != null) {
      return _Main(it);
    } else {
      throw new IllegalArgumentException("Unhandled parameter types: " +
        Arrays.<Object>asList(it).toString());
    }
  }

  @XbaseGenerated
  public CharSequence qualifiedClassName(final EObject it) {
    if (it instanceof org.eclipse.papyrus.gmf.codegen.gmfgen.CreateShortcutAction) {
      return _qualifiedClassName((org.eclipse.papyrus.gmf.codegen.gmfgen.CreateShortcutAction)it);
    } else if (it instanceof GenDiagram) {
      return _qualifiedClassName((GenDiagram)it);
    } else if (it instanceof org.eclipse.papyrus.gmf.codegen.gmfgen.LoadResourceAction) {
      return _qualifiedClassName((org.eclipse.papyrus.gmf.codegen.gmfgen.LoadResourceAction)it);
    } else if (it instanceof GenAction) {
      return _qualifiedClassName((GenAction)it);
    } else {
      throw new IllegalArgumentException("Unhandled parameter types: " +
        Arrays.<Object>asList(it).toString());
    }
  }

  @XbaseGenerated
  public CharSequence className(final EObject it) {
    if (it instanceof org.eclipse.papyrus.gmf.codegen.gmfgen.CreateShortcutAction) {
      return _className((org.eclipse.papyrus.gmf.codegen.gmfgen.CreateShortcutAction)it);
    } else if (it instanceof GenDiagram) {
      return _className((GenDiagram)it);
    } else if (it instanceof org.eclipse.papyrus.gmf.codegen.gmfgen.LoadResourceAction) {
      return _className((org.eclipse.papyrus.gmf.codegen.gmfgen.LoadResourceAction)it);
    } else {
      throw new IllegalArgumentException("Unhandled parameter types: " +
        Arrays.<Object>asList(it).toString());
    }
  }

  @XbaseGenerated
  public CharSequence fullPath(final EObject it) {
    if (it instanceof org.eclipse.papyrus.gmf.codegen.gmfgen.CreateShortcutAction) {
      return _fullPath((org.eclipse.papyrus.gmf.codegen.gmfgen.CreateShortcutAction)it);
    } else if (it instanceof GenDiagram) {
      return _fullPath((GenDiagram)it);
    } else if (it instanceof org.eclipse.papyrus.gmf.codegen.gmfgen.LoadResourceAction) {
      return _fullPath((org.eclipse.papyrus.gmf.codegen.gmfgen.LoadResourceAction)it);
    } else {
      throw new IllegalArgumentException("Unhandled parameter types: " +
        Arrays.<Object>asList(it).toString());
    }
  }
}
