/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.ui.util;

import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public class EditorHelper {
    private EditorHelper() {
    }

    public static Instance getInstance(IWorkbench workbench) {
        return EditorHelper.getInstance(workbench, true);
    }

    public static Instance getInstance(IWorkbench workbench, boolean bestEffort) {
        return new Instance(workbench, bestEffort);
    }

    public static final Shell getActiveShell() {
        IWorkbench workbench = PlatformUI.getWorkbench();
        if (workbench != null) {
            return workbench.getActiveWorkbenchWindow().getShell();
        }
        return Display.getCurrent().getActiveShell();
    }

    public static final IWorkbenchWindow getActiveWindow() {
        IWorkbench workbench = PlatformUI.getWorkbench();
        if (workbench != null) {
            return workbench.getActiveWorkbenchWindow();
        }
        return null;
    }

    public static final IEditorPart getCurrentEditor() {
        IWorkbenchPage activePage;
        IWorkbenchWindow activeWorkbench;
        IWorkbench workbench = PlatformUI.getWorkbench();
        if (workbench != null && (activeWorkbench = workbench.getActiveWorkbenchWindow()) != null && (activePage = activeWorkbench.getActivePage()) != null) {
            return activePage.getActiveEditor();
        }
        return null;
    }

    public static final IWorkbenchPart getActivePart() {
        IWorkbenchPage activePage;
        IWorkbenchWindow activeWorkbench;
        IWorkbench workbench = PlatformUI.getWorkbench();
        if (workbench != null && (activeWorkbench = workbench.getActiveWorkbenchWindow()) != null && (activePage = activeWorkbench.getActivePage()) != null) {
            return activePage.getActivePart();
        }
        return null;
    }

    public static final class Instance {
        private final IWorkbench workbench;
        private final boolean bestEffort;

        private Instance(IWorkbench workbench, boolean bestEffort) {
            this.workbench = workbench;
            this.bestEffort = bestEffort;
        }

        public Shell getActiveShell() {
            IWorkbenchWindow window = this.getActiveWindow();
            return window == null ? Display.getCurrent().getActiveShell() : window.getShell();
        }

        public IWorkbenchWindow getActiveWindow() {
            if (this.workbench == null) {
                return null;
            }
            IWorkbenchWindow result = this.workbench.getActiveWorkbenchWindow();
            if (result == null && this.bestEffort && this.workbench.getWorkbenchWindowCount() > 0) {
                result = this.workbench.getWorkbenchWindows()[0];
            }
            return result;
        }

        public IWorkbenchPage getActivePage() {
            IWorkbenchPage[] pages;
            IWorkbenchPage result = null;
            IWorkbenchWindow window = this.getActiveWindow();
            if (window != null && (result = window.getActivePage()) == null && this.bestEffort && (pages = window.getPages()).length > 0) {
                result = pages[0];
            }
            return result;
        }

        public IEditorPart getActiveEditor() {
            IWorkbenchPage page = this.getActivePage();
            return page == null ? null : page.getActiveEditor();
        }

        public IWorkbenchPart getActivePart() {
            IWorkbenchPage page = this.getActivePage();
            return page == null ? null : page.getActivePart();
        }
    }
}

