/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.ui.dnd;

import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import org.eclipse.swt.dnd.ByteArrayTransfer;
import org.eclipse.swt.dnd.TransferData;

public abstract class PapyrusTransfer<T>
extends ByteArrayTransfer {
    private final Class<? extends T> objectType;
    private final String typeName;
    private final int typeID;
    private Reference<T> object;
    private long startTime;

    protected PapyrusTransfer(Class<? extends T> objectType) {
        this.objectType = objectType;
        this.typeName = String.format("%s:%x:%x", ((Object)((Object)this)).getClass().getSimpleName(), this.hashCode(), System.currentTimeMillis());
        this.typeID = PapyrusTransfer.registerType((String)this.typeName);
    }

    public final int hashCode() {
        return System.identityHashCode((Object)this);
    }

    public void javaToNative(Object object, TransferData transferData) {
        this.setObject(this.objectType.cast(object));
        this.startTime = System.currentTimeMillis();
        if (transferData != null) {
            super.javaToNative((Object)String.valueOf(this.startTime).getBytes(), transferData);
        }
    }

    public Object nativeToJava(TransferData transferData) {
        byte[] bytes = (byte[])super.nativeToJava(transferData);
        if (bytes == null) {
            return null;
        }
        long startTime = Long.parseLong(new String(bytes));
        return this.startTime == startTime ? this.getObject() : null;
    }

    public T getObject() {
        return this.object == null ? null : (T)this.objectType.cast(this.object.get());
    }

    public void setObject(T object) {
        this.object = new WeakReference<T>(object);
    }

    protected int[] getTypeIds() {
        return new int[]{this.typeID};
    }

    protected String[] getTypeNames() {
        return new String[]{this.typeName};
    }
}

