/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.architecture.representation.provider;

import java.util.Collection;
import java.util.List;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.edit.provider.ComposeableAdapterFactory;
import org.eclipse.emf.edit.provider.IItemPropertyDescriptor;
import org.eclipse.emf.edit.provider.ItemPropertyDescriptor;
import org.eclipse.emf.edit.provider.ViewerNotification;
import org.eclipse.papyrus.infra.architecture.representation.PapyrusRepresentationKind;
import org.eclipse.papyrus.infra.architecture.representation.RepresentationFactory;
import org.eclipse.papyrus.infra.architecture.representation.RepresentationPackage;
import org.eclipse.papyrus.infra.core.architecture.ArchitectureDescriptionLanguage;
import org.eclipse.papyrus.infra.core.architecture.provider.RepresentationKindItemProvider;

public class PapyrusRepresentationKindItemProvider
extends RepresentationKindItemProvider {
    public PapyrusRepresentationKindItemProvider(AdapterFactory adapterFactory) {
        super(adapterFactory);
    }

    public List<IItemPropertyDescriptor> getPropertyDescriptors(Object object) {
        if (this.itemPropertyDescriptors == null) {
            super.getPropertyDescriptors(object);
            this.addParentPropertyDescriptor(object);
            this.addImplementationIDPropertyDescriptor(object);
        }
        return this.itemPropertyDescriptors;
    }

    protected void addParentPropertyDescriptor(Object object) {
        this.itemPropertyDescriptors.add(this.createItemPropertyDescriptor((AdapterFactory)((ComposeableAdapterFactory)this.adapterFactory).getRootAdapterFactory(), this.getResourceLocator(), this.getString("_UI_PapyrusRepresentationKind_parent_feature"), this.getString("_UI_PapyrusRepresentationKind_parent_description"), (EStructuralFeature)RepresentationPackage.Literals.PAPYRUS_REPRESENTATION_KIND__PARENT, true, false, true, null, this.getString("_UI_RepresentationKindPropertyCategory"), null));
    }

    protected void addImplementationIDPropertyDescriptor(Object object) {
        this.itemPropertyDescriptors.add(this.createItemPropertyDescriptor((AdapterFactory)((ComposeableAdapterFactory)this.adapterFactory).getRootAdapterFactory(), this.getResourceLocator(), this.getString("_UI_PapyrusRepresentationKind_implementationID_feature"), this.getString("_UI_PapyrusRepresentationKind_implementationID_description"), (EStructuralFeature)RepresentationPackage.Literals.PAPYRUS_REPRESENTATION_KIND__IMPLEMENTATION_ID, true, false, false, ItemPropertyDescriptor.GENERIC_VALUE_IMAGE, this.getString("_UI_RepresentationKindPropertyCategory"), null));
    }

    public Collection<? extends EStructuralFeature> getChildrenFeatures(Object object) {
        if (this.childrenFeatures == null) {
            super.getChildrenFeatures(object);
            this.childrenFeatures.add(RepresentationPackage.Literals.PAPYRUS_REPRESENTATION_KIND__MODEL_RULES);
            this.childrenFeatures.add(RepresentationPackage.Literals.PAPYRUS_REPRESENTATION_KIND__OWNING_RULES);
        }
        return this.childrenFeatures;
    }

    protected EStructuralFeature getChildFeature(Object object, Object child) {
        return super.getChildFeature(object, child);
    }

    public String getText(Object object) {
        String label = ((PapyrusRepresentationKind)object).getName();
        return label == null || label.length() == 0 ? this.getString("_UI_PapyrusRepresentationKind_type") : this.getString("_UI_PapyrusRepresentationKind_type") + " " + label;
    }

    protected static String getTextFor(PapyrusRepresentationKind view) {
        String langName;
        ArchitectureDescriptionLanguage lang = (ArchitectureDescriptionLanguage)view.eContainer();
        if (lang == null) {
            if (view.eIsProxy()) {
                return "<unresolved view> " + String.valueOf(EcoreUtil.getURI((EObject)view));
            }
            langName = null;
        } else {
            langName = lang.getName();
        }
        String viewName = view.getName();
        String viewID = view.getImplementationID();
        if (viewName == null) {
            viewName = "<unnamed view>";
        }
        String format = langName != null ? (viewID != null ? "%1$s :: %2$s [%3$s]" : "%1$s :: %2$s") : (viewID != null ? "%2$s [%3$s]" : "%2$s");
        return String.format(format, langName, viewName, viewID);
    }

    public void notifyChanged(Notification notification) {
        this.updateChildren(notification);
        switch (notification.getFeatureID(PapyrusRepresentationKind.class)) {
            case 11: {
                this.fireNotifyChanged((Notification)new ViewerNotification(notification, notification.getNotifier(), false, true));
                return;
            }
            case 9: 
            case 10: {
                this.fireNotifyChanged((Notification)new ViewerNotification(notification, notification.getNotifier(), true, false));
                return;
            }
        }
        super.notifyChanged(notification);
    }

    protected void collectNewChildDescriptors(Collection<Object> newChildDescriptors, Object object) {
        super.collectNewChildDescriptors(newChildDescriptors, object);
        newChildDescriptors.add(this.createChildParameter(RepresentationPackage.Literals.PAPYRUS_REPRESENTATION_KIND__MODEL_RULES, RepresentationFactory.eINSTANCE.createModelRule()));
        newChildDescriptors.add(this.createChildParameter(RepresentationPackage.Literals.PAPYRUS_REPRESENTATION_KIND__OWNING_RULES, RepresentationFactory.eINSTANCE.createOwningRule()));
    }
}

