/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.core.internal.architecture.merger;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Set;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.papyrus.infra.core.architecture.ArchitectureContext;
import org.eclipse.papyrus.infra.core.architecture.ArchitectureDomain;
import org.eclipse.papyrus.infra.core.architecture.ArchitecturePackage;
import org.eclipse.papyrus.infra.core.internal.architecture.merger.ArchitectureContextRule;
import org.eclipse.papyrus.infra.core.internal.architecture.merger.ArchitectureExtensions;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;

@Singleton
public class ArchitectureContextInheritanceRule {
    @Inject
    @Extension
    private ArchitectureExtensions _architectureExtensions;
    @Inject
    @Extension
    private ArchitectureContextRule _architectureContextRule;
    private final HashMap<ArrayList<?>, ArchitectureContext> _createCache_inherit = CollectionLiterals.newHashMap();

    public boolean legacyContext(ArchitectureContext context) {
        return !this.hasGeneral(context) && !context.isExtension() && !this.hasSpecializations(context) && !this._architectureContextRule.hasExtensions(context);
    }

    public boolean hasGeneral(ArchitectureContext context) {
        ArchitectureContext _generalContext = context.getGeneralContext();
        return _generalContext != null;
    }

    public ArchitectureContext general(ArchitectureContext context) {
        ArchitectureContext _xifexpression = null;
        if (this.hasGeneral(context) && this.canInherit(context, context.getGeneralContext())) {
            _xifexpression = context.getGeneralContext();
        }
        return _xifexpression;
    }

    public boolean hasSpecializations(ArchitectureContext context) {
        return this._architectureExtensions.isReferenced((EObject)context, ArchitecturePackage.Literals.ARCHITECTURE_CONTEXT__GENERAL_CONTEXT);
    }

    public boolean canInherit(ArchitectureContext specific, ArchitectureContext general) {
        EClass _eClass_1;
        EClass _eClass = specific.eClass();
        return _eClass == (_eClass_1 = general.eClass());
    }

    public <T extends ArchitectureContext> Iterable<T> specializations(T context) {
        Functions.Function1 _function = it -> this.canInherit((ArchitectureContext)it, context);
        return IterableExtensions.filter(this._architectureExtensions.invert((EObject)context, ArchitecturePackage.Literals.ARCHITECTURE_CONTEXT__GENERAL_CONTEXT), (Functions.Function1)_function);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArchitectureContext inherit(ArchitectureContext context) {
        ArchitectureContext _result;
        ArrayList _cacheKey = CollectionLiterals.newArrayList((Object[])new ArchitectureContext[]{context});
        HashMap<ArrayList<?>, ArchitectureContext> hashMap = this._createCache_inherit;
        synchronized (hashMap) {
            if (this._createCache_inherit.containsKey(_cacheKey)) {
                return this._createCache_inherit.get(_cacheKey);
            }
            _result = context;
            this._createCache_inherit.put(_cacheKey, _result);
        }
        this._init_inherit(_result, context);
        return _result;
    }

    private void _init_inherit(ArchitectureContext it, ArchitectureContext context) {
        if (this.hasGeneral(context) && this.canInherit(context, context.getGeneralContext())) {
            this.inherit(context, this.inherit(context.getGeneralContext()));
        }
    }

    private Set<ArchitectureContext> inherit(ArchitectureContext specific, ArchitectureContext general) {
        Functions.Function0 _function = () -> this._architectureContextRule.merge(specific, general);
        return (Set)this._architectureExtensions.withScope((Iterable<? extends ArchitectureDomain>)CollectionLiterals.newLinkedHashSet((Object[])new ArchitectureDomain[]{specific.getDomain(), general.getDomain()}), _function);
    }

    public void finalizeInheritance(ArchitectureContext context) {
        context.setGeneralContext(null);
    }
}

