/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.nattable.properties.modelelement;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.papyrus.infra.emf.utils.EMFHelper;
import org.eclipse.papyrus.infra.nattable.manager.table.INattableModelManager;
import org.eclipse.papyrus.infra.nattable.model.nattable.Table;
import org.eclipse.papyrus.infra.nattable.properties.Activator;
import org.eclipse.papyrus.infra.nattable.properties.modelelement.NatTableModelElement;
import org.eclipse.papyrus.infra.nattable.properties.utils.NatTableEditorUtils;
import org.eclipse.papyrus.infra.nattable.utils.TableEditingDomainUtils;
import org.eclipse.papyrus.infra.properties.contexts.DataContextElement;
import org.eclipse.papyrus.infra.properties.ui.modelelement.EMFModelElement;
import org.eclipse.papyrus.infra.properties.ui.modelelement.EMFModelElementFactory;

public class NatTableFactory
extends EMFModelElementFactory {
    protected EMFModelElement doCreateFromSource(Object sourceElement, DataContextElement context) {
        TransactionalEditingDomain domain;
        INattableModelManager nattableManager;
        EObject source = EMFHelper.getEObject((Object)sourceElement);
        if (source == null) {
            Activator.log.warn("Unable to resolve the selected element to an EObject");
            return null;
        }
        if (source instanceof Table && (nattableManager = NatTableEditorUtils.getCurrentNatTableModelManager()) != null && source == nattableManager.getTable() && (domain = TableEditingDomainUtils.getTableEditingDomain((Table)nattableManager.getTable())) != null) {
            return new NatTableModelElement(nattableManager, (EditingDomain)domain);
        }
        return super.doCreateFromSource(sourceElement, context);
    }

    protected void updateModelElement(EMFModelElement modelElement, Object newSourceElement) {
        EObject eObject = EMFHelper.getEObject((Object)newSourceElement);
        if (eObject == null) {
            throw new IllegalArgumentException("Cannot resolve EObject selection: " + String.valueOf(newSourceElement));
        }
        if (modelElement instanceof NatTableModelElement && eObject instanceof Table) {
            NatTableFactory.updateTableModelElement((NatTableModelElement)modelElement, (Table)eObject);
        }
        NatTableFactory.updateEMFModelElement((EMFModelElement)modelElement, (EObject)eObject);
    }

    public static void updateTableModelElement(NatTableModelElement nattableModelElement, Table table) {
        nattableModelElement.table = table;
    }
}

