/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.nattable.manager.cell;

import java.util.Map;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.papyrus.infra.nattable.manager.cell.AbstractCellManager;
import org.eclipse.papyrus.infra.nattable.manager.table.INattableModelManager;
import org.eclipse.papyrus.infra.nattable.utils.AxisUtils;

public abstract class AbstractEmptyAxisCellManager
extends AbstractCellManager {
    private final String tableKindId;

    public AbstractEmptyAxisCellManager(String tableKindId) {
        this.tableKindId = tableKindId;
    }

    @Override
    public boolean handles(Object columnElement, Object rowElement, INattableModelManager tableManager) {
        Object column = AxisUtils.getRepresentedElement(columnElement);
        Object row = AxisUtils.getRepresentedElement(rowElement);
        return this.tableKindId.equals(tableManager.getTable().getTableKindId()) && (column == null || row == null);
    }

    @Override
    protected Object doGetValue(Object columnElement, Object rowElement, INattableModelManager tableManager) {
        return "";
    }

    @Override
    public boolean isCellEditable(Object columnElement, Object rowElement, INattableModelManager tableManager) {
        return false;
    }

    @Override
    public boolean isCellEditable(Object columnElement, Object rowElement, Map<?, ?> sharedMap, INattableModelManager tableManager) {
        return false;
    }

    @Override
    public void unsetCellValue(TransactionalEditingDomain domain, Object columnElement, Object rowElement, INattableModelManager tableManager) {
    }

    @Override
    public Command getUnsetCellValueCommand(TransactionalEditingDomain domain, Object columnElement, Object rowElement, INattableModelManager tableManager) {
        return null;
    }

    @Override
    public Command getSetValueCommand(TransactionalEditingDomain domain, Object columnElement, Object rowElement, Object newValue, INattableModelManager tableManager) {
        return null;
    }
}

