/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.views.modelexplorer.core.ui.pagebookview;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.papyrus.infra.ui.editor.IMultiDiagramEditor;
import org.eclipse.papyrus.views.modelexplorer.Activator;
import org.eclipse.papyrus.views.modelexplorer.core.ui.pagebookview.DefaultPage;
import org.eclipse.papyrus.views.modelexplorer.core.ui.pagebookview.ViewPageSite;
import org.eclipse.papyrus.views.modelexplorer.core.ui.pagebookview.ViewPartPage;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.IPage;
import org.eclipse.ui.part.IPageBookViewPage;
import org.eclipse.ui.part.PageBook;
import org.eclipse.ui.part.PageBookView;

public abstract class MultiViewPageBookView
extends PageBookView {
    private IMemento memento;

    protected IPageBookViewPage createDefaultPage(PageBook book) {
        DefaultPage page = new DefaultPage();
        this.initPage((IPageBookViewPage)page);
        page.createControl((Composite)book);
        return page;
    }

    protected abstract PageBookView.PageRec doCreatePage(IWorkbenchPart var1);

    protected void doDestroyPage(IWorkbenchPart part, PageBookView.PageRec pageRecord) {
        pageRecord.page.dispose();
    }

    protected IWorkbenchPart getBootstrapPart() {
        IEditorPart part = null;
        try {
            IWorkbenchPage activePage;
            IWorkbenchWindow activeWorkbenchWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
            if (activeWorkbenchWindow != null && (activePage = activeWorkbenchWindow.getActivePage()) != null) {
                part = activePage.getActiveEditor();
            }
        }
        catch (NullPointerException e) {
            return null;
        }
        if (this.isImportant((IWorkbenchPart)part)) {
            return part;
        }
        return null;
    }

    protected boolean isImportant(IWorkbenchPart part) {
        return part instanceof IMultiDiagramEditor;
    }

    public void init(IViewSite site, IMemento memento) throws PartInitException {
        super.init(site, memento);
        this.memento = memento;
    }

    protected void initPage(ViewPartPage page, IWorkbenchPart part) {
        try {
            page.init(part, new ViewPageSite(this.getViewSite()), this.memento, this.getConfigurationElement());
        }
        catch (PartInitException e) {
            Activator.log.error("initPage", (Throwable)e);
        }
        catch (CoreException e) {
            Activator.log.error("initPage", (Throwable)e);
        }
    }

    public IViewPart getActiveView() {
        IPage page = this.getCurrentPage();
        if (page instanceof ViewPartPage) {
            return ((ViewPartPage)page).getViewer();
        }
        return null;
    }
}

