/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.menu.actions.handlers;

import java.util.List;
import java.util.ListIterator;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.draw2d.Animation;
import org.eclipse.gef.ConnectionEditPart;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.UnexecutableCommand;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.parts.DiagramCommandStack;
import org.eclipse.gmf.runtime.diagram.ui.parts.IDiagramGraphicalViewer;
import org.eclipse.gmf.runtime.diagram.ui.parts.IDiagramWorkbenchPart;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.papyrus.uml.diagram.menu.actions.ArrangeAction;
import org.eclipse.papyrus.uml.diagram.menu.actions.handlers.AbstractGraphicalCommandHandler;
import org.eclipse.ui.IWorkbenchPart;

public class ArrangeHandler
extends AbstractGraphicalCommandHandler {
    public static final String parameterID = "arrange_parameter";

    public ArrangeHandler(String parameter) {
        super(parameterID, parameter);
    }

    public ArrangeHandler() {
        super(parameterID);
    }

    @Override
    protected Command getCommand() throws ExecutionException {
        ArrangeAction action = new ArrangeAction(this.parameter, this.getSelectedElements());
        Command cmd = action.getCommand();
        return cmd == null ? UnexecutableCommand.INSTANCE : cmd;
    }

    @Override
    public Object execute(ExecutionEvent event) throws ExecutionException {
        this.doRun((IProgressMonitor)new NullProgressMonitor());
        return null;
    }

    protected void doRun(IProgressMonitor progressMonitor) {
        DiagramCommandStack stack;
        IPreferenceStore preferenceStore = (IPreferenceStore)this.getDiagramEditPart().getDiagramPreferencesHint().getPreferenceStore();
        boolean animatedLayout = preferenceStore.getBoolean("Global.enableAnimatedLayout");
        if (animatedLayout) {
            Animation.markBegin();
        }
        if ((stack = this.getDiagramCommandStack()) != null) {
            try {
                stack.execute(this.getCommand(), progressMonitor);
            }
            catch (ExecutionException e) {
                e.printStackTrace();
            }
        } else {
            return;
        }
        if (animatedLayout) {
            EditPart container;
            int durationInc = 800;
            int factor = 10;
            int size = 0;
            List<IGraphicalEditPart> operationSet = this.getSelectedElements();
            if ("arrangeAll".equals(this.parameter)) {
                for (IGraphicalEditPart element : operationSet) {
                    size += element.getFigure().getChildren().size();
                }
            } else if (operationSet != null && !operationSet.isEmpty() && (container = this.getSelectionParent(operationSet)) instanceof IGraphicalEditPart) {
                size += ((IGraphicalEditPart)container).getFigure().getChildren().size();
            }
            int totalDuration = Math.min(durationInc * factor / 2, Math.max(durationInc, size / factor * durationInc));
            Animation.run((int)totalDuration);
        }
    }

    private EditPart getSelectionParent(List editparts) {
        ListIterator li = editparts.listIterator();
        while (li.hasNext()) {
            Object obj = li.next();
            if (obj instanceof ConnectionEditPart || !(obj instanceof EditPart)) continue;
            return ((EditPart)obj).getParent();
        }
        return null;
    }

    @Override
    protected IDiagramGraphicalViewer getDiagramGraphicalViewer() {
        IDiagramWorkbenchPart part = this.getDiagramWorkbenchPart();
        return part != null ? part.getDiagramGraphicalViewer() : null;
    }

    @Override
    protected IDiagramWorkbenchPart getDiagramWorkbenchPart() {
        IDiagramWorkbenchPart diagramPart = null;
        IWorkbenchPart part = this.getWorkbenchPart();
        if (part instanceof IDiagramWorkbenchPart) {
            diagramPart = (IDiagramWorkbenchPart)part;
        } else if (part != null) {
            diagramPart = (IDiagramWorkbenchPart)part.getAdapter(IDiagramWorkbenchPart.class);
        }
        return diagramPart;
    }
}

