/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.service.types.helper.advice;

import java.util.ArrayList;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.emf.type.core.commands.ConfigureElementCommand;
import org.eclipse.gmf.runtime.emf.type.core.edithelper.AbstractEditHelperAdvice;
import org.eclipse.gmf.runtime.emf.type.core.requests.ConfigureRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.DestroyDependentsRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.IEditCommandRequest;
import org.eclipse.papyrus.infra.emf.utils.EMFHelper;
import org.eclipse.papyrus.infra.tools.util.TypeUtils;
import org.eclipse.uml2.uml.ConnectableElement;
import org.eclipse.uml2.uml.ExecutionSpecification;
import org.eclipse.uml2.uml.InteractionFragment;
import org.eclipse.uml2.uml.Lifeline;
import org.eclipse.uml2.uml.MessageOccurrenceSpecification;
import org.eclipse.uml2.uml.OccurrenceSpecification;
import org.eclipse.uml2.uml.PartDecomposition;

public class LifelineHelperAdvice
extends AbstractEditHelperAdvice {
    public static final String REPRESENTS = "Lifeline::represents";

    public void configureRequest(IEditCommandRequest request) {
    }

    protected ICommand getBeforeConfigureCommand(ConfigureRequest request) {
        ConfigureElementCommand command = null;
        final ConnectableElement represents = (ConnectableElement)TypeUtils.as((Object)request.getParameter(REPRESENTS), ConnectableElement.class);
        final Lifeline lifeline = (Lifeline)request.getElementToConfigure();
        if (lifeline != null && represents != null) {
            command = new ConfigureElementCommand(request){

                protected CommandResult doExecuteWithResult(IProgressMonitor progressMonitor, IAdaptable info) throws ExecutionException {
                    lifeline.setRepresents(represents);
                    return CommandResult.newOKCommandResult((Object)lifeline);
                }
            };
        }
        return command;
    }

    protected ICommand getBeforeDestroyDependentsCommand(DestroyDependentsRequest request) {
        ArrayList<Object> dependentsToDestroy = new ArrayList<Object>();
        Lifeline lifeline = (Lifeline)request.getElementToDestroy();
        for (InteractionFragment ift : lifeline.getCoveredBys()) {
            if (ift instanceof ExecutionSpecification) {
                dependentsToDestroy.add(ift);
            }
            if (ift instanceof MessageOccurrenceSpecification && ((MessageOccurrenceSpecification)ift).getMessage() != null) {
                dependentsToDestroy.add(((MessageOccurrenceSpecification)ift).getMessage());
            }
            if (!(ift instanceof OccurrenceSpecification)) continue;
            dependentsToDestroy.add(ift);
        }
        PartDecomposition decomposition = lifeline.getDecomposedAs();
        if (decomposition != null && EMFHelper.isOnlyUsage((EObject)decomposition, (EObject)lifeline)) {
            dependentsToDestroy.add(decomposition);
        }
        if (!dependentsToDestroy.isEmpty()) {
            return request.getDestroyDependentsCommand(dependentsToDestroy);
        }
        return null;
    }
}

