/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.service.types.helper.advice;

import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.common.core.command.CompositeCommand;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.emf.commands.core.command.AbstractTransactionalCommand;
import org.eclipse.gmf.runtime.emf.type.core.commands.SetValueCommand;
import org.eclipse.gmf.runtime.emf.type.core.requests.AbstractEditCommandRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.ConfigureRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.ReorientRelationshipRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.SetRequest;
import org.eclipse.papyrus.uml.service.types.helper.advice.AbstractOccurrenceLinkEditHelperAdvice;
import org.eclipse.papyrus.uml.tools.utils.NamedElementUtil;
import org.eclipse.uml2.uml.Duration;
import org.eclipse.uml2.uml.DurationConstraint;
import org.eclipse.uml2.uml.DurationInterval;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Interaction;
import org.eclipse.uml2.uml.OccurrenceSpecification;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.UMLFactory;
import org.eclipse.uml2.uml.UMLPackage;
import org.eclipse.uml2.uml.ValueSpecification;

public class DurationConstraintEditHelperAdvice
extends AbstractOccurrenceLinkEditHelperAdvice {
    private void initDurationInterval(DurationInterval durationInterval) {
        Package parent = durationInterval.getNearestPackage();
        Duration minDuration = UMLFactory.eINSTANCE.createDuration();
        Duration maxDuration = UMLFactory.eINSTANCE.createDuration();
        parent.getPackagedElements().add((Object)minDuration);
        parent.getPackagedElements().add((Object)maxDuration);
        String nameMin = NamedElementUtil.getDefaultNameWithIncrement((String)"Min", (EObject)minDuration, (Collection)minDuration.getNearestPackage().getPackagedElements());
        String nameMax = NamedElementUtil.getDefaultNameWithIncrement((String)"Max", (EObject)maxDuration, (Collection)maxDuration.getNearestPackage().getPackagedElements());
        minDuration.setName(nameMin);
        maxDuration.setName(nameMax);
        durationInterval.setMin((ValueSpecification)minDuration);
        durationInterval.setMax((ValueSpecification)maxDuration);
        minDuration.setExpr((ValueSpecification)UMLFactory.eINSTANCE.createLiteralInteger());
        maxDuration.setExpr((ValueSpecification)UMLFactory.eINSTANCE.createLiteralInteger());
    }

    protected ICommand getAfterConfigureCommand(ConfigureRequest request) {
        EObject toConfigure;
        CompositeCommand composite = new CompositeCommand("After Configure Command of DurationConstraint");
        ICommand afterConfigureCommand = super.getAfterConfigureCommand(request);
        if (afterConfigureCommand != null && afterConfigureCommand.canExecute()) {
            composite.compose((IUndoableOperation)afterConfigureCommand);
        }
        if (!((toConfigure = request.getElementToConfigure()) instanceof DurationConstraint)) {
            return composite;
        }
        final DurationConstraint constraint = (DurationConstraint)toConfigure;
        AbstractTransactionalCommand initInterval = new AbstractTransactionalCommand(request.getEditingDomain(), "Init DurationConstraint Specification", null){

            protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
                if (constraint.getSpecification() instanceof DurationInterval) {
                    DurationConstraintEditHelperAdvice.this.initDurationInterval((DurationInterval)constraint.getSpecification());
                }
                return CommandResult.newOKCommandResult();
            }
        };
        composite.compose((IUndoableOperation)initInterval);
        final Element source = this.getSourceElement((AbstractEditCommandRequest)request);
        final Element target = this.getTargetElement((AbstractEditCommandRequest)request);
        if (source != null && target != null) {
            AbstractTransactionalCommand initConstrainedElements = new AbstractTransactionalCommand(request.getEditingDomain(), "Init DurationConstraint constrained elements", null){

                protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
                    constraint.getConstrainedElements().add(0, (Object)source);
                    if (target != source) {
                        constraint.getConstrainedElements().add(1, (Object)target);
                    }
                    return CommandResult.newOKCommandResult();
                }
            };
            composite.compose((IUndoableOperation)initConstrainedElements);
        }
        return composite;
    }

    protected ICommand getAfterReorientRelationshipCommand(ReorientRelationshipRequest request) {
        EObject relationship = request.getRelationship();
        if (relationship instanceof DurationConstraint) {
            DurationConstraint constraint = (DurationConstraint)relationship;
            EObject newEnd = request.getNewRelationshipEnd();
            if (newEnd instanceof OccurrenceSpecification) {
                OccurrenceSpecification newOccurrence = (OccurrenceSpecification)newEnd;
                ArrayList<OccurrenceSpecification> values = new ArrayList<OccurrenceSpecification>((Collection<OccurrenceSpecification>)constraint.getConstrainedElements());
                if (request.getDirection() == 1) {
                    if (values.isEmpty()) {
                        values.add(newOccurrence);
                    } else if (values.size() == 1) {
                        values.add(0, newOccurrence);
                    } else {
                        if (values.get(0) == newOccurrence) {
                            return null;
                        }
                        values.set(0, newOccurrence);
                    }
                } else if (values.isEmpty()) {
                    values.add(newOccurrence);
                } else if (values.size() == 1) {
                    values.add(newOccurrence);
                } else {
                    if (values.get(1) == newOccurrence) {
                        return null;
                    }
                    values.set(1, newOccurrence);
                }
                SetRequest setRequest = new SetRequest((EObject)constraint, (EStructuralFeature)UMLPackage.Literals.CONSTRAINT__CONSTRAINED_ELEMENT, values);
                return new SetValueCommand(setRequest);
            }
        }
        return super.getAfterReorientRelationshipCommand(request);
    }

    @Override
    protected Element getCreationContainer(Element targetElement) {
        return this.findInteraction(targetElement);
    }

    protected Interaction findInteraction(Element source) {
        Element element = source;
        while (element != null) {
            if (element instanceof Interaction) {
                return (Interaction)element;
            }
            element = element.getOwner();
        }
        return null;
    }
}

