/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.service.types.helper.advice;

import com.google.common.collect.Iterables;
import java.util.Collection;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.emf.type.core.IElementType;
import org.eclipse.gmf.runtime.emf.type.core.commands.ConfigureElementCommand;
import org.eclipse.gmf.runtime.emf.type.core.requests.ConfigureRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.CreateElementRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.DestroyElementRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.IEditCommandRequest;
import org.eclipse.papyrus.infra.services.edit.commands.InsertAtCommand;
import org.eclipse.papyrus.uml.service.types.element.UMLElementTypes;
import org.eclipse.papyrus.uml.service.types.helper.advice.InteractionContainerDeletionContext;
import org.eclipse.papyrus.uml.service.types.helper.advice.InteractionFragmentEditHelperAdvice;
import org.eclipse.papyrus.uml.service.types.utils.ElementUtil;
import org.eclipse.papyrus.uml.service.types.utils.RequestParameterUtils;
import org.eclipse.papyrus.uml.tools.utils.NamedElementUtil;
import org.eclipse.uml2.uml.CombinedFragment;
import org.eclipse.uml2.uml.InteractionOperand;
import org.eclipse.uml2.uml.Lifeline;
import org.eclipse.uml2.uml.UMLFactory;

public class CombinedFragmentEditHelperAdvice
extends InteractionFragmentEditHelperAdvice {
    public void configureRequest(IEditCommandRequest request) {
        CreateElementRequest createRequest;
        IElementType typeToCreate;
        super.configureRequest(request);
        if (request instanceof CreateElementRequest && ElementUtil.isTypeOf(typeToCreate = (createRequest = (CreateElementRequest)request).getElementType(), (IElementType)UMLElementTypes.INTERACTION_OPERAND)) {
            CombinedFragment combinedFragment = (CombinedFragment)createRequest.getContainer();
            RequestParameterUtils.setCoveredLifelines(request, (Iterable<Lifeline>)combinedFragment.getCovereds());
        }
    }

    @Override
    protected ICommand getBeforeConfigureCommand(final ConfigureRequest request) {
        ICommand superResult = super.getBeforeConfigureCommand(request);
        ConfigureElementCommand result = new ConfigureElementCommand(request){

            protected CommandResult doExecuteWithResult(IProgressMonitor progressMonitor, IAdaptable info) throws ExecutionException {
                CombinedFragment combinedFragment = (CombinedFragment)request.getElementToConfigure();
                InteractionOperand interactionOperand = CombinedFragmentEditHelperAdvice.createInteractionOperand();
                interactionOperand.setName(NamedElementUtil.getDefaultNameWithIncrement((EObject)interactionOperand, (Collection)combinedFragment.eContents()));
                combinedFragment.getOperands().add((Object)interactionOperand);
                Iterable<Lifeline> coveredLifelines = RequestParameterUtils.getCoveredLifelines((IEditCommandRequest)request);
                Iterables.addAll((Collection)interactionOperand.getCovereds(), coveredLifelines);
                return CommandResult.newOKCommandResult((Object)combinedFragment);
            }
        };
        return superResult != null ? superResult.compose((IUndoableOperation)result) : result;
    }

    protected ICommand getAfterCreateCommand(CreateElementRequest request) {
        ICommand afterCreateCommand = super.getAfterCreateCommand(request);
        if (request.getParameter("InsertAt") instanceof Integer) {
            InsertAtCommand insertAtCommand = new InsertAtCommand(request);
            return afterCreateCommand == null ? insertAtCommand : afterCreateCommand.compose((IUndoableOperation)insertAtCommand);
        }
        return afterCreateCommand;
    }

    public static InteractionOperand createInteractionOperand() {
        InteractionOperand interactionOperand = UMLFactory.eINSTANCE.createInteractionOperand();
        interactionOperand.createGuard("guard");
        return interactionOperand;
    }

    protected ICommand getBeforeDestroyElementCommand(DestroyElementRequest req) {
        InteractionContainerDeletionContext.deleting(req);
        return super.getBeforeDestroyElementCommand(req);
    }
}

