/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.service.types.helper;

import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gmf.runtime.common.core.command.CompositeCommand;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.common.core.command.UnexecutableCommand;
import org.eclipse.gmf.runtime.diagram.core.commands.DeleteCommand;
import org.eclipse.gmf.runtime.diagram.core.util.ViewUtil;
import org.eclipse.gmf.runtime.emf.type.core.requests.ConfigureRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.CreateElementRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.IEditCommandRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.MoveRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.SetRequest;
import org.eclipse.gmf.runtime.notation.Edge;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.infra.services.edit.commands.IConfigureCommandFactory;
import org.eclipse.papyrus.infra.services.edit.service.ElementEditServiceUtils;
import org.eclipse.papyrus.infra.services.edit.service.IElementEditService;
import org.eclipse.papyrus.uml.diagram.common.util.CrossReferencerUtil;
import org.eclipse.papyrus.uml.service.types.Activator;
import org.eclipse.papyrus.uml.service.types.command.StereotypeApplicationMoveCommand;
import org.eclipse.papyrus.uml.tools.model.UmlUtils;
import org.eclipse.papyrus.uml.types.core.edithelper.DefaultUMLEditHelper;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.UMLPackage;

public class ElementEditHelper
extends DefaultUMLEditHelper {
    private static final String CONTAINMENT_LINK_TYPE = "Element_ContainmentEdge";

    protected ICommand getEditServiceCommand(EObject context, IEditCommandRequest request) {
        ICommand result = null;
        IElementEditService provider = ElementEditServiceUtils.getCommandProvider((EObject)context);
        if (provider != null) {
            result = provider.getEditCommand(request);
        }
        return result;
    }

    protected ICommand getConfigureCommand(ConfigureRequest req) {
        if (req.getParameter("IConfigureCommandFactory_ID") != null) {
            IConfigureCommandFactory factory = (IConfigureCommandFactory)req.getParameter("IConfigureCommandFactory_ID");
            return factory.create(req);
        }
        return super.getConfigureCommand(req);
    }

    protected Map<EClass, EReference> getDefaultContainmentFeatures() {
        return super.getDefaultContainmentFeatures();
    }

    protected boolean approveRequest(IEditCommandRequest request) {
        Object context;
        boolean result = super.approveRequest(request);
        if (!result && request instanceof CreateElementRequest && (context = request.getEditHelperContext()) instanceof EObject) {
            EObject owner = (EObject)context;
            EReference reference = this.getContainmentFeature((CreateElementRequest)request);
            if (reference != null && reference.getEContainingClass() != null && reference.getEContainingClass().isSuperTypeOf(owner.eClass()) && !reference.isContainment()) {
                for (EReference next : UmlUtils.getSupersets((EReference)reference)) {
                    if (!next.isContainment()) continue;
                    result = true;
                    break;
                }
            }
        }
        return result;
    }

    protected ICommand getMoveCommand(MoveRequest req) {
        Map elementsToMove;
        ICommand moveCommand = super.getMoveCommand(req);
        EObject targetContainer = req.getTargetContainer();
        if (targetContainer instanceof Element && (elementsToMove = req.getElementsToMove()) != null) {
            for (Object object : elementsToMove.keySet()) {
                ICommand moveStereotypeCommand;
                boolean alsoMoveStereotypeApplication;
                if (!(object instanceof Element)) continue;
                Element element = (Element)object;
                ICommand deleteContainmentLinks = this.getDeleteContainmentLinkCommand(req.getEditingDomain(), element, (Element)targetContainer);
                if (deleteContainmentLinks.canExecute()) {
                    moveCommand = CompositeCommand.compose((ICommand)moveCommand, (ICommand)deleteContainmentLinks);
                }
                if (!(alsoMoveStereotypeApplication = Activator.getDefault().getPreferenceStore().getBoolean("MOVE_STEREOTYPEAPPLICATION_ELEMENT_IN_SAME_RESOURCE")) || !(moveStereotypeCommand = this.getMoveStereotypeCommand(req, element, element.eResource(), targetContainer.eResource())).canExecute()) continue;
                moveCommand = CompositeCommand.compose((ICommand)moveCommand, (ICommand)moveStereotypeCommand);
            }
        }
        return moveCommand;
    }

    protected ICommand getSetCommand(SetRequest req) {
        Object value;
        EObject elementToEdit;
        ICommand setCommand = super.getSetCommand(req);
        EStructuralFeature feature = req.getFeature();
        if ((UMLPackage.eINSTANCE.getPackage_PackagedElement().equals(feature) || UMLPackage.eINSTANCE.getClass_NestedClassifier().equals(feature)) && (elementToEdit = req.getElementToEdit()) instanceof Element && (value = req.getValue()) instanceof List) {
            for (Object object : (List)value) {
                ICommand deleteContainmentLinks;
                if (!(object instanceof Element) || !(deleteContainmentLinks = this.getDeleteContainmentLinkCommand(req.getEditingDomain(), (Element)object, (Element)elementToEdit)).canExecute()) continue;
                setCommand = CompositeCommand.compose((ICommand)setCommand, (ICommand)deleteContainmentLinks);
            }
        }
        return setCommand;
    }

    private ICommand getDeleteContainmentLinkCommand(TransactionalEditingDomain editingDomain, Element element, Element targetContainer) {
        CompositeCommand cc = new CompositeCommand("Remove all invalid containment links");
        if (targetContainer != element.getOwner()) {
            Iterator viewIt = CrossReferencerUtil.getCrossReferencingViews((EObject)element, null).iterator();
            while (viewIt.hasNext()) {
                for (Edge edge : ViewUtil.getTargetConnections((View)((View)viewIt.next()))) {
                    if (!CONTAINMENT_LINK_TYPE.equals(edge.getType())) continue;
                    DeleteCommand destroyViewsCommand = new DeleteCommand(editingDomain, (View)edge);
                    cc = CompositeCommand.compose((ICommand)cc, (ICommand)destroyViewsCommand);
                }
            }
        }
        return cc;
    }

    private ICommand getMoveStereotypeCommand(MoveRequest request, Element element, Resource source, Resource target) {
        if (target != null && !target.equals(source)) {
            return new StereotypeApplicationMoveCommand(request.getEditingDomain(), element, source, target);
        }
        return UnexecutableCommand.INSTANCE;
    }
}

