/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.clazz.custom.helper;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.gef.commands.UnexecutableCommand;
import org.eclipse.gmf.runtime.common.core.command.CompositeCommand;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.diagram.core.preferences.PreferencesHint;
import org.eclipse.gmf.runtime.diagram.ui.commands.CreateCommand;
import org.eclipse.gmf.runtime.diagram.ui.commands.ICommandProxy;
import org.eclipse.gmf.runtime.diagram.ui.commands.SetBoundsCommand;
import org.eclipse.gmf.runtime.diagram.ui.editparts.CompartmentEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.GraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.internal.commands.SetConnectionBendpointsCommand;
import org.eclipse.gmf.runtime.diagram.ui.requests.CreateConnectionViewAndElementRequest;
import org.eclipse.gmf.runtime.diagram.ui.requests.CreateConnectionViewRequest;
import org.eclipse.gmf.runtime.diagram.ui.requests.CreateViewRequest;
import org.eclipse.gmf.runtime.emf.core.util.EObjectAdapter;
import org.eclipse.gmf.runtime.emf.type.core.IHintedType;
import org.eclipse.gmf.runtime.emf.type.core.commands.SetValueCommand;
import org.eclipse.gmf.runtime.emf.type.core.requests.SetRequest;
import org.eclipse.gmf.runtime.notation.Edge;
import org.eclipse.gmf.runtime.notation.Node;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.infra.gmfdiag.common.adapter.SemanticAdapter;
import org.eclipse.papyrus.uml.diagram.clazz.custom.command.CustomDeferredCreateConnectionViewCommand;
import org.eclipse.papyrus.uml.diagram.clazz.custom.command.DependencyDiamonViewCreateCommand;
import org.eclipse.papyrus.uml.diagram.clazz.edit.parts.DependencyBranchEditPart;
import org.eclipse.papyrus.uml.diagram.clazz.edit.parts.DependencyNodeEditPart;
import org.eclipse.papyrus.uml.diagram.clazz.providers.UMLElementTypes;
import org.eclipse.papyrus.uml.diagram.common.commands.DeleteLinkDuringCreationCommand;
import org.eclipse.papyrus.uml.diagram.common.helper.Element2IAdaptableRegistryHelper;
import org.eclipse.papyrus.uml.diagram.common.helper.ElementHelper;
import org.eclipse.uml2.uml.Dependency;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.UMLPackage;

public class MultiDependencyHelper
extends ElementHelper {
    private final Element2IAdaptableRegistryHelper myVirtualNodesRegistry;

    public MultiDependencyHelper(TransactionalEditingDomain editDomain) {
        this(editDomain, new Element2IAdaptableRegistryHelper());
    }

    public MultiDependencyHelper(TransactionalEditingDomain editDomain, Element2IAdaptableRegistryHelper virtualNodesRegistry) {
        this.editDomain = editDomain;
        this.myVirtualNodesRegistry = virtualNodesRegistry;
    }

    private CompoundCommand constructDependencyEnd(CompoundCommand command, DependencyDiamonViewCreateCommand nodeCreation, Collection<NamedElement> dependencyEnd, Dependency dependency, EditPartViewer viewer, PreferencesHint diagramPreferencesHint, Point location, View containerView, boolean constructSource) {
        Iterator<NamedElement> iteratorProp = dependencyEnd.iterator();
        int index = 0;
        while (iteratorProp.hasNext()) {
            ++index;
            EditPart sourceEditPart = null;
            NamedElement currentEnd = iteratorProp.next();
            Collection values = viewer.getEditPartRegistry().values();
            ArrayList<EditPart> editPartSet = new ArrayList<EditPart>();
            for (Object object : values) {
                editPartSet.add((EditPart)object);
            }
            Iterator editPartIterator = editPartSet.iterator();
            while (editPartIterator.hasNext() && sourceEditPart == null) {
                EditPart currentEditPart = (EditPart)editPartIterator.next();
                if (currentEditPart instanceof CompartmentEditPart || !(currentEditPart instanceof GraphicalEditPart) || !currentEnd.equals(((GraphicalEditPart)currentEditPart).resolveSemanticElement())) continue;
                sourceEditPart = currentEditPart;
            }
            CreateConnectionViewRequest.ConnectionViewDescriptor viewBranchDescriptor = new CreateConnectionViewRequest.ConnectionViewDescriptor((IAdaptable)UMLElementTypes.Dependency_BranchEdge, ((IHintedType)UMLElementTypes.Dependency_BranchEdge).getSemanticHint(), diagramPreferencesHint);
            IAdaptable nodeCreationAdapter = (IAdaptable)nodeCreation.getCommandResult().getReturnValue();
            if (sourceEditPart != null) {
                CustomDeferredCreateConnectionViewCommand aBranchCommand = null;
                aBranchCommand = constructSource ? new CustomDeferredCreateConnectionViewCommand(this.getEditingDomain(), ((IHintedType)UMLElementTypes.Dependency_BranchEdge).getSemanticHint(), (IAdaptable)new SemanticAdapter(null, sourceEditPart.getModel()), nodeCreationAdapter, sourceEditPart.getViewer(), ((IGraphicalEditPart)sourceEditPart).getDiagramPreferencesHint(), viewBranchDescriptor, null) : new CustomDeferredCreateConnectionViewCommand(this.getEditingDomain(), ((IHintedType)UMLElementTypes.Dependency_BranchEdge).getSemanticHint(), nodeCreationAdapter, (IAdaptable)new SemanticAdapter(null, sourceEditPart.getModel()), sourceEditPart.getViewer(), ((IGraphicalEditPart)sourceEditPart).getDiagramPreferencesHint(), viewBranchDescriptor, null);
                aBranchCommand.setElement((EObject)dependency);
                command.add((Command)new ICommandProxy((ICommand)aBranchCommand));
                continue;
            }
            IAdaptable currentEndAdapter = this.findOrCreateEndAdapter(currentEnd, command, containerView, diagramPreferencesHint, location, index);
            CustomDeferredCreateConnectionViewCommand aBranchCommand = null;
            aBranchCommand = constructSource ? new CustomDeferredCreateConnectionViewCommand(this.getEditingDomain(), ((IHintedType)UMLElementTypes.Dependency_BranchEdge).getSemanticHint(), currentEndAdapter, nodeCreationAdapter, viewer, diagramPreferencesHint, viewBranchDescriptor, null) : new CustomDeferredCreateConnectionViewCommand(this.getEditingDomain(), ((IHintedType)UMLElementTypes.Dependency_BranchEdge).getSemanticHint(), nodeCreationAdapter, currentEndAdapter, viewer, diagramPreferencesHint, viewBranchDescriptor, null);
            aBranchCommand.setElement((EObject)dependency);
            command.add((Command)new ICommandProxy((ICommand)aBranchCommand));
        }
        return command;
    }

    private IAdaptable findOrCreateEndAdapter(NamedElement currentEnd, CompoundCommand command, View containerView, PreferencesHint diagramPreferencesHint, Point location, int index) {
        IAdaptable currentEndAdapter = this.myVirtualNodesRegistry.findAdapter((Element)currentEnd);
        if (currentEndAdapter != null) {
            return currentEndAdapter;
        }
        EObjectAdapter elementAdapter = new EObjectAdapter((EObject)currentEnd);
        CreateViewRequest.ViewDescriptor descriptor = new CreateViewRequest.ViewDescriptor((IAdaptable)elementAdapter, Node.class, null, -1, false, diagramPreferencesHint);
        CreateCommand nodeCreationCommand = new CreateCommand(this.getEditingDomain(), descriptor, containerView);
        command.add((Command)new ICommandProxy((ICommand)nodeCreationCommand));
        SetBoundsCommand setBoundsCommand = new SetBoundsCommand(this.getEditingDomain(), "move", (IAdaptable)nodeCreationCommand.getCommandResult().getReturnValue(), new Point(location.x + 200, location.y + index * 100));
        command.add((Command)new ICommandProxy((ICommand)setBoundsCommand));
        currentEndAdapter = (IAdaptable)nodeCreationCommand.getCommandResult().getReturnValue();
        this.myVirtualNodesRegistry.registerAdapter((Element)currentEnd, currentEndAdapter);
        return currentEndAdapter;
    }

    public Command dropMutliDependency(Dependency dependency, EditPartViewer viewer, PreferencesHint diagramPreferencesHint, Point location, View containerView) {
        CompoundCommand command = new CompoundCommand();
        ArrayList<NamedElement> endToDisplaySource = new ArrayList<NamedElement>((Collection<NamedElement>)dependency.getClients());
        ArrayList<NamedElement> endToDisplayTarget = new ArrayList<NamedElement>((Collection<NamedElement>)dependency.getSuppliers());
        DependencyDiamonViewCreateCommand nodeCreation = new DependencyDiamonViewCreateCommand(this.getEditingDomain(), containerView, viewer, diagramPreferencesHint, location, new SemanticAdapter((EObject)dependency, null));
        command.add((Command)new ICommandProxy((ICommand)nodeCreation));
        command = this.constructDependencyEnd(command, nodeCreation, endToDisplaySource, dependency, viewer, diagramPreferencesHint, location, containerView, true);
        command = this.constructDependencyEnd(command, nodeCreation, endToDisplayTarget, dependency, viewer, diagramPreferencesHint, location, containerView, false);
        return command;
    }

    private Command getBranchDepencencyCommand(CreateConnectionViewAndElementRequest createConnectionViewAndElementRequest, Command command) {
        EditPart sourceEditPart = createConnectionViewAndElementRequest.getSourceEditPart();
        EditPart targetEditPart = createConnectionViewAndElementRequest.getTargetEditPart();
        EObject newSemanticElement = null;
        EReference feature = null;
        Dependency dependency = null;
        if (((View)sourceEditPart.getModel()).getElement() != null && ((View)sourceEditPart.getModel()).getElement() instanceof Dependency) {
            newSemanticElement = ((View)targetEditPart.getModel()).getElement();
            dependency = (Dependency)((View)sourceEditPart.getModel()).getElement();
            feature = UMLPackage.eINSTANCE.getDependency_Supplier();
        }
        if (((View)targetEditPart.getModel()).getElement() != null && ((View)targetEditPart.getModel()).getElement() instanceof Dependency) {
            newSemanticElement = ((View)sourceEditPart.getModel()).getElement();
            dependency = (Dependency)((View)targetEditPart.getModel()).getElement();
            feature = UMLPackage.eINSTANCE.getDependency_Client();
        }
        CreateConnectionViewRequest.ConnectionViewDescriptor viewDescriptor = new CreateConnectionViewRequest.ConnectionViewDescriptor((IAdaptable)UMLElementTypes.Dependency_BranchEdge, ((IHintedType)UMLElementTypes.Dependency_BranchEdge).getSemanticHint(), ((IGraphicalEditPart)sourceEditPart).getDiagramPreferencesHint());
        CustomDeferredCreateConnectionViewCommand aBranchCommand = new CustomDeferredCreateConnectionViewCommand(this.getEditingDomain(), ((IHintedType)UMLElementTypes.Dependency_BranchEdge).getSemanticHint(), (IAdaptable)new SemanticAdapter(null, sourceEditPart.getModel()), (IAdaptable)new SemanticAdapter(null, targetEditPart.getModel()), sourceEditPart.getViewer(), ((IGraphicalEditPart)sourceEditPart).getDiagramPreferencesHint(), viewDescriptor, null);
        aBranchCommand.setElement((EObject)dependency);
        command = new CompoundCommand();
        ((CompoundCommand)command).add((Command)new ICommandProxy((ICommand)aBranchCommand));
        SetRequest setRequest = new SetRequest((EObject)dependency, (EStructuralFeature)feature, (Object)newSemanticElement);
        SetValueCommand setValueCommand = new SetValueCommand(setRequest);
        ((CompoundCommand)command).add((Command)new ICommandProxy((ICommand)setValueCommand));
        return command;
    }

    public Command getCommand(CreateConnectionViewAndElementRequest createConnectionViewAndElementRequest, Command command) {
        command = new CompoundCommand();
        EditPart sourceEditPart = createConnectionViewAndElementRequest.getSourceEditPart();
        EditPart targetEditPart = createConnectionViewAndElementRequest.getTargetEditPart();
        if (sourceEditPart instanceof DependencyNodeEditPart || targetEditPart instanceof DependencyNodeEditPart) {
            return this.getBranchDepencencyCommand(createConnectionViewAndElementRequest, command);
        }
        if (sourceEditPart instanceof DependencyBranchEditPart) {
            GraphicalEditPart dependencyNodeEditPart = this.lookForDependencyNodeEditPart((DependencyBranchEditPart)sourceEditPart);
            if (dependencyNodeEditPart != null) {
                createConnectionViewAndElementRequest.setSourceEditPart((EditPart)dependencyNodeEditPart);
                return this.getBranchDepencencyCommand(createConnectionViewAndElementRequest, command);
            }
            return UnexecutableCommand.INSTANCE;
        }
        if (targetEditPart instanceof DependencyBranchEditPart) {
            GraphicalEditPart dependencyNodeEditPart = this.lookForDependencyNodeEditPart((DependencyBranchEditPart)targetEditPart);
            if (dependencyNodeEditPart != null) {
                createConnectionViewAndElementRequest.setTargetEditPart((EditPart)dependencyNodeEditPart);
                return this.getBranchDepencencyCommand(createConnectionViewAndElementRequest, command);
            }
            return UnexecutableCommand.INSTANCE;
        }
        return this.getDependencyToMultiDependencyCommand(createConnectionViewAndElementRequest, command);
    }

    private Command getDependencyToMultiDependencyCommand(CreateConnectionViewAndElementRequest createConnectionViewAndElementRequest, Command command) {
        command = new CompoundCommand();
        Point sourceLocation = null;
        Point targetLocation = null;
        Point nodeLocation = null;
        NamedElement newSemanticElement = null;
        EReference feature = null;
        EditPart sourceEditPart = createConnectionViewAndElementRequest.getSourceEditPart();
        EditPart targetEditPart = createConnectionViewAndElementRequest.getTargetEditPart();
        View dependencyView = null;
        Dependency dependency = null;
        View parentView = null;
        ICommandProxy startcommand = (ICommandProxy)createConnectionViewAndElementRequest.getStartCommand();
        if (startcommand != null) {
            for (ICommand currentCommand : (CompositeCommand)startcommand.getICommand()) {
                if (!(currentCommand instanceof SetConnectionBendpointsCommand)) continue;
                sourceLocation = ((SetConnectionBendpointsCommand)currentCommand).getSourceRefPoint();
                targetLocation = ((SetConnectionBendpointsCommand)currentCommand).getTargetRefPoint();
            }
        }
        if (targetEditPart != null) {
            if (((View)sourceEditPart.getModel()).getElement() != null && ((View)sourceEditPart.getModel()).getElement() instanceof Dependency) {
                dependencyView = (View)sourceEditPart.getModel();
                dependency = (Dependency)((View)sourceEditPart.getModel()).getElement();
                nodeLocation = sourceLocation;
                newSemanticElement = (NamedElement)((View)targetEditPart.getModel()).getElement();
                feature = UMLPackage.eINSTANCE.getDependency_Supplier();
            }
            if (((View)targetEditPart.getModel()).getElement() != null && ((View)targetEditPart.getModel()).getElement() instanceof Dependency) {
                dependencyView = (View)targetEditPart.getModel();
                dependency = (Dependency)((View)targetEditPart.getModel()).getElement();
                nodeLocation = targetLocation;
                newSemanticElement = (NamedElement)((View)sourceEditPart.getModel()).getElement();
                feature = UMLPackage.eINSTANCE.getDependency_Client();
            }
            if (dependencyView == null) {
                return null;
            }
            parentView = (View)dependencyView.eContainer();
            View dependencyViewSource = ((Edge)dependencyView).getSource();
            View dependencyViewTarget = ((Edge)dependencyView).getTarget();
            ((CompoundCommand)command).add((Command)new ICommandProxy((ICommand)new DeleteLinkDuringCreationCommand(this.getEditingDomain(), (Edge)dependencyView, sourceEditPart.getViewer())));
            DependencyDiamonViewCreateCommand nodeCreation = new DependencyDiamonViewCreateCommand(this.getEditingDomain(), parentView, sourceEditPart.getViewer(), ((IGraphicalEditPart)sourceEditPart).getDiagramPreferencesHint(), nodeLocation, new SemanticAdapter((EObject)dependency, null));
            ((CompoundCommand)command).add((Command)new ICommandProxy((ICommand)nodeCreation));
            CreateConnectionViewRequest.ConnectionViewDescriptor viewDescriptor = new CreateConnectionViewRequest.ConnectionViewDescriptor((IAdaptable)UMLElementTypes.Dependency_BranchEdge, ((IHintedType)UMLElementTypes.Dependency_BranchEdge).getSemanticHint(), ((IGraphicalEditPart)sourceEditPart).getDiagramPreferencesHint());
            CustomDeferredCreateConnectionViewCommand firstBranchCommand = new CustomDeferredCreateConnectionViewCommand(this.getEditingDomain(), ((IHintedType)UMLElementTypes.Dependency_BranchEdge).getSemanticHint(), (IAdaptable)new SemanticAdapter(null, (Object)dependencyViewSource), (IAdaptable)nodeCreation.getCommandResult().getReturnValue(), sourceEditPart.getViewer(), ((IGraphicalEditPart)sourceEditPart).getDiagramPreferencesHint(), viewDescriptor, null);
            firstBranchCommand.setElement((EObject)dependency);
            ((CompoundCommand)command).add((Command)new ICommandProxy((ICommand)firstBranchCommand));
            CustomDeferredCreateConnectionViewCommand secondBranchCommand = new CustomDeferredCreateConnectionViewCommand(this.getEditingDomain(), ((IHintedType)UMLElementTypes.Dependency_BranchEdge).getSemanticHint(), (IAdaptable)nodeCreation.getCommandResult().getReturnValue(), (IAdaptable)new SemanticAdapter(null, (Object)dependencyViewTarget), sourceEditPart.getViewer(), ((IGraphicalEditPart)sourceEditPart).getDiagramPreferencesHint(), viewDescriptor, null);
            secondBranchCommand.setElement((EObject)dependency);
            ((CompoundCommand)command).add((Command)new ICommandProxy((ICommand)secondBranchCommand));
            CustomDeferredCreateConnectionViewCommand thirdBranchCommand = null;
            thirdBranchCommand = dependencyView.equals(sourceEditPart.getModel()) ? new CustomDeferredCreateConnectionViewCommand(this.getEditingDomain(), ((IHintedType)UMLElementTypes.Dependency_BranchEdge).getSemanticHint(), (IAdaptable)nodeCreation.getCommandResult().getReturnValue(), (IAdaptable)new SemanticAdapter(null, targetEditPart.getModel()), sourceEditPart.getViewer(), ((IGraphicalEditPart)sourceEditPart).getDiagramPreferencesHint(), viewDescriptor, null) : new CustomDeferredCreateConnectionViewCommand(this.getEditingDomain(), ((IHintedType)UMLElementTypes.Dependency_BranchEdge).getSemanticHint(), (IAdaptable)new SemanticAdapter(null, sourceEditPart.getModel()), (IAdaptable)nodeCreation.getCommandResult().getReturnValue(), sourceEditPart.getViewer(), ((IGraphicalEditPart)sourceEditPart).getDiagramPreferencesHint(), viewDescriptor, null);
            thirdBranchCommand.setElement((EObject)dependency);
            ((CompoundCommand)command).add((Command)new ICommandProxy((ICommand)thirdBranchCommand));
            SetRequest setRequest = new SetRequest((EObject)dependency, (EStructuralFeature)feature, (Object)newSemanticElement);
            SetValueCommand setValueCommand = new SetValueCommand(setRequest);
            ((CompoundCommand)command).add((Command)new ICommandProxy((ICommand)setValueCommand));
            return command;
        }
        return null;
    }

    protected GraphicalEditPart lookForDependencyNodeEditPart(DependencyBranchEditPart dependencyBranchEditPart) {
        if (dependencyBranchEditPart.getSource() instanceof DependencyNodeEditPart) {
            return (GraphicalEditPart)dependencyBranchEditPart.getSource();
        }
        if (dependencyBranchEditPart.getTarget() instanceof DependencyNodeEditPart) {
            return (GraphicalEditPart)dependencyBranchEditPart.getTarget();
        }
        return null;
    }
}

