/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.common.editparts;

import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.NotationPackage;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.infra.core.services.ServiceException;
import org.eclipse.papyrus.infra.gmfdiag.common.editpart.NodeEditPart;
import org.eclipse.papyrus.infra.gmfdiag.common.utils.ServiceUtilsForEditPart;
import org.eclipse.papyrus.infra.ui.editorsfactory.IPageIconsRegistry;
import org.eclipse.papyrus.infra.ui.editorsfactory.PageIconsRegistry;
import org.eclipse.papyrus.uml.diagram.common.Activator;
import org.eclipse.papyrus.uml.diagram.common.editpolicies.ShortCutPreviewEditPolicy;
import org.eclipse.papyrus.uml.diagram.common.figure.node.DiagramNodeFigure;

public abstract class AbstractShortCutDiagramEditPart
extends NodeEditPart
implements Adapter {
    protected static final String DELETE_ICON = "icons/delete.gif";
    private IPageIconsRegistry editorRegistry;
    private Notifier target;
    protected Resource resourceToListen;

    public AbstractShortCutDiagramEditPart(View view) {
        super(view);
    }

    protected IPageIconsRegistry createEditorRegistry() {
        try {
            return (IPageIconsRegistry)ServiceUtilsForEditPart.getInstance().getService(IPageIconsRegistry.class, (Object)this);
        }
        catch (ServiceException e) {
            return new PageIconsRegistry();
        }
        catch (NullPointerException e) {
            return new PageIconsRegistry();
        }
    }

    public void activate() {
        super.activate();
        EObject eObject = this.resolveSemanticElement();
        this.resourceToListen = eObject.eResource();
        this.resourceToListen.eAdapters().add((Object)this);
        this.installEditPolicy("PopupBarEditPolicy", (EditPolicy)new ShortCutPreviewEditPolicy());
    }

    protected IPageIconsRegistry getEditorRegistry() {
        if (this.editorRegistry == null) {
            this.editorRegistry = this.createEditorRegistry();
        }
        return this.editorRegistry;
    }

    public abstract DiagramNodeFigure getPrimaryShape();

    public void refreshVisuals() {
        super.refreshVisuals();
        this.refreshIcons();
        this.refreshTransparency();
    }

    public void notifyChanged(Notification notification) {
        super.notifyChanged(notification);
        this.refreshIcons();
    }

    protected void refreshBounds() {
        int width = 34;
        int height = 20;
        Dimension size = new Dimension(width, height);
        int x = (Integer)this.getStructuralFeatureValue((EStructuralFeature)NotationPackage.eINSTANCE.getLocation_X());
        int y = (Integer)this.getStructuralFeatureValue((EStructuralFeature)NotationPackage.eINSTANCE.getLocation_Y());
        Point loc = new Point(x, y);
        ((GraphicalEditPart)this.getParent()).setLayoutConstraint((EditPart)this, this.getFigure(), (Object)new Rectangle(loc, size));
    }

    private void refreshIcons() {
        if (this.resolveSemanticElement() instanceof Diagram && this.resolveSemanticElement().eResource() != null) {
            this.getPrimaryShape().setIcon(this.getEditorRegistry().getEditorIcon((Object)this.resolveSemanticElement()));
        } else {
            this.getPrimaryShape().setIcon(Activator.getPluginIconImage("org.eclipse.papyrus.uml.diagram.common", DELETE_ICON));
        }
    }

    public void deactivate() {
        super.deactivate();
        this.resourceToListen.eAdapters().remove((Object)this);
    }

    public void setTarget(Notifier target) {
        this.target = target;
    }

    public Notifier getTarget() {
        return this.target;
    }

    public boolean isAdapterForType(Object type) {
        return this.getModel().getClass() == type;
    }
}

