/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.statemachine.custom.parsers;

import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.common.ui.services.parser.IParser;
import org.eclipse.gmf.runtime.common.ui.services.parser.IParserEditStatus;
import org.eclipse.gmf.runtime.common.ui.services.parser.ParserEditStatus;
import org.eclipse.gmf.runtime.emf.commands.core.command.AbstractTransactionalCommand;
import org.eclipse.gmf.runtime.emf.core.util.EObjectAdapter;
import org.eclipse.gmf.runtime.emf.ui.services.parser.ISemanticParser;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.util.SafeRunnable;
import org.eclipse.papyrus.infra.core.services.ServiceException;
import org.eclipse.papyrus.infra.emf.utils.ServiceUtilsForEObject;
import org.eclipse.papyrus.infra.gmfdiag.common.model.NotationUtils;
import org.eclipse.papyrus.infra.internationalization.common.utils.InternationalizationPreferencesUtils;
import org.eclipse.papyrus.uml.diagram.statemachine.custom.parsers.OpaqueBehaviorViewUtil;
import org.eclipse.papyrus.uml.diagram.statemachine.part.UMLDiagramEditorPlugin;
import org.eclipse.papyrus.uml.internationalization.utils.utils.UMLLabelInternationalization;
import org.eclipse.papyrus.uml.tools.utils.ValueSpecificationUtil;
import org.eclipse.uml2.uml.Behavior;
import org.eclipse.uml2.uml.CallEvent;
import org.eclipse.uml2.uml.ChangeEvent;
import org.eclipse.uml2.uml.Constraint;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Event;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.OpaqueBehavior;
import org.eclipse.uml2.uml.OpaqueExpression;
import org.eclipse.uml2.uml.Operation;
import org.eclipse.uml2.uml.Signal;
import org.eclipse.uml2.uml.SignalEvent;
import org.eclipse.uml2.uml.TimeEvent;
import org.eclipse.uml2.uml.TimeExpression;
import org.eclipse.uml2.uml.Transition;
import org.eclipse.uml2.uml.Trigger;
import org.eclipse.uml2.uml.UMLFactory;
import org.eclipse.uml2.uml.ValueSpecification;

public class TransitionPropertiesParser
implements IParser,
ISemanticParser {
    public static final String ONE_SPACE_STRING = " ";
    protected Constraint guardConstraint = null;
    public static final String EMPTY_STRING = "";

    public IContentAssistProcessor getCompletionProcessor(IAdaptable element) {
        return null;
    }

    public String getEditString(IAdaptable element, int flags) {
        return EMPTY_STRING;
    }

    public ICommand getParseCommand(IAdaptable element, String newString, int flags) {
        TransactionalEditingDomain editingDomain;
        final Transition transition = (Transition)((EObjectAdapter)element).getRealObject();
        final String result = newString;
        try {
            editingDomain = ServiceUtilsForEObject.getInstance().getTransactionalEditingDomain((Object)transition);
        }
        catch (ServiceException ex) {
            return null;
        }
        AbstractTransactionalCommand tc = new AbstractTransactionalCommand(editingDomain, "Edit Transition Properties", null){

            protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
                SafeRunnable.run((ISafeRunnable)new SafeRunnable(){

                    public void run() {
                        RecordingCommand rc = new RecordingCommand(this.getEditingDomain()){

                            protected void doExecute() {
                                EList elements = transition.getModel().allOwnedElements();
                                for (Element pElement : elements) {
                                    if (!(pElement instanceof Constraint) || !result.equals(((NamedElement)pElement).getName())) continue;
                                    ((this).this).TransitionPropertiesParser.this.guardConstraint = (Constraint)pElement;
                                    transition.setGuard(((this).this).TransitionPropertiesParser.this.guardConstraint);
                                }
                                if (((this).this).TransitionPropertiesParser.this.guardConstraint == null) {
                                    ((this).this).TransitionPropertiesParser.this.guardConstraint = UMLFactory.eINSTANCE.createConstraint();
                                    if (InternationalizationPreferencesUtils.getInternationalizationPreference((EObject)((this).this).TransitionPropertiesParser.this.guardConstraint) && UMLLabelInternationalization.getInstance().getLabelWithoutUML((NamedElement)((this).this).TransitionPropertiesParser.this.guardConstraint) != null) {
                                        UMLLabelInternationalization.getInstance().setLabel((NamedElement)((this).this).TransitionPropertiesParser.this.guardConstraint, result, null);
                                    } else {
                                        ((this).this).TransitionPropertiesParser.this.guardConstraint.setName(result);
                                    }
                                    ((this).this).TransitionPropertiesParser.this.guardConstraint.setContext(transition.getNamespace());
                                    transition.setGuard(((this).this).TransitionPropertiesParser.this.guardConstraint);
                                }
                            }
                        };
                        this.getEditingDomain().getCommandStack().execute((Command)rc);
                    }
                });
                return CommandResult.newOKCommandResult();
            }
        };
        return tc;
    }

    public String getPrintString(IAdaptable element, int flags) {
        String label = this.getValueString(element, flags);
        if (label == null || label.length() == 0) {
            label = ONE_SPACE_STRING;
        }
        return label;
    }

    public boolean isAffectingEvent(Object event, int flags) {
        int notificationType;
        if (event instanceof Notification && 1 == (notificationType = ((Notification)event).getEventType())) {
            if (((Notification)event).getNewValue() instanceof Constraint) {
                this.guardConstraint = (Constraint)((Notification)event).getNewValue();
            }
            return true;
        }
        return false;
    }

    protected String getValueString(IAdaptable element, int flags) {
        EObject semanticElement = (EObject)element.getAdapter(EObject.class);
        View view = (View)element.getAdapter(View.class);
        if (!(semanticElement instanceof Transition) && view != null) {
            semanticElement = view.getElement();
        }
        if (semanticElement instanceof Transition && view != null) {
            Transition trans = (Transition)semanticElement;
            StringBuilder result = new StringBuilder();
            String textForTrigger = this.getTextForTrigger(view, trans);
            if (textForTrigger != null && !EMPTY_STRING.equals(textForTrigger)) {
                result.append(textForTrigger);
            }
            result.append(this.getTextForGuard(trans));
            String textForEffect = this.getTextForEffect(view, trans);
            if (textForEffect != null && !EMPTY_STRING.equals(textForEffect)) {
                result.append("/");
                if (TransitionPropertiesParser.lineBreakBeforeEffect(view)) {
                    result.append("\n");
                }
                result.append(textForEffect);
            }
            return result.toString();
        }
        return EMPTY_STRING;
    }

    protected String getTextForGuard(Transition trans) {
        Constraint constraint = trans.getGuard();
        if (constraint != null) {
            String value;
            if (constraint.getSpecification() != null) {
                value = ValueSpecificationUtil.getConstraintnValue((Constraint)constraint);
            } else {
                String name = UMLLabelInternationalization.getInstance().getLabel((NamedElement)constraint);
                if (name == null) {
                    name = "<undef>";
                }
                value = String.format("%s (no spec)", name);
            }
            if (value != null) {
                return String.format("[%s]", value);
            }
        }
        return EMPTY_STRING;
    }

    protected String getTextForEffect(View view, Transition trans) {
        StringBuilder result = new StringBuilder();
        Behavior effect = trans.getEffect();
        if (effect != null) {
            OpaqueBehavior ob;
            EClass eClass = effect.eClass();
            if (effect instanceof OpaqueBehavior && (ob = (OpaqueBehavior)effect).getBodies().size() > 0) {
                result.append(OpaqueBehaviorViewUtil.retrieveBody(view, ob));
                return result.toString();
            }
            if (eClass != null) {
                result.append(eClass.getName()).append(": ").append(UMLLabelInternationalization.getInstance().getLabel((NamedElement)effect));
            }
        }
        return result.toString();
    }

    protected String getTextForTrigger(View view, Transition trans) {
        StringBuilder result = new StringBuilder();
        boolean isFirstTrigger = true;
        for (Trigger t : trans.getTriggers()) {
            if (t == null) continue;
            if (!isFirstTrigger) {
                result.append(", ");
            } else {
                isFirstTrigger = false;
            }
            Event e = t.getEvent();
            if (e instanceof CallEvent) {
                Operation op = ((CallEvent)e).getOperation();
                if (op != null) {
                    result.append(UMLLabelInternationalization.getInstance().getLabel((NamedElement)op));
                    if (op.getOwnedParameters().size() <= 0 || !OpaqueBehaviorViewUtil.displayParamDots(view)) continue;
                    result.append("(...)");
                    continue;
                }
                result.append(UMLLabelInternationalization.getInstance().getLabel((NamedElement)e));
                continue;
            }
            if (e instanceof SignalEvent) {
                Signal signal = ((SignalEvent)e).getSignal();
                if (signal != null) {
                    result.append(UMLLabelInternationalization.getInstance().getLabel((NamedElement)signal));
                    if (signal.getAttributes().size() <= 0 || !OpaqueBehaviorViewUtil.displayParamDots(view)) continue;
                    result.append("(...)");
                    continue;
                }
                result.append(UMLLabelInternationalization.getInstance().getLabel((NamedElement)e));
                continue;
            }
            if (e instanceof ChangeEvent) {
                ValueSpecification vs = ((ChangeEvent)e).getChangeExpression();
                String value = vs instanceof OpaqueExpression ? OpaqueBehaviorViewUtil.retrieveBody(view, (OpaqueExpression)vs) : vs.stringValue();
                result.append(value);
                continue;
            }
            if (e instanceof TimeEvent) {
                ValueSpecification vs;
                TimeEvent timeEvent = (TimeEvent)e;
                result.append(timeEvent.isRelative() ? "after " : "at ");
                TimeExpression te = timeEvent.getWhen();
                String value = te != null ? ((vs = te.getExpr()) instanceof OpaqueExpression ? OpaqueBehaviorViewUtil.retrieveBody(view, (OpaqueExpression)vs) : vs.stringValue()) : "undefined";
                result.append(value);
                continue;
            }
            result.append("all");
        }
        return result.toString();
    }

    public IParserEditStatus isValidEditString(IAdaptable element, String editString) {
        return new ParserEditStatus("org.eclipse.papyrus.uml.diagram.statemachine", 0, EMPTY_STRING);
    }

    public List<EObject> getSemanticElementsBeingParsed(EObject element) {
        Transition trans;
        Element umlElement = (Element)element;
        LinkedList<EObject> result = new LinkedList<EObject>();
        if (umlElement instanceof Transition && (trans = (Transition)umlElement) != null) {
            result.add((EObject)trans);
            Constraint constraint = trans.getGuard();
            if (constraint != null) {
                result.add((EObject)constraint);
                ValueSpecification specification = constraint.getSpecification();
                if (specification != null) {
                    result.add((EObject)specification);
                }
            }
            for (Trigger t : trans.getTriggers()) {
                if (t == null) continue;
                result.add((EObject)t);
            }
            Behavior effect = trans.getEffect();
            if (effect != null) {
                result.add((EObject)effect);
            }
        }
        return result;
    }

    public boolean areSemanticElementsAffected(EObject listener, Object notification) {
        return true;
    }

    public static boolean lineBreakBeforeEffect(View view) {
        IPreferenceStore preferenceStore = UMLDiagramEditorPlugin.getInstance().getPreferenceStore();
        boolean prefValue = preferenceStore.getBoolean("lineBreakBeforeEffect");
        return NotationUtils.getBooleanValue((View)view, (String)"lineBreakBeforeEffect", (boolean)prefValue);
    }
}

