/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.profile.drafter.ui.handler;

import org.eclipse.core.expressions.IEvaluationContext;
import org.eclipse.papyrus.infra.core.services.ServiceException;
import org.eclipse.papyrus.infra.core.services.ServicesRegistry;
import org.eclipse.papyrus.infra.ui.util.ServiceUtilsForIEvaluationContext;
import org.eclipse.papyrus.uml.profile.drafter.UserProfileCatalog;
import org.eclipse.papyrus.uml.profile.drafter.exceptions.DraftProfileException;
import org.eclipse.papyrus.uml.profile.drafter.services.ProfileCatalogService;
import org.eclipse.papyrus.uml.profile.drafter.ui.handler.AbstractBaseHandler;
import org.eclipse.papyrus.uml.profile.drafter.utils.UMLMetamodelUtils;

public abstract class AbstractProfileBaseHandler
extends AbstractBaseHandler {
    protected UMLMetamodelUtils umlMetamodelUtils;

    @Override
    protected void resetCachedValues() {
        this.umlMetamodelUtils = null;
        super.resetCachedValues();
    }

    public ProfileCatalogService getProfileCatalogService(IEvaluationContext context) throws ServiceException {
        ServicesRegistry servicesRegistry = ServiceUtilsForIEvaluationContext.getInstance().getServiceRegistry(context);
        return (ProfileCatalogService)servicesRegistry.getService(ProfileCatalogService.class);
    }

    protected UserProfileCatalog getProfileCatalog(IEvaluationContext context) throws ServiceException {
        ProfileCatalogService service = this.getProfileCatalogService(context);
        return service.getProfileCatalog();
    }

    public UMLMetamodelUtils getCachedUmlMetamodelUtils(IEvaluationContext context) throws DraftProfileException {
        if (this.umlMetamodelUtils == null) {
            this.umlMetamodelUtils = this.getUmlMetamodelUtils(context);
        }
        return this.umlMetamodelUtils;
    }

    public UMLMetamodelUtils getUmlMetamodelUtils(IEvaluationContext context) throws DraftProfileException {
        try {
            return new UMLMetamodelUtils(this.lookupServicesRegistry(context));
        }
        catch (ServiceException e) {
            throw new DraftProfileException("Can'create UMLMetamodelUtils object", e);
        }
    }
}

