/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.map.mutable.primitive;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Set;
import org.eclipse.collections.api.BooleanIterable;
import org.eclipse.collections.api.LazyBooleanIterable;
import org.eclipse.collections.api.LazyIterable;
import org.eclipse.collections.api.RichIterable;
import org.eclipse.collections.api.bag.primitive.MutableBooleanBag;
import org.eclipse.collections.api.block.HashingStrategy;
import org.eclipse.collections.api.block.function.primitive.BooleanFunction;
import org.eclipse.collections.api.block.function.primitive.BooleanFunction0;
import org.eclipse.collections.api.block.function.primitive.BooleanToBooleanFunction;
import org.eclipse.collections.api.block.function.primitive.BooleanToObjectFunction;
import org.eclipse.collections.api.block.function.primitive.ObjectBooleanToBooleanFunction;
import org.eclipse.collections.api.block.function.primitive.ObjectBooleanToObjectFunction;
import org.eclipse.collections.api.block.predicate.primitive.BooleanPredicate;
import org.eclipse.collections.api.block.predicate.primitive.ObjectBooleanPredicate;
import org.eclipse.collections.api.block.procedure.Procedure;
import org.eclipse.collections.api.block.procedure.Procedure2;
import org.eclipse.collections.api.block.procedure.primitive.BooleanProcedure;
import org.eclipse.collections.api.block.procedure.primitive.ObjectBooleanProcedure;
import org.eclipse.collections.api.block.procedure.primitive.ObjectIntProcedure;
import org.eclipse.collections.api.collection.MutableCollection;
import org.eclipse.collections.api.collection.primitive.ImmutableBooleanCollection;
import org.eclipse.collections.api.collection.primitive.MutableBooleanCollection;
import org.eclipse.collections.api.factory.Lists;
import org.eclipse.collections.api.factory.primitive.BooleanBags;
import org.eclipse.collections.api.factory.primitive.BooleanLists;
import org.eclipse.collections.api.factory.primitive.ObjectBooleanMaps;
import org.eclipse.collections.api.iterator.BooleanIterator;
import org.eclipse.collections.api.iterator.MutableBooleanIterator;
import org.eclipse.collections.api.list.MutableList;
import org.eclipse.collections.api.list.primitive.MutableBooleanList;
import org.eclipse.collections.api.map.primitive.ImmutableObjectBooleanMap;
import org.eclipse.collections.api.map.primitive.MutableObjectBooleanMap;
import org.eclipse.collections.api.map.primitive.ObjectBooleanMap;
import org.eclipse.collections.api.set.primitive.BooleanSet;
import org.eclipse.collections.api.set.primitive.MutableBooleanSet;
import org.eclipse.collections.api.tuple.primitive.ObjectBooleanPair;
import org.eclipse.collections.impl.bag.mutable.primitive.BooleanHashBag;
import org.eclipse.collections.impl.collection.mutable.primitive.SynchronizedBooleanCollection;
import org.eclipse.collections.impl.collection.mutable.primitive.UnmodifiableBooleanCollection;
import org.eclipse.collections.impl.lazy.AbstractLazyIterable;
import org.eclipse.collections.impl.lazy.primitive.LazyBooleanIterableAdapter;
import org.eclipse.collections.impl.list.mutable.primitive.BooleanArrayList;
import org.eclipse.collections.impl.map.mutable.primitive.SynchronizedObjectBooleanMap;
import org.eclipse.collections.impl.map.mutable.primitive.UnmodifiableObjectBooleanMap;
import org.eclipse.collections.impl.set.mutable.primitive.BooleanHashSet;
import org.eclipse.collections.impl.tuple.primitive.PrimitiveTuples;

public class ObjectBooleanHashMapWithHashingStrategy<K>
implements MutableObjectBooleanMap<K>,
Externalizable {
    public static final boolean EMPTY_VALUE = false;
    private static final long serialVersionUID = 1L;
    @Deprecated
    private static final float DEFAULT_LOAD_FACTOR = 0.5f;
    private static final int OCCUPIED_DATA_RATIO = 2;
    private static final int OCCUPIED_SENTINEL_RATIO = 4;
    private static final int DEFAULT_INITIAL_CAPACITY = 8;
    private static final Object NULL_KEY = new Object(){

        public boolean equals(Object obj) {
            throw new RuntimeException("Possible corruption through unsynchronized concurrent modification.");
        }

        public int hashCode() {
            throw new RuntimeException("Possible corruption through unsynchronized concurrent modification.");
        }

        public String toString() {
            return "ObjectBooleanHashMapWithHashingStrategyWithHashingStrategy.NULL_KEY";
        }
    };
    private static final Object REMOVED_KEY = new Object(){

        public boolean equals(Object obj) {
            throw new RuntimeException("Possible corruption through unsynchronized concurrent modification.");
        }

        public int hashCode() {
            throw new RuntimeException("Possible corruption through unsynchronized concurrent modification.");
        }

        public String toString() {
            return "ObjectBooleanHashMapWithHashingStrategy.REMOVED_KEY";
        }
    };
    private Object[] keys;
    private BitSet values;
    private int occupiedWithData;
    private int occupiedWithSentinels;
    private HashingStrategy<? super K> hashingStrategy;

    @Deprecated
    public ObjectBooleanHashMapWithHashingStrategy() {
    }

    public ObjectBooleanHashMapWithHashingStrategy(HashingStrategy<? super K> hashingStrategy) {
        this.hashingStrategy = hashingStrategy;
        this.allocateTable(16);
    }

    public ObjectBooleanHashMapWithHashingStrategy(HashingStrategy<? super K> hashingStrategy, int initialCapacity) {
        if (initialCapacity < 0) {
            throw new IllegalArgumentException("initial capacity cannot be less than 0");
        }
        this.hashingStrategy = hashingStrategy;
        int capacity = this.smallestPowerOfTwoGreaterThan(this.fastCeil(initialCapacity * 2));
        this.allocateTable(capacity);
    }

    public ObjectBooleanHashMapWithHashingStrategy(HashingStrategy<? super K> hashingStrategy, ObjectBooleanMap<? extends K> map) {
        this(hashingStrategy, Math.max(map.size(), 8));
        this.putAll(map);
    }

    public static <K> ObjectBooleanHashMapWithHashingStrategy<K> newMap(HashingStrategy<? super K> hashingStrategy) {
        return new ObjectBooleanHashMapWithHashingStrategy<K>(hashingStrategy);
    }

    public static <K> ObjectBooleanHashMapWithHashingStrategy<K> newMap(HashingStrategy<? super K> hashingStrategy, ObjectBooleanMap<K> map) {
        return new ObjectBooleanHashMapWithHashingStrategy<K>(hashingStrategy, map);
    }

    public static <K> ObjectBooleanHashMapWithHashingStrategy<K> newMap(ObjectBooleanHashMapWithHashingStrategy<K> map) {
        return new ObjectBooleanHashMapWithHashingStrategy<K>(map.hashingStrategy, map);
    }

    public static <K> ObjectBooleanHashMapWithHashingStrategy<K> newMapWithInitialCapacity(HashingStrategy<? super K> hashingStrategy, int initialCapacity) {
        return new ObjectBooleanHashMapWithHashingStrategy<K>(hashingStrategy, initialCapacity);
    }

    public static <K> ObjectBooleanHashMapWithHashingStrategy<K> newWithKeysValues(HashingStrategy<? super K> hashingStrategy, K key, boolean value) {
        return new ObjectBooleanHashMapWithHashingStrategy<K>(hashingStrategy, 1).withKeyValue((Object)key, value);
    }

    public static <K> ObjectBooleanHashMapWithHashingStrategy<K> newWithKeysValues(HashingStrategy<? super K> hashingStrategy, K key1, boolean value1, K key2, boolean value2) {
        return new ObjectBooleanHashMapWithHashingStrategy<K>(hashingStrategy, 2).withKeysValues(key1, value1, key2, value2);
    }

    public static <K> ObjectBooleanHashMapWithHashingStrategy<K> newWithKeysValues(HashingStrategy<? super K> hashingStrategy, K key1, boolean value1, K key2, boolean value2, K key3, boolean value3) {
        return new ObjectBooleanHashMapWithHashingStrategy<K>(hashingStrategy, 3).withKeysValues(key1, value1, key2, value2, key3, value3);
    }

    public static <K> ObjectBooleanHashMapWithHashingStrategy<K> newWithKeysValues(HashingStrategy<? super K> hashingStrategy, K key1, boolean value1, K key2, boolean value2, K key3, boolean value3, K key4, boolean value4) {
        return new ObjectBooleanHashMapWithHashingStrategy<K>(hashingStrategy, 4).withKeysValues(key1, value1, key2, value2, key3, value3, key4, value4);
    }

    private int smallestPowerOfTwoGreaterThan(int n) {
        return n > 1 ? Integer.highestOneBit(n - 1) << 1 : 1;
    }

    private int fastCeil(float v) {
        int possibleResult = (int)v;
        if (v - (float)possibleResult > 0.0f) {
            ++possibleResult;
        }
        return possibleResult;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof ObjectBooleanMap)) {
            return false;
        }
        ObjectBooleanMap other = (ObjectBooleanMap)obj;
        if (this.size() != other.size()) {
            return false;
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ObjectBooleanHashMapWithHashingStrategy.isNonSentinel(this.keys[i]) || other.containsKey(this.toNonSentinel(this.keys[i])) && this.values.get(i) == other.getOrThrow(this.toNonSentinel(this.keys[i]))) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int result = 0;
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ObjectBooleanHashMapWithHashingStrategy.isNonSentinel(this.keys[i])) continue;
            result += this.hashingStrategy.computeHashCode(this.toNonSentinel(this.keys[i])) ^ (this.values.get(i) ? 1231 : 1237);
        }
        return result;
    }

    @Override
    public String toString() {
        StringBuilder appendable = new StringBuilder();
        appendable.append("{");
        boolean first = true;
        for (int i = 0; i < this.keys.length; ++i) {
            Object key = this.keys[i];
            if (!ObjectBooleanHashMapWithHashingStrategy.isNonSentinel(key)) continue;
            if (!first) {
                appendable.append(", ");
            }
            appendable.append(this.toNonSentinel(key)).append("=").append(this.values.get(i));
            first = false;
        }
        appendable.append("}");
        return appendable.toString();
    }

    @Override
    public int size() {
        return this.occupiedWithData;
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public boolean notEmpty() {
        return this.size() != 0;
    }

    @Override
    public String makeString() {
        return this.makeString(", ");
    }

    @Override
    public String makeString(String separator) {
        return this.makeString("", separator, "");
    }

    @Override
    public String makeString(String start, String separator, String end) {
        StringBuilder stringBuilder = new StringBuilder();
        this.appendString(stringBuilder, start, separator, end);
        return ((Object)stringBuilder).toString();
    }

    @Override
    public void appendString(Appendable appendable) {
        this.appendString(appendable, ", ");
    }

    @Override
    public void appendString(Appendable appendable, String separator) {
        this.appendString(appendable, "", separator, "");
    }

    @Override
    public void appendString(Appendable appendable, String start, String separator, String end) {
        try {
            appendable.append(start);
            boolean first = true;
            for (int i = 0; i < this.keys.length; ++i) {
                Object key = this.keys[i];
                if (!ObjectBooleanHashMapWithHashingStrategy.isNonSentinel(key)) continue;
                if (!first) {
                    appendable.append(separator);
                }
                appendable.append(String.valueOf(this.values.get(i)));
                first = false;
            }
            appendable.append(end);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public MutableBooleanIterator booleanIterator() {
        return new InternalBooleanIterator();
    }

    @Override
    public boolean[] toArray() {
        boolean[] result = new boolean[this.size()];
        int index = 0;
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ObjectBooleanHashMapWithHashingStrategy.isNonSentinel(this.keys[i])) continue;
            result[index] = this.values.get(i);
            ++index;
        }
        return result;
    }

    @Override
    public boolean[] toArray(boolean[] result) {
        if (result.length < this.size()) {
            result = new boolean[this.size()];
        }
        int index = 0;
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ObjectBooleanHashMapWithHashingStrategy.isNonSentinel(this.keys[i])) continue;
            result[index] = this.values.get(i);
            ++index;
        }
        return result;
    }

    @Override
    public boolean contains(boolean value) {
        return this.containsValue(value);
    }

    @Override
    public boolean containsAll(boolean ... source) {
        for (boolean item : source) {
            if (this.containsValue(item)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean containsAll(BooleanIterable source) {
        return this.containsAll(source.toArray());
    }

    @Override
    public void forEach(BooleanProcedure procedure) {
        this.forEachValue(procedure);
    }

    @Override
    public void each(BooleanProcedure procedure) {
        this.forEach(procedure);
    }

    @Override
    public boolean detectIfNone(BooleanPredicate predicate, boolean ifNone) {
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ObjectBooleanHashMapWithHashingStrategy.isNonSentinel(this.keys[i]) || !predicate.accept(this.values.get(i))) continue;
            return this.values.get(i);
        }
        return ifNone;
    }

    @Override
    public MutableBooleanCollection select(BooleanPredicate predicate) {
        MutableBooleanList result = BooleanLists.mutable.empty();
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ObjectBooleanHashMapWithHashingStrategy.isNonSentinel(this.keys[i]) || !predicate.accept(this.values.get(i))) continue;
            result.add(this.values.get(i));
        }
        return result;
    }

    @Override
    public int count(BooleanPredicate predicate) {
        int count = 0;
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ObjectBooleanHashMapWithHashingStrategy.isNonSentinel(this.keys[i]) || !predicate.accept(this.values.get(i))) continue;
            ++count;
        }
        return count;
    }

    @Override
    public MutableBooleanCollection reject(BooleanPredicate predicate) {
        MutableBooleanList result = BooleanLists.mutable.empty();
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ObjectBooleanHashMapWithHashingStrategy.isNonSentinel(this.keys[i]) || predicate.accept(this.values.get(i))) continue;
            result.add(this.values.get(i));
        }
        return result;
    }

    @Override
    public boolean anySatisfy(BooleanPredicate predicate) {
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ObjectBooleanHashMapWithHashingStrategy.isNonSentinel(this.keys[i]) || !predicate.accept(this.values.get(i))) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean allSatisfy(BooleanPredicate predicate) {
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ObjectBooleanHashMapWithHashingStrategy.isNonSentinel(this.keys[i]) || predicate.accept(this.values.get(i))) continue;
            return false;
        }
        return true;
    }

    @Override
    public <V> MutableCollection<V> collect(BooleanToObjectFunction<? extends V> function) {
        MutableList result = Lists.mutable.withInitialCapacity(this.size());
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ObjectBooleanHashMapWithHashingStrategy.isNonSentinel(this.keys[i])) continue;
            result.add(function.valueOf(this.values.get(i)));
        }
        return result;
    }

    @Override
    public boolean noneSatisfy(BooleanPredicate predicate) {
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ObjectBooleanHashMapWithHashingStrategy.isNonSentinel(this.keys[i]) || !predicate.accept(this.values.get(i))) continue;
            return false;
        }
        return true;
    }

    @Override
    public MutableBooleanList toList() {
        BooleanArrayList result = new BooleanArrayList(this.size());
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ObjectBooleanHashMapWithHashingStrategy.isNonSentinel(this.keys[i])) continue;
            result.add(this.values.get(i));
        }
        return result;
    }

    @Override
    public MutableBooleanSet toSet() {
        BooleanHashSet result = new BooleanHashSet();
        for (int i = 0; result.size() < 2 && i < this.keys.length; ++i) {
            if (!ObjectBooleanHashMapWithHashingStrategy.isNonSentinel(this.keys[i])) continue;
            result.add(this.values.get(i));
        }
        return result;
    }

    @Override
    public MutableBooleanBag toBag() {
        BooleanHashBag result = new BooleanHashBag();
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ObjectBooleanHashMapWithHashingStrategy.isNonSentinel(this.keys[i])) continue;
            result.add(this.values.get(i));
        }
        return result;
    }

    @Override
    public LazyBooleanIterable asLazy() {
        return new LazyBooleanIterableAdapter(this);
    }

    public <V> V injectInto(V injectedValue, ObjectBooleanToObjectFunction<? super V, ? extends V> function) {
        V result = injectedValue;
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ObjectBooleanHashMapWithHashingStrategy.isNonSentinel(this.keys[i])) continue;
            result = function.valueOf(result, this.values.get(i));
        }
        return result;
    }

    @Override
    public RichIterable<BooleanIterable> chunk(int size) {
        if (size <= 0) {
            throw new IllegalArgumentException("Size for groups must be positive but was: " + size);
        }
        MutableList<BooleanIterable> result = Lists.mutable.empty();
        if (this.notEmpty()) {
            MutableBooleanIterator iterator = this.booleanIterator();
            while (iterator.hasNext()) {
                MutableBooleanBag batch = BooleanBags.mutable.empty();
                for (int i = 0; i < size && iterator.hasNext(); ++i) {
                    batch.add(iterator.next());
                }
                result.add(batch);
            }
        }
        return result;
    }

    @Override
    public void clear() {
        this.occupiedWithData = 0;
        this.occupiedWithSentinels = 0;
        Arrays.fill(this.keys, null);
        this.values.clear();
    }

    @Override
    public void put(K key, boolean value) {
        int index = this.probe(key);
        if (ObjectBooleanHashMapWithHashingStrategy.isNonSentinel(this.keys[index]) && this.nullSafeEquals(this.toNonSentinel(this.keys[index]), key)) {
            this.values.set(index, value);
            return;
        }
        this.addKeyValueAtIndex(key, value, index);
    }

    @Override
    public void putAll(ObjectBooleanMap<? extends K> map) {
        map.forEachKeyValue(this::put);
    }

    @Override
    public void updateValues(ObjectBooleanToBooleanFunction<? super K> function) {
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ObjectBooleanHashMapWithHashingStrategy.isNonSentinel(this.keys[i])) continue;
            this.values.set(i, function.valueOf(this.toNonSentinel(this.keys[i]), this.values.get(i)));
        }
    }

    @Override
    public void removeKey(K key) {
        int index = this.probe(key);
        this.removeKeyAtIndex(key, index);
    }

    @Override
    public void remove(Object key) {
        this.removeKey(key);
    }

    private void removeKeyAtIndex(K key, int index) {
        if (ObjectBooleanHashMapWithHashingStrategy.isNonSentinel(this.keys[index]) && this.nullSafeEquals(this.toNonSentinel(this.keys[index]), key)) {
            this.keys[index] = REMOVED_KEY;
            this.values.set(index, false);
            --this.occupiedWithData;
            ++this.occupiedWithSentinels;
        }
    }

    @Override
    public boolean removeKeyIfAbsent(K key, boolean value) {
        int index = this.probe(key);
        if (ObjectBooleanHashMapWithHashingStrategy.isNonSentinel(this.keys[index]) && this.nullSafeEquals(this.toNonSentinel(this.keys[index]), key)) {
            this.keys[index] = REMOVED_KEY;
            boolean oldValue = this.values.get(index);
            this.values.set(index, false);
            --this.occupiedWithData;
            ++this.occupiedWithSentinels;
            return oldValue;
        }
        return value;
    }

    @Override
    public boolean getIfAbsentPut(K key, boolean value) {
        int index = this.probe(key);
        if (ObjectBooleanHashMapWithHashingStrategy.isNonSentinel(this.keys[index]) && this.nullSafeEquals(this.toNonSentinel(this.keys[index]), key)) {
            return this.values.get(index);
        }
        this.addKeyValueAtIndex(key, value, index);
        return value;
    }

    @Override
    public boolean getAndPut(K key, boolean putValue, boolean defaultValue) {
        int index = this.probe(key);
        if (ObjectBooleanHashMapWithHashingStrategy.isNonSentinel(this.keys[index]) && this.nullSafeEquals(this.toNonSentinel(this.keys[index]), key)) {
            boolean existingValue = this.values.get(index);
            this.values.set(index, putValue);
            return existingValue;
        }
        this.addKeyValueAtIndex(key, putValue, index);
        return defaultValue;
    }

    @Override
    public boolean getIfAbsentPut(K key, BooleanFunction0 function) {
        int index = this.probe(key);
        if (ObjectBooleanHashMapWithHashingStrategy.isNonSentinel(this.keys[index]) && this.nullSafeEquals(this.toNonSentinel(this.keys[index]), key)) {
            return this.values.get(index);
        }
        boolean value = function.value();
        this.addKeyValueAtIndex(key, value, index);
        return value;
    }

    @Override
    public boolean getIfAbsentPutWithKey(K key, BooleanFunction<? super K> function) {
        int index = this.probe(key);
        if (ObjectBooleanHashMapWithHashingStrategy.isNonSentinel(this.keys[index]) && this.nullSafeEquals(this.toNonSentinel(this.keys[index]), key)) {
            return this.values.get(index);
        }
        boolean value = function.booleanValueOf(key);
        this.addKeyValueAtIndex(key, value, index);
        return value;
    }

    @Override
    public <P> boolean getIfAbsentPutWith(K key, BooleanFunction<? super P> function, P parameter) {
        int index = this.probe(key);
        if (ObjectBooleanHashMapWithHashingStrategy.isNonSentinel(this.keys[index]) && this.nullSafeEquals(this.toNonSentinel(this.keys[index]), key)) {
            return this.values.get(index);
        }
        boolean value = function.booleanValueOf(parameter);
        this.addKeyValueAtIndex(key, value, index);
        return value;
    }

    @Override
    public boolean updateValue(K key, boolean initialValueIfAbsent, BooleanToBooleanFunction function) {
        int index = this.probe(key);
        if (ObjectBooleanHashMapWithHashingStrategy.isNonSentinel(this.keys[index]) && this.nullSafeEquals(this.toNonSentinel(this.keys[index]), key)) {
            this.values.set(index, function.valueOf(this.values.get(index)));
            return this.values.get(index);
        }
        boolean value = function.valueOf(initialValueIfAbsent);
        this.addKeyValueAtIndex(key, value, index);
        return value;
    }

    @Override
    public ObjectBooleanHashMapWithHashingStrategy<K> withKeyValue(K key1, boolean value1) {
        this.put(key1, value1);
        return this;
    }

    @Override
    public ObjectBooleanHashMapWithHashingStrategy<K> withoutKey(K key) {
        this.removeKey(key);
        return this;
    }

    @Override
    public ObjectBooleanHashMapWithHashingStrategy<K> withoutAllKeys(Iterable<? extends K> keys) {
        for (K key : keys) {
            this.removeKey(key);
        }
        return this;
    }

    @Override
    public MutableObjectBooleanMap<K> asUnmodifiable() {
        return new UnmodifiableObjectBooleanMap(this);
    }

    @Override
    public MutableObjectBooleanMap<K> asSynchronized() {
        return new SynchronizedObjectBooleanMap(this);
    }

    @Override
    public boolean get(Object key) {
        return this.getIfAbsent(key, false);
    }

    @Override
    public boolean getOrThrow(Object key) {
        int index = this.probe(key);
        if (ObjectBooleanHashMapWithHashingStrategy.isNonSentinel(this.keys[index])) {
            return this.values.get(index);
        }
        throw new IllegalStateException("Key " + key + " not present.");
    }

    @Override
    public boolean getIfAbsent(Object key, boolean ifAbsent) {
        int index = this.probe(key);
        if (ObjectBooleanHashMapWithHashingStrategy.isNonSentinel(this.keys[index]) && this.nullSafeEquals(this.toNonSentinel(this.keys[index]), key)) {
            return this.values.get(index);
        }
        return ifAbsent;
    }

    @Override
    public boolean containsKey(Object key) {
        int index = this.probe(key);
        return ObjectBooleanHashMapWithHashingStrategy.isNonSentinel(this.keys[index]) && this.nullSafeEquals(this.toNonSentinel(this.keys[index]), key);
    }

    @Override
    public boolean containsValue(boolean value) {
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ObjectBooleanHashMapWithHashingStrategy.isNonSentinel(this.keys[i]) || this.values.get(i) != value) continue;
            return true;
        }
        return false;
    }

    @Override
    public void forEachValue(BooleanProcedure procedure) {
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ObjectBooleanHashMapWithHashingStrategy.isNonSentinel(this.keys[i])) continue;
            procedure.value(this.values.get(i));
        }
    }

    @Override
    public void forEachKey(Procedure<? super K> procedure) {
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ObjectBooleanHashMapWithHashingStrategy.isNonSentinel(this.keys[i])) continue;
            procedure.value(this.toNonSentinel(this.keys[i]));
        }
    }

    @Override
    public void forEachKeyValue(ObjectBooleanProcedure<? super K> procedure) {
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ObjectBooleanHashMapWithHashingStrategy.isNonSentinel(this.keys[i])) continue;
            procedure.value(this.toNonSentinel(this.keys[i]), this.values.get(i));
        }
    }

    @Override
    public ObjectBooleanHashMapWithHashingStrategy<K> select(ObjectBooleanPredicate<? super K> predicate) {
        ObjectBooleanHashMapWithHashingStrategy<K> result = ObjectBooleanHashMapWithHashingStrategy.newMap(this.hashingStrategy);
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ObjectBooleanHashMapWithHashingStrategy.isNonSentinel(this.keys[i]) || !predicate.accept(this.toNonSentinel(this.keys[i]), this.values.get(i))) continue;
            result.put(this.toNonSentinel(this.keys[i]), this.values.get(i));
        }
        return result;
    }

    @Override
    public ObjectBooleanHashMapWithHashingStrategy<K> reject(ObjectBooleanPredicate<? super K> predicate) {
        ObjectBooleanHashMapWithHashingStrategy<K> result = ObjectBooleanHashMapWithHashingStrategy.newMap(this.hashingStrategy);
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ObjectBooleanHashMapWithHashingStrategy.isNonSentinel(this.keys[i]) || predicate.accept(this.toNonSentinel(this.keys[i]), this.values.get(i))) continue;
            result.put(this.toNonSentinel(this.keys[i]), this.values.get(i));
        }
        return result;
    }

    @Override
    public ImmutableObjectBooleanMap<K> toImmutable() {
        return ObjectBooleanMaps.immutable.withAll(this);
    }

    @Override
    public Set<K> keySet() {
        return new KeySet();
    }

    @Override
    public MutableBooleanCollection values() {
        return new ValuesCollection();
    }

    @Override
    public LazyIterable<K> keysView() {
        return new KeysView();
    }

    @Override
    public RichIterable<ObjectBooleanPair<K>> keyValuesView() {
        return new KeyValuesView();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.hashingStrategy);
        out.writeInt(this.size());
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ObjectBooleanHashMapWithHashingStrategy.isNonSentinel(this.keys[i])) continue;
            out.writeObject(this.toNonSentinel(this.keys[i]));
            out.writeBoolean(this.values.get(i));
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.hashingStrategy = (HashingStrategy)in.readObject();
        int size = in.readInt();
        int capacity = this.smallestPowerOfTwoGreaterThan(this.fastCeil(size * 2));
        this.allocateTable(capacity);
        for (int i = 0; i < size; ++i) {
            this.put(in.readObject(), in.readBoolean());
        }
    }

    int probe(Object element) {
        int index = this.spread(element);
        int removedIndex = -1;
        if (ObjectBooleanHashMapWithHashingStrategy.isRemovedKey(this.keys[index])) {
            removedIndex = index;
        } else if (this.keys[index] == null || this.nullSafeEquals(this.toNonSentinel(this.keys[index]), element)) {
            return index;
        }
        int nextIndex = index;
        int probe = 17;
        while (true) {
            nextIndex += probe;
            probe += 17;
            if (ObjectBooleanHashMapWithHashingStrategy.isRemovedKey(this.keys[nextIndex &= this.keys.length - 1])) {
                if (removedIndex != -1) continue;
                removedIndex = nextIndex;
                continue;
            }
            if (this.nullSafeEquals(this.toNonSentinel(this.keys[nextIndex]), element)) {
                return nextIndex;
            }
            if (this.keys[nextIndex] == null) break;
        }
        return removedIndex == -1 ? nextIndex : removedIndex;
    }

    private static boolean isRemovedKey(Object key) {
        return key == REMOVED_KEY;
    }

    private boolean nullSafeEquals(K key, Object other) {
        return key == null ? other == null : key != NULL_KEY && other != null && this.hashingStrategy.equals(key, this.toNonSentinel(other));
    }

    private K toNonSentinel(Object key) {
        return (K)(key == NULL_KEY ? null : key);
    }

    int spread(Object element) {
        K nonSentinelKey = this.toNonSentinel(element);
        int h = nonSentinelKey == null ? 0 : this.hashingStrategy.computeHashCode(nonSentinelKey);
        h ^= h >>> 20 ^ h >>> 12;
        h ^= h >>> 7 ^ h >>> 4;
        return h & this.keys.length - 1;
    }

    private void addKeyValueAtIndex(K key, boolean value, int index) {
        if (this.keys[index] == REMOVED_KEY) {
            --this.occupiedWithSentinels;
        }
        this.keys[index] = ObjectBooleanHashMapWithHashingStrategy.toSentinelIfNull(key);
        this.values.set(index, value);
        ++this.occupiedWithData;
        if (this.occupiedWithData + this.occupiedWithSentinels > this.maxOccupiedWithData()) {
            this.rehashAndGrow();
        }
    }

    private static Object toSentinelIfNull(Object key) {
        return key == null ? NULL_KEY : key;
    }

    private int maxOccupiedWithData() {
        int capacity = this.keys.length;
        return Math.min(capacity - 1, capacity / 2);
    }

    private void rehashAndGrow() {
        this.rehash(this.keys.length << 1);
    }

    private void rehash(int newCapacity) {
        int oldLength = this.keys.length;
        Object[] old = this.keys;
        BitSet oldValues = this.values;
        this.allocateTable(newCapacity);
        this.occupiedWithData = 0;
        this.occupiedWithSentinels = 0;
        for (int i = 0; i < oldLength; ++i) {
            if (!ObjectBooleanHashMapWithHashingStrategy.isNonSentinel(old[i])) continue;
            this.put(this.toNonSentinel(old[i]), oldValues.get(i));
        }
    }

    protected void allocateTable(int sizeToAllocate) {
        this.keys = new Object[sizeToAllocate];
        this.values = new BitSet(sizeToAllocate);
    }

    private static <K> boolean isNonSentinel(K key) {
        return key != null && !ObjectBooleanHashMapWithHashingStrategy.isRemovedKey(key);
    }

    private int maxOccupiedWithSentinels() {
        return this.keys.length / 4;
    }

    public ObjectBooleanHashMapWithHashingStrategy<K> withKeysValues(K key1, boolean value1, K key2, boolean value2) {
        this.put(key1, value1);
        this.put(key2, value2);
        return this;
    }

    public ObjectBooleanHashMapWithHashingStrategy<K> withKeysValues(K key1, boolean value1, K key2, boolean value2, K key3, boolean value3) {
        this.put(key1, value1);
        this.put(key2, value2);
        this.put(key3, value3);
        return this;
    }

    public ObjectBooleanHashMapWithHashingStrategy<K> withKeysValues(K key1, boolean value1, K key2, boolean value2, K key3, boolean value3, K key4, boolean value4) {
        this.put(key1, value1);
        this.put(key2, value2);
        this.put(key3, value3);
        this.put(key4, value4);
        return this;
    }

    static /* synthetic */ Object[] access$502(ObjectBooleanHashMapWithHashingStrategy x0, Object[] x1) {
        x0.keys = x1;
        return x1;
    }

    private class InternalBooleanIterator
    implements MutableBooleanIterator {
        private int count;
        private int position;

        private InternalBooleanIterator() {
        }

        @Override
        public boolean hasNext() {
            return this.count != ObjectBooleanHashMapWithHashingStrategy.this.size();
        }

        @Override
        public boolean next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            Object[] keys = ObjectBooleanHashMapWithHashingStrategy.this.keys;
            while (!ObjectBooleanHashMapWithHashingStrategy.isNonSentinel(keys[this.position])) {
                ++this.position;
            }
            boolean result = ObjectBooleanHashMapWithHashingStrategy.this.values.get(this.position);
            ++this.count;
            ++this.position;
            return result;
        }

        @Override
        public void remove() {
            if (this.position == 0 || !ObjectBooleanHashMapWithHashingStrategy.isNonSentinel(ObjectBooleanHashMapWithHashingStrategy.this.keys[this.position - 1])) {
                throw new IllegalStateException();
            }
            ObjectBooleanHashMapWithHashingStrategy.this.remove(ObjectBooleanHashMapWithHashingStrategy.this.keys[this.position - 1]);
            --this.count;
        }
    }

    private class KeySet
    implements Set<K> {
        private KeySet() {
        }

        @Override
        public boolean equals(Object obj) {
            Set other;
            if (obj instanceof Set && (other = (Set)obj).size() == this.size()) {
                return this.containsAll(other);
            }
            return false;
        }

        @Override
        public int hashCode() {
            int hashCode = 0;
            Object[] table = ObjectBooleanHashMapWithHashingStrategy.this.keys;
            for (int i = 0; i < table.length; ++i) {
                Object key = table[i];
                if (!ObjectBooleanHashMapWithHashingStrategy.isNonSentinel(key)) continue;
                Object nonSentinelKey = ObjectBooleanHashMapWithHashingStrategy.this.toNonSentinel(key);
                hashCode += nonSentinelKey == null ? 0 : ObjectBooleanHashMapWithHashingStrategy.this.hashingStrategy.computeHashCode(nonSentinelKey);
            }
            return hashCode;
        }

        @Override
        public int size() {
            return ObjectBooleanHashMapWithHashingStrategy.this.size();
        }

        @Override
        public boolean isEmpty() {
            return ObjectBooleanHashMapWithHashingStrategy.this.isEmpty();
        }

        @Override
        public boolean contains(Object o) {
            return ObjectBooleanHashMapWithHashingStrategy.this.containsKey(o);
        }

        @Override
        public Object[] toArray() {
            int size = ObjectBooleanHashMapWithHashingStrategy.this.size();
            Object[] result = new Object[size];
            this.copyKeys(result);
            return result;
        }

        @Override
        public <T> T[] toArray(T[] array) {
            Object[] result = array;
            int size = ObjectBooleanHashMapWithHashingStrategy.this.size();
            if (result.length < size) {
                result = (Object[])Array.newInstance(result.getClass().getComponentType(), size);
            }
            this.copyKeys(result);
            if (size < result.length) {
                result[size] = null;
            }
            return result;
        }

        @Override
        public boolean add(K key) {
            throw new UnsupportedOperationException("Cannot call add() on " + this.getClass().getSimpleName());
        }

        @Override
        public boolean remove(Object key) {
            int oldSize = ObjectBooleanHashMapWithHashingStrategy.this.size();
            ObjectBooleanHashMapWithHashingStrategy.this.removeKey(key);
            return oldSize != ObjectBooleanHashMapWithHashingStrategy.this.size();
        }

        @Override
        public boolean containsAll(Collection<?> collection) {
            for (Object aCollection : collection) {
                if (ObjectBooleanHashMapWithHashingStrategy.this.containsKey(aCollection)) continue;
                return false;
            }
            return true;
        }

        @Override
        public boolean addAll(Collection<? extends K> collection) {
            throw new UnsupportedOperationException("Cannot call addAll() on " + this.getClass().getSimpleName());
        }

        @Override
        public boolean retainAll(Collection<?> collection) {
            int oldSize = ObjectBooleanHashMapWithHashingStrategy.this.size();
            Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                Object next = iterator.next();
                if (collection.contains(next)) continue;
                iterator.remove();
            }
            return oldSize != ObjectBooleanHashMapWithHashingStrategy.this.size();
        }

        @Override
        public boolean removeAll(Collection<?> collection) {
            int oldSize = ObjectBooleanHashMapWithHashingStrategy.this.size();
            for (Object object : collection) {
                ObjectBooleanHashMapWithHashingStrategy.this.removeKey(object);
            }
            return oldSize != ObjectBooleanHashMapWithHashingStrategy.this.size();
        }

        @Override
        public void clear() {
            ObjectBooleanHashMapWithHashingStrategy.this.clear();
        }

        @Override
        public Iterator<K> iterator() {
            return new KeySetIterator();
        }

        private void copyKeys(Object[] result) {
            int count = 0;
            for (int i = 0; i < ObjectBooleanHashMapWithHashingStrategy.this.keys.length; ++i) {
                Object key = ObjectBooleanHashMapWithHashingStrategy.this.keys[i];
                if (!ObjectBooleanHashMapWithHashingStrategy.isNonSentinel(key)) continue;
                result[count++] = ObjectBooleanHashMapWithHashingStrategy.this.keys[i];
            }
        }
    }

    private class KeySetIterator
    implements Iterator<K> {
        private int count;
        private int position;
        private K currentKey;
        private boolean isCurrentKeySet;

        private KeySetIterator() {
        }

        @Override
        public boolean hasNext() {
            return this.count < ObjectBooleanHashMapWithHashingStrategy.this.size();
        }

        @Override
        public K next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            ++this.count;
            Object[] keys = ObjectBooleanHashMapWithHashingStrategy.this.keys;
            while (!ObjectBooleanHashMapWithHashingStrategy.isNonSentinel(keys[this.position])) {
                ++this.position;
            }
            this.currentKey = ObjectBooleanHashMapWithHashingStrategy.this.keys[this.position];
            this.isCurrentKeySet = true;
            ++this.position;
            return ObjectBooleanHashMapWithHashingStrategy.this.toNonSentinel(this.currentKey);
        }

        @Override
        public void remove() {
            if (!this.isCurrentKeySet) {
                throw new IllegalStateException();
            }
            this.isCurrentKeySet = false;
            --this.count;
            if (ObjectBooleanHashMapWithHashingStrategy.isNonSentinel(this.currentKey)) {
                int index = this.position - 1;
                ObjectBooleanHashMapWithHashingStrategy.this.removeKeyAtIndex(ObjectBooleanHashMapWithHashingStrategy.this.toNonSentinel(this.currentKey), index);
            } else {
                ObjectBooleanHashMapWithHashingStrategy.this.removeKey(this.currentKey);
            }
        }
    }

    private class KeyValuesView
    extends AbstractLazyIterable<ObjectBooleanPair<K>> {
        private KeyValuesView() {
        }

        @Override
        public void each(Procedure<? super ObjectBooleanPair<K>> procedure) {
            for (int i = 0; i < ObjectBooleanHashMapWithHashingStrategy.this.keys.length; ++i) {
                if (!ObjectBooleanHashMapWithHashingStrategy.isNonSentinel(ObjectBooleanHashMapWithHashingStrategy.this.keys[i])) continue;
                procedure.value(PrimitiveTuples.pair(ObjectBooleanHashMapWithHashingStrategy.this.toNonSentinel(ObjectBooleanHashMapWithHashingStrategy.this.keys[i]), ObjectBooleanHashMapWithHashingStrategy.this.values.get(i)));
            }
        }

        @Override
        public void forEachWithIndex(ObjectIntProcedure<? super ObjectBooleanPair<K>> objectIntProcedure) {
            int index = 0;
            for (int i = 0; i < ObjectBooleanHashMapWithHashingStrategy.this.keys.length; ++i) {
                if (!ObjectBooleanHashMapWithHashingStrategy.isNonSentinel(ObjectBooleanHashMapWithHashingStrategy.this.keys[i])) continue;
                objectIntProcedure.value(PrimitiveTuples.pair(ObjectBooleanHashMapWithHashingStrategy.this.toNonSentinel(ObjectBooleanHashMapWithHashingStrategy.this.keys[i]), ObjectBooleanHashMapWithHashingStrategy.this.values.get(i)), index);
                ++index;
            }
        }

        @Override
        public <P> void forEachWith(Procedure2<? super ObjectBooleanPair<K>, ? super P> procedure, P parameter) {
            for (int i = 0; i < ObjectBooleanHashMapWithHashingStrategy.this.keys.length; ++i) {
                if (!ObjectBooleanHashMapWithHashingStrategy.isNonSentinel(ObjectBooleanHashMapWithHashingStrategy.this.keys[i])) continue;
                procedure.value(PrimitiveTuples.pair(ObjectBooleanHashMapWithHashingStrategy.this.toNonSentinel(ObjectBooleanHashMapWithHashingStrategy.this.keys[i]), ObjectBooleanHashMapWithHashingStrategy.this.values.get(i)), parameter);
            }
        }

        @Override
        public Iterator<ObjectBooleanPair<K>> iterator() {
            return new InternalKeyValuesIterator();
        }

        public class InternalKeyValuesIterator
        implements Iterator<ObjectBooleanPair<K>> {
            private int count;
            private int position;

            @Override
            public boolean hasNext() {
                return this.count != ObjectBooleanHashMapWithHashingStrategy.this.size();
            }

            @Override
            public ObjectBooleanPair<K> next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                Object[] keys = ObjectBooleanHashMapWithHashingStrategy.this.keys;
                while (!ObjectBooleanHashMapWithHashingStrategy.isNonSentinel(keys[this.position])) {
                    ++this.position;
                }
                ObjectBooleanPair<Object> result = PrimitiveTuples.pair(ObjectBooleanHashMapWithHashingStrategy.this.toNonSentinel(ObjectBooleanHashMapWithHashingStrategy.this.keys[this.position]), ObjectBooleanHashMapWithHashingStrategy.this.values.get(this.position));
                ++this.count;
                ++this.position;
                return result;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("Cannot call remove() on " + this.getClass().getSimpleName());
            }
        }
    }

    private class KeysView
    extends AbstractLazyIterable<K> {
        private KeysView() {
        }

        @Override
        public void each(Procedure<? super K> procedure) {
            ObjectBooleanHashMapWithHashingStrategy.this.forEachKey(procedure);
        }

        @Override
        public void forEachWithIndex(ObjectIntProcedure<? super K> objectIntProcedure) {
            int index = 0;
            for (int i = 0; i < ObjectBooleanHashMapWithHashingStrategy.this.keys.length; ++i) {
                if (!ObjectBooleanHashMapWithHashingStrategy.isNonSentinel(ObjectBooleanHashMapWithHashingStrategy.this.keys[i])) continue;
                objectIntProcedure.value(ObjectBooleanHashMapWithHashingStrategy.this.toNonSentinel(ObjectBooleanHashMapWithHashingStrategy.this.keys[i]), index);
                ++index;
            }
        }

        @Override
        public <P> void forEachWith(Procedure2<? super K, ? super P> procedure, P parameter) {
            for (int i = 0; i < ObjectBooleanHashMapWithHashingStrategy.this.keys.length; ++i) {
                if (!ObjectBooleanHashMapWithHashingStrategy.isNonSentinel(ObjectBooleanHashMapWithHashingStrategy.this.keys[i])) continue;
                procedure.value(ObjectBooleanHashMapWithHashingStrategy.this.toNonSentinel(ObjectBooleanHashMapWithHashingStrategy.this.keys[i]), parameter);
            }
        }

        @Override
        public Iterator<K> iterator() {
            return new InternalKeysViewIterator();
        }

        public class InternalKeysViewIterator<K>
        implements Iterator<K> {
            private int count;
            private int position;

            @Override
            public boolean hasNext() {
                return this.count != ObjectBooleanHashMapWithHashingStrategy.this.size();
            }

            @Override
            public K next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                Object[] keys = ObjectBooleanHashMapWithHashingStrategy.this.keys;
                while (!ObjectBooleanHashMapWithHashingStrategy.isNonSentinel(keys[this.position])) {
                    ++this.position;
                }
                Object result = ObjectBooleanHashMapWithHashingStrategy.this.keys[this.position];
                ++this.count;
                ++this.position;
                return (K)result;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("Cannot call remove() on " + this.getClass().getSimpleName());
            }
        }
    }

    private class ValuesCollection
    implements MutableBooleanCollection {
        private ValuesCollection() {
        }

        @Override
        public boolean add(boolean element) {
            throw new UnsupportedOperationException("Cannot call add() on " + this.getClass().getSimpleName());
        }

        @Override
        public boolean addAll(boolean ... source) {
            throw new UnsupportedOperationException("Cannot call addAll() on " + this.getClass().getSimpleName());
        }

        @Override
        public boolean addAll(BooleanIterable source) {
            throw new UnsupportedOperationException("Cannot call addAll() on " + this.getClass().getSimpleName());
        }

        @Override
        public boolean remove(boolean element) {
            for (int i = 0; i < ObjectBooleanHashMapWithHashingStrategy.this.values.size(); ++i) {
                if (ObjectBooleanHashMapWithHashingStrategy.this.values.get(i) != element || !ObjectBooleanHashMapWithHashingStrategy.isNonSentinel(ObjectBooleanHashMapWithHashingStrategy.this.keys[i])) continue;
                ObjectBooleanHashMapWithHashingStrategy.this.removeKey(ObjectBooleanHashMapWithHashingStrategy.this.toNonSentinel(ObjectBooleanHashMapWithHashingStrategy.this.keys[i]));
                return true;
            }
            return false;
        }

        @Override
        public boolean removeAll(BooleanIterable source) {
            int oldSize = ObjectBooleanHashMapWithHashingStrategy.this.size();
            BooleanIterator iterator = source.booleanIterator();
            while (iterator.hasNext()) {
                this.remove(iterator.next());
            }
            return oldSize != ObjectBooleanHashMapWithHashingStrategy.this.size();
        }

        @Override
        public boolean removeAll(boolean ... source) {
            int oldSize = ObjectBooleanHashMapWithHashingStrategy.this.size();
            for (boolean item : source) {
                this.remove(item);
            }
            return oldSize != ObjectBooleanHashMapWithHashingStrategy.this.size();
        }

        @Override
        public boolean retainAll(BooleanIterable source) {
            int oldSize = ObjectBooleanHashMapWithHashingStrategy.this.size();
            BooleanSet sourceSet = source instanceof BooleanSet ? (BooleanSet)source : source.toSet();
            MutableObjectBooleanMap retained = ObjectBooleanHashMapWithHashingStrategy.this.select((T object, boolean value) -> sourceSet.contains(value));
            if (((ObjectBooleanHashMapWithHashingStrategy)retained).size() != oldSize) {
                ObjectBooleanHashMapWithHashingStrategy.access$502(ObjectBooleanHashMapWithHashingStrategy.this, ((ObjectBooleanHashMapWithHashingStrategy)retained).keys);
                ObjectBooleanHashMapWithHashingStrategy.this.values = ((ObjectBooleanHashMapWithHashingStrategy)retained).values;
                ObjectBooleanHashMapWithHashingStrategy.this.occupiedWithData = ((ObjectBooleanHashMapWithHashingStrategy)retained).occupiedWithData;
                ObjectBooleanHashMapWithHashingStrategy.this.occupiedWithSentinels = ((ObjectBooleanHashMapWithHashingStrategy)retained).occupiedWithSentinels;
                return true;
            }
            return false;
        }

        @Override
        public boolean retainAll(boolean ... source) {
            return this.retainAll(BooleanHashSet.newSetWith(source));
        }

        @Override
        public void clear() {
            ObjectBooleanHashMapWithHashingStrategy.this.clear();
        }

        @Override
        public MutableBooleanCollection with(boolean element) {
            throw new UnsupportedOperationException("Cannot call with() on " + this.getClass().getSimpleName());
        }

        @Override
        public MutableBooleanCollection without(boolean element) {
            throw new UnsupportedOperationException("Cannot call without() on " + this.getClass().getSimpleName());
        }

        @Override
        public MutableBooleanCollection withAll(BooleanIterable elements) {
            throw new UnsupportedOperationException("Cannot call withAll() on " + this.getClass().getSimpleName());
        }

        @Override
        public MutableBooleanCollection withoutAll(BooleanIterable elements) {
            throw new UnsupportedOperationException("Cannot call withoutAll() on " + this.getClass().getSimpleName());
        }

        @Override
        public MutableBooleanCollection asUnmodifiable() {
            return UnmodifiableBooleanCollection.of(this);
        }

        @Override
        public MutableBooleanCollection asSynchronized() {
            return SynchronizedBooleanCollection.of(this);
        }

        @Override
        public ImmutableBooleanCollection toImmutable() {
            return BooleanLists.immutable.withAll(this);
        }

        @Override
        public MutableBooleanCollection select(BooleanPredicate predicate) {
            return ObjectBooleanHashMapWithHashingStrategy.this.select(predicate);
        }

        @Override
        public MutableBooleanCollection reject(BooleanPredicate predicate) {
            return ObjectBooleanHashMapWithHashingStrategy.this.reject(predicate);
        }

        @Override
        public MutableBooleanIterator booleanIterator() {
            return ObjectBooleanHashMapWithHashingStrategy.this.booleanIterator();
        }

        @Override
        public boolean[] toArray() {
            return ObjectBooleanHashMapWithHashingStrategy.this.toArray();
        }

        @Override
        public boolean[] toArray(boolean[] target) {
            return ObjectBooleanHashMapWithHashingStrategy.this.toArray(target);
        }

        @Override
        public <V> MutableCollection<V> collect(BooleanToObjectFunction<? extends V> function) {
            return ObjectBooleanHashMapWithHashingStrategy.this.collect((BooleanToObjectFunction)function);
        }

        @Override
        public boolean contains(boolean value) {
            return ObjectBooleanHashMapWithHashingStrategy.this.containsValue(value);
        }

        @Override
        public boolean containsAll(boolean ... source) {
            return ObjectBooleanHashMapWithHashingStrategy.this.containsAll(source);
        }

        @Override
        public boolean containsAll(BooleanIterable source) {
            return ObjectBooleanHashMapWithHashingStrategy.this.containsAll(source);
        }

        @Override
        public void forEach(BooleanProcedure procedure) {
            ObjectBooleanHashMapWithHashingStrategy.this.forEach(procedure);
        }

        @Override
        public void each(BooleanProcedure procedure) {
            ObjectBooleanHashMapWithHashingStrategy.this.forEach(procedure);
        }

        @Override
        public boolean detectIfNone(BooleanPredicate predicate, boolean ifNone) {
            return ObjectBooleanHashMapWithHashingStrategy.this.detectIfNone(predicate, ifNone);
        }

        @Override
        public int count(BooleanPredicate predicate) {
            return ObjectBooleanHashMapWithHashingStrategy.this.count(predicate);
        }

        @Override
        public boolean anySatisfy(BooleanPredicate predicate) {
            return ObjectBooleanHashMapWithHashingStrategy.this.anySatisfy(predicate);
        }

        @Override
        public boolean allSatisfy(BooleanPredicate predicate) {
            return ObjectBooleanHashMapWithHashingStrategy.this.allSatisfy(predicate);
        }

        @Override
        public boolean noneSatisfy(BooleanPredicate predicate) {
            return ObjectBooleanHashMapWithHashingStrategy.this.noneSatisfy(predicate);
        }

        @Override
        public MutableBooleanList toList() {
            return ObjectBooleanHashMapWithHashingStrategy.this.toList();
        }

        @Override
        public MutableBooleanSet toSet() {
            return ObjectBooleanHashMapWithHashingStrategy.this.toSet();
        }

        @Override
        public MutableBooleanBag toBag() {
            return ObjectBooleanHashMapWithHashingStrategy.this.toBag();
        }

        @Override
        public LazyBooleanIterable asLazy() {
            return new LazyBooleanIterableAdapter(this);
        }

        @Override
        public <T> T injectInto(T injectedValue, ObjectBooleanToObjectFunction<? super T, ? extends T> function) {
            return ObjectBooleanHashMapWithHashingStrategy.this.injectInto(injectedValue, function);
        }

        @Override
        public RichIterable<BooleanIterable> chunk(int size) {
            return ObjectBooleanHashMapWithHashingStrategy.this.chunk(size);
        }

        @Override
        public int size() {
            return ObjectBooleanHashMapWithHashingStrategy.this.size();
        }

        @Override
        public boolean isEmpty() {
            return ObjectBooleanHashMapWithHashingStrategy.this.isEmpty();
        }

        @Override
        public boolean notEmpty() {
            return ObjectBooleanHashMapWithHashingStrategy.this.notEmpty();
        }

        @Override
        public String makeString() {
            return this.makeString(", ");
        }

        @Override
        public String makeString(String separator) {
            return this.makeString("", separator, "");
        }

        @Override
        public String makeString(String start, String separator, String end) {
            StringBuilder stringBuilder = new StringBuilder();
            this.appendString(stringBuilder, start, separator, end);
            return ((Object)stringBuilder).toString();
        }

        @Override
        public void appendString(Appendable appendable) {
            this.appendString(appendable, ", ");
        }

        @Override
        public void appendString(Appendable appendable, String separator) {
            this.appendString(appendable, "", separator, "");
        }

        @Override
        public void appendString(Appendable appendable, String start, String separator, String end) {
            try {
                appendable.append(start);
                boolean first = true;
                for (int i = 0; i < ObjectBooleanHashMapWithHashingStrategy.this.keys.length; ++i) {
                    Object key = ObjectBooleanHashMapWithHashingStrategy.this.keys[i];
                    if (!ObjectBooleanHashMapWithHashingStrategy.isNonSentinel(key)) continue;
                    if (!first) {
                        appendable.append(separator);
                    }
                    appendable.append(String.valueOf(ObjectBooleanHashMapWithHashingStrategy.this.values.get(i)));
                    first = false;
                }
                appendable.append(end);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

