/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.gmfdiag.extensionpoints.editors.ui;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.papyrus.infra.gmfdiag.extensionpoints.editors.Activator;
import org.eclipse.papyrus.infra.gmfdiag.extensionpoints.editors.ui.ILabelEditorDialog;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Shell;

public class LabelEditorDialog
extends Dialog
implements ILabelEditorDialog {
    protected String title;
    protected String value = "";
    protected IInputValidator validator;
    protected Button okButton;
    protected CLabel errorMessageText;
    protected String errorMessage;
    protected SourceViewer viewer;

    public LabelEditorDialog(Shell parentShell, String dialogTitle, String initialValue, IInputValidator validator) {
        super(parentShell);
        this.title = dialogTitle;
        this.value = initialValue == null ? "" : initialValue;
        this.validator = validator;
    }

    protected void buttonPressed(int buttonId) {
        this.value = buttonId == 0 ? this.viewer.getDocument().get() : null;
        super.buttonPressed(buttonId);
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        if (this.title != null) {
            shell.setText(this.title);
        }
    }

    protected Button getOkButton() {
        return this.okButton;
    }

    protected SourceViewer getSourceViewer() {
        return this.viewer;
    }

    protected IInputValidator getValidator() {
        return this.validator;
    }

    @Override
    public String getValue() {
        return this.value;
    }

    protected void validateInput() {
        String errorMessage = null;
        if (this.validator != null) {
            errorMessage = this.validator.isValid(this.viewer.getDocument().get());
        }
        this.setErrorMessage(errorMessage);
    }

    public void setErrorMessage(String errorMessage) {
        this.errorMessage = errorMessage;
        if (this.errorMessageText != null && !this.errorMessageText.isDisposed()) {
            Image errorImage = Activator.getImage("icons/error.gif");
            this.errorMessageText.setImage(errorMessage == null ? null : errorImage);
            this.errorMessageText.setText(errorMessage == null ? "" : errorMessage);
            this.errorMessageText.getParent().update();
            Button button = this.getButton(0);
            if (button != null) {
                button.setEnabled(errorMessage == null);
            }
        }
    }
}

