/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.composite.custom.utils;

import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.EditPart;
import org.eclipse.gmf.runtime.diagram.core.util.ViewUtil;
import org.eclipse.gmf.runtime.diagram.ui.requests.CreateViewRequest;
import org.eclipse.gmf.runtime.notation.Bounds;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.Node;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.infra.core.resource.ModelSet;
import org.eclipse.papyrus.infra.core.services.ServicesRegistry;
import org.eclipse.papyrus.infra.emf.utils.ServiceUtilsForEObject;
import org.eclipse.papyrus.infra.gmfdiag.common.editpart.NodeEditPart;
import org.eclipse.papyrus.infra.gmfdiag.common.model.NotationModel;
import org.eclipse.papyrus.infra.gmfdiag.common.utils.DiagramEditPartsUtil;
import org.eclipse.papyrus.infra.tools.util.TypeUtils;
import org.eclipse.papyrus.uml.diagram.common.Activator;
import org.eclipse.papyrus.uml.diagram.common.helper.RelativePortLocation;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.Type;

public class CompositeStructureDiagramUtils {
    public static boolean isCompositeStructureDiagram(Diagram diagram) {
        EObject businessElement;
        if (diagram == null) {
            return false;
        }
        return "CompositeStructure".equals(diagram.getType()) && (businessElement = diagram.getElement()) instanceof Class;
    }

    public static Diagram getCompositeStructureDiagram(Class component) {
        return DiagramEditPartsUtil.getDiagram((EObject)component, CompositeStructureDiagramUtils::isCompositeStructureDiagram);
    }

    public static View getPartTypeFirstView(Class typingClass) {
        View view = null;
        try {
            ServicesRegistry servicesRegistry = ServiceUtilsForEObject.getInstance().getServiceRegistry((EObject)typingClass);
            ModelSet modelSet = (ModelSet)servicesRegistry.getService(ModelSet.class);
            NotationModel notation = (NotationModel)modelSet.getModel("org.eclipse.papyrus.infra.core.resource.notation.NotationModel");
            List diagrams = notation.getResource().getContents().stream().map(Diagram.class::cast).collect(Collectors.toList());
            for (Diagram d : diagrams) {
                for (View child : d.getChildren()) {
                    EObject semanticChild = ViewUtil.resolveSemanticElement((View)child);
                    if (semanticChild == null || !semanticChild.equals(typingClass)) continue;
                    return child;
                }
            }
        }
        catch (Exception e) {
            Activator.log.error((Throwable)e);
        }
        return view;
    }

    public static Class getPartType(EditPart partEditPart) {
        Type type;
        View model;
        EObject elementEObj;
        Object modelObj = partEditPart.getModel();
        if (modelObj instanceof View && (elementEObj = (model = (View)modelObj).getElement()) instanceof Property && (type = ((Property)elementEObj).getType()) instanceof Class) {
            return (Class)type;
        }
        return null;
    }

    public static Point getInitialPortLocation(EditPart partEditPart, EObject port, CreateViewRequest.ViewDescriptor descriptor) {
        Class typingClass = CompositeStructureDiagramUtils.getPartType(partEditPart);
        View typingClassView = null;
        Diagram d = null;
        if (typingClass != null && (typingClassView = (d = CompositeStructureDiagramUtils.getCompositeStructureDiagram(typingClass)) != null ? ViewUtil.getChildBySemanticHint((View)d, (String)"Class_Shape") : CompositeStructureDiagramUtils.getPartTypeFirstView(typingClass)) != null) {
            View portOnTypingClass = null;
            for (Object child : typingClassView.getChildren()) {
                if (!(child instanceof View) || ((View)child).getElement() != port) continue;
                portOnTypingClass = (View)child;
                break;
            }
            if (portOnTypingClass != null) {
                Bounds typingClassBounds = (Bounds)TypeUtils.as((Object)((Node)typingClassView).getLayoutConstraint(), Bounds.class);
                Bounds portOnTypingClassBounds = (Bounds)TypeUtils.as((Object)((Node)portOnTypingClass).getLayoutConstraint(), Bounds.class);
                int portWidth = portOnTypingClassBounds.getWidth();
                int portHeight = portOnTypingClassBounds.getHeight();
                Rectangle r = new Rectangle(portOnTypingClassBounds.getX(), portOnTypingClassBounds.getY(), portWidth, portHeight);
                RelativePortLocation relative = RelativePortLocation.of((Rectangle)r, (Rectangle)new Rectangle(0, 0, typingClassBounds.getWidth(), typingClassBounds.getHeight()));
                Rectangle partBounds = ((NodeEditPart)partEditPart).getFigure().getBounds();
                return relative.applyTo(partBounds, new Dimension(portWidth, portHeight));
            }
        }
        return null;
    }
}

