/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.commands.command;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.common.command.AbstractCommand;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gmf.runtime.common.core.command.CompositeCommand;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.emf.type.core.requests.DuplicateElementsRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.IEditCommandRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.MoveRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.SetRequest;
import org.eclipse.papyrus.infra.services.edit.service.ElementEditServiceUtils;
import org.eclipse.papyrus.infra.services.edit.service.IElementEditService;
import org.eclipse.papyrus.uml.commands.Activator;
import org.eclipse.papyrus.uml.tools.utils.NamedElementUtil;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.Stereotype;
import org.eclipse.uml2.uml.UMLFactory;
import org.eclipse.uml2.uml.util.UMLUtil;

public class PasteElementCommand
extends AbstractCommand {
    private static final String TARGET_OWNER = "Target_Owner";
    private static final String ADDITIONAL_DUPLICATED_ELEMENTS = "Additional_Duplicated_Elements";
    protected List<EObject> eobjectTopaste = null;
    protected List<EObject> stereotypeApplicationTopaste = null;
    protected EObject targetOwner;
    protected CompositeCommand command;

    public PasteElementCommand(EditingDomain domain, EObject targetOwner) {
        if (domain.getClipboard() != null) {
            Collection rawData = domain.getClipboard();
            ArrayList<Object> eobjectsTopaste = new ArrayList<Object>();
            for (Object object : rawData) {
                if (!(object instanceof EObject)) continue;
                eobjectsTopaste.add((EObject)object);
            }
            ArrayList originalStereotypeApplications = new ArrayList();
            for (EObject eObject : eobjectsTopaste) {
                if (eObject instanceof Element) {
                    originalStereotypeApplications.addAll(((Element)eObject).getStereotypeApplications());
                }
                TreeIterator iter = eObject.eAllContents();
                while (iter.hasNext()) {
                    EObject subeObject = (EObject)iter.next();
                    if (!(subeObject instanceof Element)) continue;
                    originalStereotypeApplications.addAll(((Element)subeObject).getStereotypeApplications());
                }
            }
            eobjectsTopaste.addAll(originalStereotypeApplications);
            EcoreUtil.Copier copier = new EcoreUtil.Copier();
            copier.copyAll(eobjectsTopaste);
            copier.copyReferences();
            HashMap duplicatedObjects = new HashMap();
            duplicatedObjects.putAll(copier);
            Iterator iter = duplicatedObjects.values().iterator();
            this.eobjectTopaste = new ArrayList<EObject>();
            this.stereotypeApplicationTopaste = new ArrayList<EObject>();
            while (iter.hasNext()) {
                EObject eObject = (EObject)iter.next();
                boolean isaUMLElement = false;
                if (eObject instanceof Element) {
                    isaUMLElement = true;
                }
                Stereotype st = UMLUtil.getStereotype((EObject)eObject);
                if (!isaUMLElement || originalStereotypeApplications.contains(eObject)) continue;
                this.eobjectTopaste.add(eObject);
            }
            ListIterator stereotypeIterator = originalStereotypeApplications.listIterator();
            while (stereotypeIterator.hasNext()) {
                EObject originalStereotypeApp = (EObject)stereotypeIterator.next();
                EObject duplicateStereotype = (EObject)duplicatedObjects.get(originalStereotypeApp);
                if (duplicateStereotype == null) {
                    Activator.log.debug("warning a stereotype could not be copied/paste : " + String.valueOf(originalStereotypeApp));
                    continue;
                }
                this.stereotypeApplicationTopaste.add(duplicateStereotype);
            }
            this.targetOwner = targetOwner;
            ArrayList<EObject> objectsToMove = new ArrayList<EObject>();
            for (EObject eObject : eobjectsTopaste) {
                EObject copyObject;
                boolean isaUMLElement = false;
                if (eObject instanceof Element) {
                    isaUMLElement = true;
                }
                if (!isaUMLElement || originalStereotypeApplications.contains(eObject) || (copyObject = (EObject)duplicatedObjects.get(eObject)) == null) continue;
                objectsToMove.add(copyObject);
            }
            MoveRequest moveRequest = new MoveRequest(targetOwner, objectsToMove);
            IElementEditService provider = ElementEditServiceUtils.getCommandProvider((EObject)targetOwner);
            if (provider != null) {
                this.command = new CompositeCommand("Copy Object");
                this.command.compose((IUndoableOperation)provider.getEditCommand((IEditCommandRequest)moveRequest));
            }
            this.renameDuplicatedObject(domain, targetOwner, objectsToMove, provider);
            ICommand externalObjectsDuplicateCommand = this.getExternalObjectsDuplicateCommand(duplicatedObjects, targetOwner);
            if (externalObjectsDuplicateCommand != null && this.command != null) {
                this.command.compose((IUndoableOperation)externalObjectsDuplicateCommand);
            }
        }
    }

    private void renameDuplicatedObject(EditingDomain domain, EObject targetOwner, List<EObject> objectsToMove, IElementEditService provider) {
        int i = 0;
        while (i < objectsToMove.size()) {
            EObject element = objectsToMove.get(i);
            if (element instanceof NamedElement && domain instanceof TransactionalEditingDomain) {
                String incrementedName = NamedElementUtil.getDefaultCopyNameWithIncrement((NamedElement)((NamedElement)element), (Collection)targetOwner.eContents());
                SetRequest renameRequest = new SetRequest((TransactionalEditingDomain)domain, element, (EStructuralFeature)UMLFactory.eINSTANCE.getUMLPackage().getNamedElement_Name(), (Object)incrementedName);
                if (provider != null && this.command != null) {
                    this.command.compose((IUndoableOperation)provider.getEditCommand((IEditCommandRequest)renameRequest));
                }
            }
            ++i;
        }
    }

    public void execute() {
        if (this.command != null) {
            try {
                this.command.execute((IProgressMonitor)new NullProgressMonitor(), null);
            }
            catch (ExecutionException e) {
                Activator.log.error((Throwable)e);
            }
        }
        for (EObject eObject : this.stereotypeApplicationTopaste) {
            this.targetOwner.eResource().getContents().add((Object)eObject);
        }
    }

    public boolean canExecute() {
        if (this.command == null) {
            return false;
        }
        return this.command.canExecute();
    }

    public void redo() {
        if (this.command != null) {
            try {
                this.command.redo((IProgressMonitor)new NullProgressMonitor(), null);
            }
            catch (ExecutionException e) {
                Activator.log.error((Throwable)e);
            }
        }
        for (EObject eObject : this.stereotypeApplicationTopaste) {
            this.targetOwner.eResource().getContents().add((Object)eObject);
        }
    }

    public void undo() {
        try {
            NullProgressMonitor monitor = new NullProgressMonitor();
            this.command.undo((IProgressMonitor)monitor, null);
        }
        catch (ExecutionException e) {
            Activator.log.error((Throwable)e);
        }
        for (EObject eObject : this.stereotypeApplicationTopaste) {
            this.targetOwner.eResource().getContents().remove((Object)eObject);
        }
    }

    protected ICommand getExternalObjectsDuplicateCommand(Map duplicatedElementsMap, EObject targetOwner) {
        CompositeCommand result = new CompositeCommand("Additional Duplications");
        HashSet duplicatedExternalElements = new HashSet();
        for (Object o : duplicatedElementsMap.keySet()) {
            if (!(o instanceof EObject)) continue;
            EObject object = (EObject)o;
            DuplicateElementsRequest request = new DuplicateElementsRequest(Collections.singletonList(object));
            request.setAllDuplicatedElementsMap(duplicatedElementsMap);
            request.setParameter(ADDITIONAL_DUPLICATED_ELEMENTS, duplicatedExternalElements);
            request.setParameter(TARGET_OWNER, (Object)targetOwner);
            IElementEditService service = ElementEditServiceUtils.getCommandProvider((EObject)object);
            ICommand command = service.getEditCommand((IEditCommandRequest)request);
            if (command == null) continue;
            result.add((IUndoableOperation)command);
        }
        return result.isEmpty() ? null : result.reduce();
    }
}

