/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.emf.facet.widgets.celleditors.ecore.composite;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.papyrus.emf.facet.widgets.celleditors.IValidator;
import org.eclipse.papyrus.emf.facet.widgets.celleditors.ecore.composite.StringComposite;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;

public class ByteComposite
extends StringComposite<Byte> {
    public ByteComposite(Composite parent) {
        this(parent, 0);
    }

    public ByteComposite(Composite parent, int style) {
        super(parent, style);
        this.getTextField().addListener(25, new Listener(){

            public void handleEvent(Event event) {
                String input = event.text;
                int i = 0;
                while (i < input.length()) {
                    char ch = input.charAt(i);
                    if (ch != '-') {
                        if ('0' > ch || ch > '9') {
                            event.doit = false;
                            return;
                        }
                    } else {
                        if (ByteComposite.this.getTextField().getText().indexOf(45) != -1) {
                            event.doit = false;
                            return;
                        }
                        if (event.start != 0) {
                            event.doit = false;
                            return;
                        }
                    }
                    ++i;
                }
            }
        });
    }

    public IValidator getValidator() {
        return new IValidator(){

            public IStatus validate(Object object) {
                if (ByteComposite.this.getValue() != null && -128 <= (Byte)ByteComposite.this.getValue() && (Byte)ByteComposite.this.getValue() <= 127) {
                    return Status.OK_STATUS;
                }
                return new Status(4, "org.eclipse.papyrus.emf.facet.widgets.celleditors.ecore", "");
            }
        };
    }

    @Override
    public StringComposite.IConverter<Byte> initConverter() {
        return new StringComposite.IConverter<Byte>(){

            @Override
            public Byte toObject(String string) {
                if (string != null && string.length() > 0) {
                    try {
                        return new Byte(string);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        return null;
                    }
                }
                return null;
            }

            @Override
            public String toString(Byte object) {
                return object.toString();
            }
        };
    }

    @Override
    public IStatus validate(String string) {
        try {
            if (string.length() > 0) {
                Byte.parseByte(string);
            }
        }
        catch (Exception e) {
            return new Status(4, "org.eclipse.papyrus.emf.facet.widgets.celleditors.ecore", "");
        }
        return new Status(0, "org.eclipse.papyrus.emf.facet.widgets.celleditors.ecore", "");
    }
}

