/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.editor.welcome.internal;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.xmi.impl.XMIResourceImpl;
import org.eclipse.emf.transaction.RollbackException;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.papyrus.infra.core.resource.ModelSet;
import org.eclipse.papyrus.infra.core.sasheditor.di.contentprovider.utils.TransactionHelper;
import org.eclipse.papyrus.infra.editor.welcome.Welcome;
import org.eclipse.papyrus.infra.editor.welcome.WelcomeFactory;
import org.eclipse.papyrus.infra.editor.welcome.WelcomePackage;
import org.eclipse.papyrus.infra.editor.welcome.internal.Activator;

public class WelcomeModelManager {
    private final URI welcomeURI = URI.createURI((String)"papyrus.welcome:dynamic");
    private final Path welcomePath;
    private final Map<ModelSet, WelcomeLocator> resourceSets = new HashMap<ModelSet, WelcomeLocator>();
    private final Map<ModelSet, Consumer<Welcome>> welcomeChangedHandlers = new HashMap<ModelSet, Consumer<Welcome>>();

    public WelcomeModelManager(Path stateLocation) {
        this.welcomePath = stateLocation.resolve("welcome.xmi").toAbsolutePath();
    }

    public URI getWelcomeURI() {
        return this.welcomeURI;
    }

    public boolean welcomeModelExists() {
        return Files.exists(this.welcomePath, new LinkOption[0]);
    }

    public Welcome getWelcome(ResourceSet resourceSet) {
        Resource resource = this.getWelcomeResource(resourceSet);
        return resource == null ? null : WelcomeModelManager.getWelcome(resource);
    }

    public Resource getWelcomeResource(ResourceSet resourceSet) {
        return resourceSet.getResource(this.getWelcomeURI(), true);
    }

    public void connect(ModelSet resourceSet) {
        this.resourceSets.put(resourceSet, new WelcomeLocator(resourceSet));
    }

    public void disconnect(ModelSet resourceSet) {
        this.welcomeChangedHandlers.remove(resourceSet);
        WelcomeLocator locator = this.resourceSets.remove(resourceSet);
        if (locator != null) {
            locator.dispose();
        }
    }

    public void onWelcomeChanged(ModelSet ownerModelSet, Consumer<? super Welcome> welcomeChangedHandler) {
        if (!this.resourceSets.containsKey(ownerModelSet)) {
            throw new IllegalArgumentException("ownerModelSet is not connected");
        }
        this.welcomeChangedHandlers.put(ownerModelSet, this.getWelcomeChangedHandler((ResourceSet)ownerModelSet).andThen(welcomeChangedHandler));
    }

    private Consumer<Welcome> getWelcomeChangedHandler(ResourceSet resourceSet) {
        return this.welcomeChangedHandlers.getOrDefault(resourceSet, Objects::requireNonNull);
    }

    public void createDefaultWelcomeResource(Welcome welcome) throws IOException {
        XMIResourceImpl welcomeResource = new XMIResourceImpl(this.getWelcomeURI());
        welcomeResource.getContents().add((Object)EcoreUtil.copy((EObject)welcome));
        try {
            try {
                Throwable throwable = null;
                Object var4_6 = null;
                try (OutputStream output = Files.newOutputStream(this.welcomePath, StandardOpenOption.WRITE, StandardOpenOption.CREATE);){
                    welcomeResource.save(output, null);
                    this.notifyDefaultChanged();
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (IOException e) {
                Files.deleteIfExists(this.welcomePath);
                throw e;
            }
        }
        finally {
            welcomeResource.unload();
            welcomeResource.eAdapters().clear();
        }
    }

    public void deleteDefaultWelcomeResource() throws IOException {
        Files.deleteIfExists(this.welcomePath);
        this.notifyDefaultChanged();
    }

    private void notifyDefaultChanged() {
        this.resourceSets.keySet().stream().map(this::getWelcomeResource).forEach(Resource::unload);
    }

    static Welcome getWelcome(Resource resource) {
        return (Welcome)EcoreUtil.getObjectByType((Collection)resource.getContents(), (EClassifier)WelcomePackage.Literals.WELCOME);
    }

    static Welcome become(final Welcome oldObject, final Welcome newObject) {
        if (oldObject == newObject) {
            return oldObject;
        }
        oldObject.eClass().getEAllStructuralFeatures().stream().filter(EStructuralFeature::isChangeable).forEach(f -> oldObject.eUnset((EStructuralFeature)f));
        EcoreUtil.Copier copier = new EcoreUtil.Copier(true, true){

            protected EObject createCopy(EObject eObject) {
                return eObject == newObject ? oldObject : super.createCopy(eObject);
            }
        };
        EcoreUtil.replace((EObject)newObject, (EObject)oldObject);
        return (Welcome)copier.copy((EObject)newObject);
    }

    private class DefaultWelcomeAdapter
    extends AdapterImpl {
        private Welcome realWelcome;

        private DefaultWelcomeAdapter() {
        }

        public void unsetTarget(Notifier oldTarget) {
            super.unsetTarget(oldTarget);
            this.realWelcome = null;
        }

        public void notifyChanged(Notification msg) {
            if (msg.getNotifier() instanceof Resource) {
                switch (msg.getFeatureID(Resource.class)) {
                    case 2: {
                        switch (msg.getEventType()) {
                            case 4: {
                                if (!(msg.getOldValue() instanceof Welcome)) break;
                                this.realWelcome = (Welcome)msg.getOldValue();
                                break;
                            }
                            case 6: {
                                this.realWelcome = (Welcome)EcoreUtil.getObjectByType((Collection)((Collection)msg.getOldValue()), (EClassifier)WelcomePackage.Literals.WELCOME);
                            }
                        }
                        break;
                    }
                    case 4: {
                        if (!msg.getOldBooleanValue() || msg.getNewBooleanValue()) break;
                        ResourceSet rset = ((Resource)msg.getNotifier()).getResourceSet();
                        try {
                            TransactionHelper.run((TransactionalEditingDomain)TransactionUtil.getEditingDomain((ResourceSet)rset), () -> {
                                Welcome newWelcome = WelcomeModelManager.this.getWelcome(rset);
                                WelcomeModelManager.become(this.realWelcome, newWelcome);
                                ((InternalEObject)this.realWelcome).eSetProxyURI(null);
                            });
                        }
                        catch (InterruptedException | RollbackException e) {
                            Activator.log.error("Failed to re-load the default welcome model.", e);
                        }
                        WelcomeModelManager.this.getWelcomeChangedHandler(rset).accept(this.realWelcome);
                        this.realWelcome = null;
                    }
                }
            }
        }
    }

    private class WelcomeLocator
    extends ResourceSetImpl.ResourceLocator {
        private final Resource welcomeResource;

        WelcomeLocator(final ModelSet modelSet) {
            super((ResourceSetImpl)modelSet);
            this.welcomeResource = new XMIResourceImpl(WelcomeModelManager.this.getWelcomeURI()){

                public ResourceSet getResourceSet() {
                    return modelSet;
                }

                public NotificationChain basicSetResourceSet(ResourceSet resourceSet, NotificationChain notifications) {
                    throw new UnsupportedOperationException("setResourceSet");
                }
            };
            this.welcomeResource.eAdapters().add((Object)new DefaultWelcomeAdapter());
        }

        public Resource getResource(URI uri, boolean loadOnDemand) {
            Resource result = uri.equals(this.welcomeResource.getURI()) ? this.getWelcomeResource() : this.basicGetResource(uri, loadOnDemand);
            return result;
        }

        protected void demandLoadHelper(Resource resource) {
            if (WelcomeModelManager.this.getWelcomeURI().equals(resource.getURI())) {
                Welcome welcome = null;
                if (WelcomeModelManager.this.welcomeModelExists()) {
                    try {
                        Throwable throwable = null;
                        Object var4_6 = null;
                        try (InputStream input = Files.newInputStream(WelcomeModelManager.this.welcomePath, StandardOpenOption.READ);){
                            this.welcomeResource.load(input, null);
                            welcome = WelcomeModelManager.getWelcome(this.welcomeResource);
                        }
                        catch (Throwable throwable2) {
                            if (throwable == null) {
                                throwable = throwable2;
                            } else if (throwable != throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            throw throwable;
                        }
                    }
                    catch (IOException e) {
                        Activator.log.error("Failed to load default welcome page layout", (Throwable)e);
                        this.welcomeResource.getContents().clear();
                    }
                }
                if (welcome == null) {
                    welcome = WelcomeFactory.eINSTANCE.createWelcome();
                    this.welcomeResource.getContents().add((Object)welcome);
                }
            } else {
                super.demandLoadHelper(resource);
            }
        }

        public void dispose() {
            super.dispose();
            this.welcomeResource.eAdapters().clear();
            this.welcomeResource.unload();
        }

        Resource getWelcomeResource() {
            if (!this.welcomeResource.isLoaded()) {
                this.demandLoadHelper(this.welcomeResource);
            }
            return this.welcomeResource;
        }
    }
}

