/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.filters.provider;

import java.util.Collection;
import java.util.List;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.ResourceLocator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.command.CommandParameter;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.provider.ComposeableAdapterFactory;
import org.eclipse.emf.edit.provider.IChildCreationExtender;
import org.eclipse.emf.edit.provider.IEditingDomainItemProvider;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.emf.edit.provider.IItemPropertyDescriptor;
import org.eclipse.emf.edit.provider.IItemPropertySource;
import org.eclipse.emf.edit.provider.IStructuredItemContentProvider;
import org.eclipse.emf.edit.provider.ITreeItemContentProvider;
import org.eclipse.emf.edit.provider.ItemPropertyDescriptor;
import org.eclipse.emf.edit.provider.ItemProviderAdapter;
import org.eclipse.emf.edit.provider.ViewerNotification;
import org.eclipse.papyrus.infra.filters.Filter;
import org.eclipse.papyrus.infra.filters.FilterReference;
import org.eclipse.papyrus.infra.filters.FiltersFactory;
import org.eclipse.papyrus.infra.filters.FiltersPackage;
import org.eclipse.uml2.common.edit.command.SubsetSupersetSetCommand;

public class FilterReferenceItemProvider
extends ItemProviderAdapter
implements IEditingDomainItemProvider,
IStructuredItemContentProvider,
ITreeItemContentProvider,
IItemLabelProvider,
IItemPropertySource {
    public FilterReferenceItemProvider(AdapterFactory adapterFactory) {
        super(adapterFactory);
    }

    public List<IItemPropertyDescriptor> getPropertyDescriptors(Object object) {
        if (this.itemPropertyDescriptors == null) {
            super.getPropertyDescriptors(object);
            this.addNamePropertyDescriptor(object);
            this.addFilterPropertyDescriptor(object);
        }
        return this.itemPropertyDescriptors;
    }

    protected void addNamePropertyDescriptor(Object object) {
        this.itemPropertyDescriptors.add(this.createItemPropertyDescriptor((AdapterFactory)((ComposeableAdapterFactory)this.adapterFactory).getRootAdapterFactory(), this.getResourceLocator(), this.getString("_UI_Filter_name_feature"), this.getString("_UI_PropertyDescriptor_description", "_UI_Filter_name_feature", "_UI_Filter_type"), (EStructuralFeature)FiltersPackage.Literals.FILTER__NAME, true, false, false, ItemPropertyDescriptor.GENERIC_VALUE_IMAGE, null, null));
    }

    protected void addFilterPropertyDescriptor(Object object) {
        this.itemPropertyDescriptors.add(this.createItemPropertyDescriptor((AdapterFactory)((ComposeableAdapterFactory)this.adapterFactory).getRootAdapterFactory(), this.getResourceLocator(), this.getString("_UI_FilterReference_filter_feature"), this.getString("_UI_PropertyDescriptor_description", "_UI_FilterReference_filter_feature", "_UI_FilterReference_type"), (EStructuralFeature)FiltersPackage.Literals.FILTER_REFERENCE__FILTER, true, false, true, null, null, null));
    }

    public Collection<? extends EStructuralFeature> getChildrenFeatures(Object object) {
        if (this.childrenFeatures == null) {
            super.getChildrenFeatures(object);
            this.childrenFeatures.add(FiltersPackage.Literals.FILTER_REFERENCE__OWNED_FILTER);
        }
        return this.childrenFeatures;
    }

    protected EStructuralFeature getChildFeature(Object object, Object child) {
        return super.getChildFeature(object, child);
    }

    public Object getImage(Object object) {
        return this.overlayImage(object, this.getResourceLocator().getImage("full/obj16/FilterReference"));
    }

    protected boolean shouldComposeCreationImage() {
        return true;
    }

    public String getText(Object object) {
        Filter reference;
        StringBuilder result = new StringBuilder();
        FilterReference filterReference = (FilterReference)object;
        result.append(this.getString("_UI_FilterReference_type"));
        String label = filterReference.getName();
        if (label != null && !label.isBlank()) {
            result.append(" ");
            result.append(label);
        }
        if ((reference = filterReference.getFilter()) != null) {
            String referenceLabel = null;
            IItemLabelProvider provider = (IItemLabelProvider)this.getRootAdapterFactory().adapt((Notifier)reference, IItemLabelProvider.class);
            if (provider != null) {
                referenceLabel = provider.getText((Object)reference);
            }
            if (referenceLabel != null && !referenceLabel.isBlank()) {
                result.append(" -> ");
                result.append(referenceLabel);
            }
        }
        return result.toString();
    }

    public void notifyChanged(Notification notification) {
        this.updateChildren(notification);
        switch (notification.getFeatureID(FilterReference.class)) {
            case 0: 
            case 1: {
                this.fireNotifyChanged((Notification)new ViewerNotification(notification, notification.getNotifier(), false, true));
                return;
            }
            case 2: {
                this.fireNotifyChanged((Notification)new ViewerNotification(notification, notification.getNotifier(), true, false));
                return;
            }
        }
        super.notifyChanged(notification);
    }

    protected void collectNewChildDescriptorsGen(Collection<Object> newChildDescriptors, Object object) {
        super.collectNewChildDescriptors(newChildDescriptors, object);
        newChildDescriptors.add(this.createChildParameter(FiltersPackage.Literals.FILTER_REFERENCE__OWNED_FILTER, FiltersFactory.eINSTANCE.createFilterReference()));
        newChildDescriptors.add(this.createChildParameter(FiltersPackage.Literals.FILTER_REFERENCE__OWNED_FILTER, FiltersFactory.eINSTANCE.createCompoundFilter()));
        newChildDescriptors.add(this.createChildParameter(FiltersPackage.Literals.FILTER_REFERENCE__OWNED_FILTER, FiltersFactory.eINSTANCE.createEquals()));
    }

    protected void collectNewChildDescriptors(Collection<Object> newChildDescriptors, Object object) {
        this.collectNewChildDescriptorsGen(newChildDescriptors, object);
        newChildDescriptors.removeIf(descriptor -> descriptor instanceof CommandParameter && ((CommandParameter)descriptor).getValue() instanceof FilterReference);
    }

    public ResourceLocator getResourceLocator() {
        return ((IChildCreationExtender)this.adapterFactory).getResourceLocator();
    }

    protected Command createSetCommand(EditingDomain domain, EObject owner, EStructuralFeature feature, Object value) {
        if (feature == FiltersPackage.Literals.FILTER_REFERENCE__OWNED_FILTER) {
            return new SubsetSupersetSetCommand(domain, owner, feature, new EStructuralFeature[]{FiltersPackage.Literals.FILTER_REFERENCE__FILTER}, null, value);
        }
        if (feature == FiltersPackage.Literals.FILTER_REFERENCE__FILTER) {
            return new SubsetSupersetSetCommand(domain, owner, feature, null, new EStructuralFeature[]{FiltersPackage.Literals.FILTER_REFERENCE__OWNED_FILTER}, value);
        }
        return super.createSetCommand(domain, owner, feature, value);
    }
}

