/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.editor.welcome.nattable.hyperlink;

import java.util.function.Predicate;
import org.eclipse.nebula.widgets.nattable.NatTable;
import org.eclipse.nebula.widgets.nattable.config.AbstractUiBindingConfiguration;
import org.eclipse.nebula.widgets.nattable.layer.LabelStack;
import org.eclipse.nebula.widgets.nattable.layer.cell.ILayerCell;
import org.eclipse.nebula.widgets.nattable.painter.cell.ICellPainter;
import org.eclipse.nebula.widgets.nattable.ui.action.IMouseAction;
import org.eclipse.nebula.widgets.nattable.ui.binding.UiBindingRegistry;
import org.eclipse.nebula.widgets.nattable.ui.matcher.IMouseEventMatcher;
import org.eclipse.nebula.widgets.nattable.ui.matcher.MouseEventMatcher;
import org.eclipse.papyrus.infra.editor.welcome.nattable.hyperlink.HyperlinkNavigationAction;
import org.eclipse.papyrus.infra.editor.welcome.nattable.painter.LabelPainter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Control;

public class HyperlinkNavigationConfiguration<E>
extends AbstractUiBindingConfiguration {
    private final Class<? extends E> elementType;
    private final Predicate<? super E> isActiveHyperlink;
    private Cursor defaultCursor;
    private Cursor handCursor;
    private int currentColumn = -1;
    private int currentRow = -1;
    private Rectangle currentCellTextBounds;

    public HyperlinkNavigationConfiguration(Control owner, Class<? extends E> elementType, Predicate<? super E> isActiveHyperlink) {
        this.elementType = elementType;
        this.isActiveHyperlink = isActiveHyperlink;
        this.defaultCursor = owner.getCursor();
        this.handCursor = new Cursor((Device)owner.getDisplay(), 21);
        owner.addDisposeListener(event -> this.handCursor.dispose());
    }

    public void configureUiBindings(UiBindingRegistry uiBindingRegistry) {
        uiBindingRegistry.registerSingleClickBinding((IMouseEventMatcher)MouseEventMatcher.bodyLeftClick((int)0), (IMouseAction)new HyperlinkNavigationAction());
        uiBindingRegistry.registerFirstMouseMoveBinding(new IMouseEventMatcher(){

            public boolean matches(NatTable natTable, MouseEvent event, LabelStack regionLabels) {
                int col = natTable.getColumnPositionByX(event.x);
                int row = natTable.getRowPositionByY(event.y);
                return col >= 0 && row >= 0;
            }
        }, this::updateCursor);
        uiBindingRegistry.registerMouseMoveBinding(new IMouseEventMatcher(){

            public boolean matches(NatTable natTable, MouseEvent event, LabelStack regionLabels) {
                return natTable != null && regionLabels == null;
            }
        }, this::reset);
        uiBindingRegistry.registerMouseExitBinding(new IMouseEventMatcher(){

            public boolean matches(NatTable natTable, MouseEvent event, LabelStack regionLabels) {
                return true;
            }
        }, this::reset);
    }

    void updateCursor(NatTable table, MouseEvent event) {
        Object data;
        int col = table.getColumnPositionByX(event.x);
        int row = table.getRowPositionByY(event.y);
        Object object = data = col >= 0 && row >= 0 ? table.getDataValueByPosition(col, row) : null;
        if (!this.elementType.isInstance(data) || !this.isActiveHyperlink.test(this.elementType.cast(data))) {
            table.setCursor(this.defaultCursor);
        } else {
            if (this.currentCellTextBounds == null || col != this.currentColumn || row != this.currentRow) {
                this.updateCellTextBounds(table, col, row);
            }
            if (this.currentCellTextBounds != null && this.currentCellTextBounds.contains(event.x, event.y)) {
                table.setCursor(this.handCursor);
            } else {
                table.setCursor(this.defaultCursor);
            }
        }
    }

    void reset(NatTable table, MouseEvent event) {
        this.currentColumn = -1;
        this.currentRow = -1;
        this.currentCellTextBounds = null;
        table.setCursor(this.defaultCursor);
    }

    void updateCellTextBounds(NatTable table, int column, int row) {
        this.currentColumn = column;
        this.currentRow = row;
        this.currentCellTextBounds = null;
        ILayerCell cell = table.getCellByPosition(column, row);
        if (cell != null) {
            ICellPainter painter = table.getCellPainter(column, row, cell, table.getConfigRegistry());
            if (painter instanceof LabelPainter) {
                GC gc = new GC((Drawable)table.getDisplay());
                try {
                    this.currentCellTextBounds = ((LabelPainter)painter).getTextBounds(cell, gc, table.getConfigRegistry());
                }
                finally {
                    gc.dispose();
                }
            } else {
                this.currentCellTextBounds = cell.getBounds();
            }
        }
    }
}

