/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.sirius.editor.representation.architecture.commands;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.papyrus.infra.core.services.ServiceException;
import org.eclipse.papyrus.infra.core.services.ServicesRegistry;
import org.eclipse.papyrus.sirius.editor.representation.SiriusDiagramPrototype;
import org.eclipse.papyrus.sirius.editor.representation.architecture.Activator;
import org.eclipse.papyrus.sirius.editor.representation.architecture.commands.AbstractCreatePapyrusEditorViewCommand;
import org.eclipse.papyrus.sirius.editor.sirius.ISiriusSessionService;
import org.eclipse.sirius.business.api.dialect.DialectManager;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.diagram.DSemanticDiagram;
import org.eclipse.sirius.diagram.description.DiagramDescription;
import org.eclipse.sirius.viewpoint.description.DAnnotation;
import org.eclipse.sirius.viewpoint.description.DescriptionFactory;
import org.eclipse.sirius.viewpoint.description.RepresentationDescription;

public class CreateSiriusDiagramEditorViewCommand
extends AbstractCreatePapyrusEditorViewCommand<DSemanticDiagram> {
    private final SiriusDiagramPrototype prototype;

    public CreateSiriusDiagramEditorViewCommand(TransactionalEditingDomain domain, SiriusDiagramPrototype diagramTemplatePrototype, String diagramName, String diagramMainTitle, EObject semanticContext, EObject graphicalContext, boolean openAfterCreation, String diagramId) {
        super(domain, "Create new Sirius Diagram", diagramName, semanticContext, graphicalContext, openAfterCreation, diagramId);
        this.prototype = diagramTemplatePrototype;
    }

    public CreateSiriusDiagramEditorViewCommand(TransactionalEditingDomain domain, SiriusDiagramPrototype diagramTemplatePrototype, String diagramName, String diagramMainTitle, EObject semanticContext, boolean openAfterCreation, String diagramId) {
        this(domain, diagramTemplatePrototype, diagramName, diagramMainTitle, semanticContext, null, openAfterCreation, diagramId);
    }

    private ISiriusSessionService getSiriusSessionService() {
        ServicesRegistry servReg = this.getServiceRegistry(this.semanticContext);
        try {
            return (ISiriusSessionService)servReg.getService((Object)"org.eclipse.papyrus.sirius.editor.sirius.ISiriusSessionService");
        }
        catch (ServiceException e) {
            Activator.log.error("Unexpected Error", (Throwable)e);
            return null;
        }
    }

    protected void doExecute() {
        ISiriusSessionService sessionService = this.getSiriusSessionService();
        if (sessionService == null || this.prototype == null) {
            return;
        }
        DiagramDescription diagramDescription = sessionService.getSiriusDiagramDescriptionFromPapyrusPrototype(this.prototype, this.semanticContext);
        if (diagramDescription == null) {
            return;
        }
        Session session = sessionService.getSiriusSession();
        if (DialectManager.INSTANCE.canCreate(this.semanticContext, (RepresentationDescription)diagramDescription)) {
            sessionService.attachSession(this.semanticContext);
            DSemanticDiagram diagram = (DSemanticDiagram)DialectManager.INSTANCE.createRepresentation(this.editorViewName, this.semanticContext, (RepresentationDescription)diagramDescription, session, (IProgressMonitor)new NullProgressMonitor());
            DAnnotation annotation = DescriptionFactory.eINSTANCE.createDAnnotation();
            annotation.setSource("Papyrus-SiriusDiagram");
            annotation.getDetails().put((Object)"Papyrus-SiriusDiagram-ImplementationId", (Object)this.prototype.getId());
            diagram.getEAnnotations().add((Object)annotation);
            this.attachToResource(this.semanticContext, diagram);
            if (diagram.eResource() != null) {
                this.createdEditorView = diagram;
            }
            if (this.openAfterCreation && this.createdEditorView != null) {
                this.openEditor((DSemanticDiagram)this.createdEditorView);
            }
        }
    }
}

