/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.sequence.util;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.gef.EditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.ConnectionEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.DiagramEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.DiagramRootEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.GraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.papyrus.infra.gmfdiag.common.selection.SelectSeveralLinksEditPartTracker;
import org.eclipse.papyrus.uml.diagram.sequence.edit.parts.AbstractMessageEditPart;
import org.eclipse.papyrus.uml.diagram.sequence.edit.parts.MessageCreateEditPart;
import org.eclipse.papyrus.uml.diagram.sequence.part.UMLDiagramEditorPlugin;
import org.eclipse.papyrus.uml.diagram.sequence.util.LogOptions;

public class SelectMessagesEditPartTracker
extends SelectSeveralLinksEditPartTracker {
    protected int MinDistancetop = Integer.MAX_VALUE;
    protected int MinDistancebottom = Integer.MAX_VALUE;
    protected Dimension delta = null;
    private boolean allowReorder;
    private boolean isOneMessageDeleteSelected;

    public SelectMessagesEditPartTracker(org.eclipse.gef.ConnectionEditPart owner) {
        super(owner);
        this.allowReorder = ((AbstractMessageEditPart)owner).mustReorderMessage();
        this.isOneMessageDeleteSelected = false;
    }

    public void activate() {
        super.activate();
    }

    protected boolean handleButtonDown(int button) {
        this.MinDistancetop = Integer.MAX_VALUE;
        this.MinDistancebottom = Integer.MAX_VALUE;
        this.isOneMessageDeleteSelected = false;
        ArrayList<GraphicalEditPart> nodeEditPart = new ArrayList<GraphicalEditPart>();
        List selectedEditparts = this.getOperationSet();
        int i = 0;
        while (i < selectedEditparts.size()) {
            Object currentEditPart = selectedEditparts.get(i);
            if (currentEditPart instanceof ConnectionEditPart) {
                ConnectionEditPart currentConnectionEdiPart = (ConnectionEditPart)currentEditPart;
                nodeEditPart.add((GraphicalEditPart)currentConnectionEdiPart.getSource());
                if (currentConnectionEdiPart instanceof MessageCreateEditPart) {
                    this.isOneMessageDeleteSelected = true;
                }
            }
            ++i;
        }
        ArrayList<AbstractMessageEditPart> messageEditPartList = new ArrayList<AbstractMessageEditPart>();
        for (GraphicalEditPart anodeEditPart : nodeEditPart) {
            for (Object connection : anodeEditPart.getSourceConnections()) {
                if (!(connection instanceof AbstractMessageEditPart) || selectedEditparts.contains(connection)) continue;
                messageEditPartList.add((AbstractMessageEditPart)connection);
            }
            for (Object connection : anodeEditPart.getTargetConnections()) {
                if (selectedEditparts.contains(connection) || !(connection instanceof AbstractMessageEditPart)) continue;
                messageEditPartList.add((AbstractMessageEditPart)connection);
            }
        }
        for (AbstractMessageEditPart abstractMessageEditPart : messageEditPartList) {
            Point currentConnectionPosition = abstractMessageEditPart.getConnectionFigure().getPoints().getFirstPoint().getCopy();
            for (Object selectedEditPart : selectedEditparts) {
                if (!(selectedEditPart instanceof AbstractMessageEditPart)) continue;
                AbstractMessageEditPart currentSelectedMessage = (AbstractMessageEditPart)selectedEditPart;
                Point currentSelectedConnectionPosition = currentSelectedMessage.getConnectionFigure().getPoints().getFirstPoint().getCopy();
                if (currentConnectionPosition.y < currentSelectedConnectionPosition.y) {
                    if (this.MinDistancetop <= currentSelectedConnectionPosition.y - currentConnectionPosition.y) continue;
                    this.MinDistancetop = currentSelectedConnectionPosition.y - currentConnectionPosition.y;
                    continue;
                }
                if (!this.isOneMessageDeleteSelected || this.MinDistancebottom <= currentConnectionPosition.y - currentSelectedConnectionPosition.y) continue;
                this.MinDistancebottom = currentConnectionPosition.y - currentSelectedConnectionPosition.y;
            }
        }
        return super.handleButtonDown(button);
    }

    protected void updateSourceRequest() {
        if (this.isOneMessageDeleteSelected) {
            if (this.allowReorder) {
                Dimension computedDelta = this.getLocation().getDifference(this.getStartLocation());
                this.delta = null;
                if (computedDelta.height < 0) {
                    UMLDiagramEditorPlugin.log.trace(LogOptions.SEQUENCE_DEBUG_UTIL, "Move " + computedDelta.height + " MinDistancetop" + this.MinDistancetop);
                    if (this.MinDistancetop + computedDelta.height < 0) {
                        computedDelta.height = -this.MinDistancetop;
                        this.delta = computedDelta.getCopy();
                    }
                } else {
                    UMLDiagramEditorPlugin.log.trace(LogOptions.SEQUENCE_DEBUG_UTIL, "Move " + computedDelta.height + " MinDistancebottom" + this.MinDistancebottom);
                    if (this.MinDistancebottom - computedDelta.height - 10 < 0) {
                        computedDelta.height = this.MinDistancebottom - 10;
                        this.delta = computedDelta.getCopy();
                    }
                }
            }
        } else if (!this.allowReorder) {
            Dimension computedDelta = this.getLocation().getDifference(this.getStartLocation());
            this.delta = null;
            if (computedDelta.height < 0) {
                UMLDiagramEditorPlugin.log.trace(LogOptions.SEQUENCE_DEBUG_UTIL, "Move " + computedDelta.height + " MinDistancetop" + this.MinDistancetop);
                if (this.MinDistancetop + computedDelta.height < 0) {
                    computedDelta.height = -this.MinDistancetop;
                    this.delta = computedDelta.getCopy();
                }
            } else {
                UMLDiagramEditorPlugin.log.trace(LogOptions.SEQUENCE_DEBUG_UTIL, "Move " + computedDelta.height + " MinDistancebottom" + this.MinDistancebottom);
                if (this.MinDistancebottom - computedDelta.height - 10 < 0) {
                    computedDelta.height = this.MinDistancebottom - 10;
                    this.delta = computedDelta.getCopy();
                }
            }
        }
        super.updateSourceRequest();
    }

    protected Dimension getDragMoveDelta() {
        if (this.delta == null) {
            return this.getLocation().getDifference(this.getStartLocation());
        }
        return this.delta;
    }

    public DiagramEditPart getDiagramEditPart(EditPart editPart) {
        while (editPart instanceof IGraphicalEditPart) {
            if (editPart instanceof DiagramEditPart) {
                return (DiagramEditPart)editPart;
            }
            editPart = editPart.getParent();
        }
        if (editPart instanceof DiagramRootEditPart) {
            return (DiagramEditPart)((DiagramRootEditPart)editPart).getChildren().get(0);
        }
        return null;
    }
}

