/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.properties.widgets;

import org.eclipse.core.databinding.observable.ChangeEvent;
import org.eclipse.core.databinding.observable.IChangeListener;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.papyrus.infra.emf.utils.HistoryUtil;
import org.eclipse.papyrus.infra.emf.utils.ServiceUtilsForEObject;
import org.eclipse.papyrus.infra.properties.ui.providers.CreateInFeatureContentProvider;
import org.eclipse.papyrus.infra.properties.ui.providers.FeatureContentProvider;
import org.eclipse.papyrus.infra.services.labelprovider.service.LabelProviderService;
import org.eclipse.papyrus.infra.ui.emf.providers.EMFGraphicalContentProvider;
import org.eclipse.papyrus.infra.ui.emf.providers.EMFLabelProvider;
import org.eclipse.papyrus.infra.ui.emf.utils.ProviderHelper;
import org.eclipse.papyrus.infra.widgets.creation.ReferenceValueFactory;
import org.eclipse.papyrus.infra.widgets.providers.IStaticContentProvider;
import org.eclipse.papyrus.uml.profile.tree.objects.AppliedStereotypePropertyTreeObject;
import org.eclipse.papyrus.uml.properties.creation.UMLPropertyEditorFactory;
import org.eclipse.papyrus.uml.properties.profile.ui.compositeforview.AppliedStereotypeCompositeWithView;
import org.eclipse.papyrus.uml.properties.widgets.StereotypeEStructuralFeatureEditor;
import org.eclipse.papyrus.uml.tools.providers.UMLContainerContentProvider;
import org.eclipse.papyrus.uml.tools.providers.UMLContentProvider;
import org.eclipse.papyrus.uml.tools.providers.UMLFilteredLabelProvider;
import org.eclipse.papyrus.uml.tools.providers.UMLLabelProvider;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Stereotype;

public class StereotypePropertyEditor
implements ISelectionChangedListener,
IChangeListener {
    protected StereotypeEStructuralFeatureEditor eStructuralFeatureEditor;
    protected AppliedStereotypeCompositeWithView stereotypeComposite;
    protected int style = 0;

    public StereotypePropertyEditor(Composite parent, int style, AppliedStereotypeCompositeWithView stereotypeComposite) {
        this.stereotypeComposite = stereotypeComposite;
        this.eStructuralFeatureEditor = new StereotypeEStructuralFeatureEditor(parent, style);
        this.eStructuralFeatureEditor.setChangeListener(this);
    }

    public void selectionChanged(SelectionChangedEvent event) {
        if (event != null) {
            IStructuredSelection structSelection = (IStructuredSelection)event.getSelection();
            Object selection = structSelection.getFirstElement();
            if (selection instanceof AppliedStereotypePropertyTreeObject) {
                UMLLabelProvider labelProvider;
                AppliedStereotypePropertyTreeObject pTO = (AppliedStereotypePropertyTreeObject)selection;
                EObject stereotypeApplication = pTO.getStereotypeApplication();
                Element owner = pTO.getElement();
                EStructuralFeature feature = pTO.getFeature();
                Stereotype stereotype = pTO.getStereotype();
                try {
                    labelProvider = ((LabelProviderService)ServiceUtilsForEObject.getInstance().getService(LabelProviderService.class, (Object)stereotypeApplication)).getLabelProvider();
                }
                catch (Exception ex) {
                    labelProvider = new UMLLabelProvider();
                }
                this.eStructuralFeatureEditor.setStereotype(stereotype);
                this.eStructuralFeatureEditor.setProviders((IStaticContentProvider)new UMLContentProvider(stereotypeApplication, feature, stereotype), (ILabelProvider)labelProvider);
                if (feature instanceof EReference) {
                    this.eStructuralFeatureEditor.setValueFactory((ReferenceValueFactory)this.getUMLPropertyEditorFactory(stereotypeApplication, (EReference)feature));
                }
                this.eStructuralFeatureEditor.setFeatureToEdit(pTO.getProperty().getName(), feature, owner, stereotypeApplication);
            } else {
                this.eStructuralFeatureEditor.setFeatureToEdit(null, null, null, null);
            }
        }
    }

    protected UMLPropertyEditorFactory getUMLPropertyEditorFactory(EObject stereotypeApplication, EReference reference) {
        UMLPropertyEditorFactory factory = new UMLPropertyEditorFactory(reference);
        EClass type = reference.getEReferenceType();
        factory.setContainerLabelProvider((ILabelProvider)new UMLFilteredLabelProvider());
        factory.setReferenceLabelProvider((ILabelProvider)new EMFLabelProvider());
        UMLContainerContentProvider contentProvider = new UMLContainerContentProvider(stereotypeApplication, reference);
        EMFGraphicalContentProvider provider = ProviderHelper.encapsulateProvider((ITreeContentProvider)contentProvider, (ResourceSet)stereotypeApplication.eResource().getResourceSet(), (String)HistoryUtil.getHistoryID((EObject)stereotypeApplication, (EStructuralFeature)reference, (String)"container"));
        factory.setContainerContentProvider((IStaticContentProvider)provider);
        factory.setReferenceContentProvider((CreateInFeatureContentProvider)new FeatureContentProvider(type));
        return factory;
    }

    public void setLayoutData(GridData data) {
        this.eStructuralFeatureEditor.setLayoutData(data);
    }

    public void handleChange(ChangeEvent event) {
        if (!this.stereotypeComposite.isDisposed()) {
            this.stereotypeComposite.refreshTreeViewer();
        }
    }
}

