/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.views.modelexplorer.handler;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExecutableExtension;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.papyrus.infra.core.sasheditor.di.contentprovider.IOpenable;
import org.eclipse.papyrus.infra.core.sashwindows.di.service.IPageManager;
import org.eclipse.papyrus.infra.ui.command.AbstractPapyrusHandler;
import org.eclipse.papyrus.infra.viewpoints.policy.ViewPrototype;

public class OpenHandler
extends AbstractPapyrusHandler
implements IExecutableExtension {
    private static final String IS_DUPLICATE_VIEW_ALLOWED_PARAMETER = "isDuplicateViewAllowed";
    private boolean isDuplicateViewAllowed = false;

    public Object execute(ExecutionEvent event) throws ExecutionException {
        IPageManager pageManager = this.getPageManager(event);
        if (pageManager == null) {
            return null;
        }
        List selectedEObjects = this.getCurrentSelectionAdaptedToType(event, EObject.class);
        if (selectedEObjects == null || selectedEObjects.isEmpty()) {
            return null;
        }
        Collection<IOpenable> openables = this.getIOpenables(selectedEObjects);
        if (openables.isEmpty()) {
            return null;
        }
        LinkedList<EObject> pagesToOpen = new LinkedList<EObject>();
        LinkedList<EObject> pagesToSelect = new LinkedList<EObject>();
        for (IOpenable selected : openables) {
            EObject realObjectToOpen;
            if (!(selected.getPageIdentifier() instanceof EObject) || !this.canOpenByPolicy(realObjectToOpen = (EObject)selected.getPageIdentifier())) continue;
            if (!pageManager.isOpen((Object)realObjectToOpen) || this.isDuplicateViewAllowed) {
                pagesToOpen.add(realObjectToOpen);
                continue;
            }
            pagesToSelect.add(realObjectToOpen);
        }
        if (!pagesToOpen.isEmpty()) {
            for (EObject page : pagesToOpen) {
                pageManager.openPage((Object)page);
            }
        }
        for (EObject page : pagesToSelect) {
            pageManager.selectPage((Object)page);
        }
        return null;
    }

    private Collection<IOpenable> getIOpenables(Collection<EObject> selectedEObject) {
        Iterator<EObject> iter = selectedEObject.iterator();
        ArrayList<IOpenable> openables = new ArrayList<IOpenable>();
        while (iter.hasNext()) {
            IOpenable openable = (IOpenable)Platform.getAdapterManager().getAdapter((Object)iter.next(), IOpenable.class);
            if (openable == null) continue;
            openables.add(openable);
        }
        return openables;
    }

    private boolean canOpenByPolicy(EObject selection) {
        ViewPrototype proto = ViewPrototype.get((EObject)selection);
        return proto != ViewPrototype.UNAVAILABLE_VIEW;
    }

    public void setInitializationData(IConfigurationElement config, String propertyName, Object data) throws CoreException {
        if (!(data instanceof Hashtable)) {
            return;
        }
        Hashtable map = (Hashtable)data;
        Object value = map.get(IS_DUPLICATE_VIEW_ALLOWED_PARAMETER);
        if (value != null) {
            this.isDuplicateViewAllowed = Boolean.parseBoolean(value.toString());
        }
    }
}

