/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.activity.edit.part;

import java.util.List;
import org.eclipse.draw2d.AbstractPointListShape;
import org.eclipse.draw2d.PolylineShape;
import org.eclipse.gef.ConnectionEditPart;
import org.eclipse.gmf.runtime.diagram.ui.figures.IBorderItemLocator;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.uml.diagram.activity.edit.parts.ControlFlowEditPart;
import org.eclipse.papyrus.uml.diagram.activity.edit.parts.ObjectFlowEditPart;
import org.eclipse.papyrus.uml.diagram.activity.figures.PinFigure;
import org.eclipse.papyrus.uml.diagram.activity.helper.ActivityFigureDrawer;
import org.eclipse.papyrus.uml.diagram.common.editparts.BorderedBorderItemEditPart;

public abstract class AbstractPinEditPart
extends BorderedBorderItemEditPart {
    public AbstractPinEditPart(View view) {
        super(view);
    }

    protected void fireTargetConnectionAdded(ConnectionEditPart connection, int index) {
        super.fireTargetConnectionAdded(connection, index);
        this.undrawPinArrow(connection);
    }

    protected void fireSourceConnectionAdded(ConnectionEditPart connection, int index) {
        super.fireSourceConnectionAdded(connection, index);
        this.undrawPinArrow(connection);
    }

    private void undrawPinArrow(ConnectionEditPart connection) {
        if (this.isConnectionSupported(connection)) {
            PinFigure pinFigure = this.getPrimaryShape();
            PolylineShape arrow = pinFigure.getOptionalArrowFigure();
            ActivityFigureDrawer.undrawFigure((AbstractPointListShape)arrow);
        }
    }

    private void drawPinArrow() {
        PinFigure pinFigure = this.getPrimaryShape();
        PolylineShape arrow = pinFigure.getOptionalArrowFigure();
        int side = this.getBorderItemLocator().getCurrentSideOfParent();
        int direction = ActivityFigureDrawer.getOppositeDirection(side);
        ActivityFigureDrawer.redrawPinArrow((AbstractPointListShape)arrow, this.getMapMode(), this.getSize(), direction);
    }

    private void redrawPinArrow(List<?> connections) {
        this.redrawPinArrow(null, connections);
    }

    private void redrawPinArrow(ConnectionEditPart connection, List<?> connections) {
        if (this.isHasActiveEdge(connection, connections)) {
            this.undrawPinArrow(connection);
            return;
        }
        this.drawPinArrow();
    }

    private boolean isHasActiveEdge(ConnectionEditPart connection, List<?> connections) {
        if (connection == null && (connections == null || connections.isEmpty())) {
            return false;
        }
        if (connection == null) {
            for (Object next : connections) {
                if (!this.isConnectionSupported((ConnectionEditPart)next)) continue;
                return true;
            }
            return false;
        }
        for (Object next : connections) {
            if (connection.equals(next) || !this.isConnectionSupported((ConnectionEditPart)next)) continue;
            return true;
        }
        return false;
    }

    private boolean isConnectionSupported(ConnectionEditPart connection) {
        return connection instanceof ObjectFlowEditPart || connection instanceof ControlFlowEditPart;
    }

    protected void fireRemovingTargetConnection(ConnectionEditPart connection, int index) {
        super.fireRemovingTargetConnection(connection, index);
        this.redrawPinArrow(connection, this.getTargetConnections());
    }

    protected void fireRemovingSourceConnection(ConnectionEditPart connection, int index) {
        super.fireRemovingTargetConnection(connection, index);
        this.redrawPinArrow(connection, this.getSourceConnections());
    }

    public abstract PinFigure getPrimaryShape();

    public void activate() {
        super.activate();
        this.redrawPinArrow(this.getTargetConnections().isEmpty() ? this.getSourceConnections() : this.getTargetConnections());
    }

    public void refreshBounds() {
        super.refreshBounds();
        IBorderItemLocator locator = this.getBorderItemLocator();
        if (locator != null) {
            locator.relocate(this.getFigure());
        }
    }
}

