/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.constraints.constraints;

import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.papyrus.infra.constraints.Activator;
import org.eclipse.papyrus.infra.constraints.SimpleConstraint;
import org.eclipse.papyrus.infra.constraints.constraints.AbstractConstraint;
import org.eclipse.papyrus.infra.constraints.constraints.Constraint;
import org.eclipse.papyrus.infra.constraints.constraints.JavaQuery;
import org.eclipse.papyrus.infra.tools.util.ClassLoaderHelper;

public class JavaQueryConstraint
extends AbstractConstraint {
    public static final String QUERY_CLASS_NAME_PROPERTY = "className";
    private JavaQuery query = new JavaQuery.FalseQuery();

    @Override
    protected void setDescriptor(SimpleConstraint descriptor) {
        String queryClassName = this.getValue(QUERY_CLASS_NAME_PROPERTY);
        this.query = (JavaQuery)ClassLoaderHelper.newInstance((String)queryClassName, JavaQuery.class, (URI)EcoreUtil.getURI((EObject)descriptor));
        if (this.query == null) {
            Activator.log.warn("Cannot load the JavaQuery for this constraint : " + descriptor.getName());
        }
    }

    @Override
    public boolean match(Object selection) {
        return this.query != null && this.query.match(selection);
    }

    @Override
    protected boolean equivalent(Constraint constraint) {
        if (constraint instanceof JavaQueryConstraint) {
            return ((JavaQueryConstraint)constraint).query.getClass().equals(this.query.getClass());
        }
        return false;
    }
}

