/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.common.groups.commands;

import java.util.List;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.transaction.Transaction;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.requests.ChangeBoundsRequest;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.requests.CreateViewAndElementRequest;
import org.eclipse.gmf.runtime.diagram.ui.requests.CreateViewRequest;
import org.eclipse.gmf.runtime.emf.commands.core.command.AbstractTransactionalCommand;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.infra.gmfdiag.common.utils.DiagramEditPartsUtil;
import org.eclipse.papyrus.uml.diagram.common.groups.Messages;
import org.eclipse.papyrus.uml.diagram.common.groups.core.PendingGroupNotificationsManager;
import org.eclipse.papyrus.uml.diagram.common.groups.core.ui.ChooseParentNotificationConfigurator;
import org.eclipse.papyrus.uml.diagram.common.groups.core.ui.NotificationConfigurator;

public class ChooseParentNotificationCommand
extends AbstractTransactionalCommand {
    public static final boolean GRAPHICAL_MODE = true;
    public static final boolean MODEL_MODE = false;
    private boolean mode;
    private List<IGraphicalEditPart> parents;
    private IGraphicalEditPart childEditPart;
    private Request request;
    private IGraphicalEditPart host;
    private PendingGroupNotificationsManager manager;
    private ChooseParentNotificationConfigurator notifConfigurator;

    public ChooseParentNotificationCommand(TransactionalEditingDomain domain, String label, List<IGraphicalEditPart> parents, Request request, Boolean mode, IGraphicalEditPart getHost) {
        super(domain, label, null);
        this.parents = parents;
        this.request = request;
        this.mode = mode;
        this.host = getHost;
        this.manager = PendingGroupNotificationsManager.getInstanceForDiagram(DiagramEditPartsUtil.getDiagramEditPart((EditPart)getHost));
    }

    protected CommandResult doExecuteWithResult(IProgressMonitor arg0, IAdaptable arg1) throws ExecutionException {
        if (this.parents != null && this.getEditPartFromDescriptor().booleanValue()) {
            ChooseParentNotificationConfigurator configurator = null;
            if (this.mode) {
                String label = new String(Messages.ChooseParentNotificationCommand_ChooseGraphicalParent);
                configurator = new ChooseParentNotificationConfigurator(this.parents, this.childEditPart, this.mode, this.host, this.manager, NotificationConfigurator.Mode.QUESTION_MODE, label);
            } else {
                String label = new String(Messages.ChooseParentNotificationCommand_ChooseGraphicalParent);
                configurator = new ChooseParentNotificationConfigurator(this.parents, this.childEditPart, this.mode, this.host, this.manager, NotificationConfigurator.Mode.WARNING_MODE, label);
            }
            if (configurator != null) {
                this.notifConfigurator = configurator;
                configurator.runConfigurator();
                return CommandResult.newOKCommandResult();
            }
        }
        return CommandResult.newErrorCommandResult((String)"The notification failed to run because no list of avaiable parent was set up");
    }

    private Boolean getEditPartFromDescriptor() {
        Object editPart;
        ChangeBoundsRequest changeBoundsRequest;
        if (this.request instanceof CreateViewAndElementRequest) {
            CreateViewAndElementRequest createRequest = (CreateViewAndElementRequest)this.request;
            for (CreateViewRequest.ViewDescriptor descriptor : createRequest.getViewDescriptors()) {
                Object childEditPartAux;
                Object view = descriptor.getAdapter(View.class);
                if (!(view instanceof View)) continue;
                View childView = (View)view;
                if (this.parents.isEmpty() || !((childEditPartAux = this.parents.get(0).getViewer().getEditPartRegistry().get(childView)) instanceof IGraphicalEditPart)) continue;
                this.childEditPart = (IGraphicalEditPart)childEditPartAux;
            }
        } else if (this.request instanceof ChangeBoundsRequest && !(changeBoundsRequest = (ChangeBoundsRequest)this.request).getEditParts().isEmpty() && (editPart = changeBoundsRequest.getEditParts().get(0)) instanceof IGraphicalEditPart) {
            Object childEditPartAux;
            IGraphicalEditPart _childEditPart = (IGraphicalEditPart)editPart;
            View childView = _childEditPart.getNotationView();
            if (!this.parents.isEmpty() && (childEditPartAux = this.parents.get(0).getViewer().getEditPartRegistry().get(childView)) instanceof IGraphicalEditPart) {
                this.childEditPart = (IGraphicalEditPart)childEditPartAux;
            }
        }
        if (this.childEditPart != null) {
            return true;
        }
        return false;
    }

    public void setListOfParents(List<IGraphicalEditPart> parents) {
        this.parents = parents;
    }

    public void setMode(boolean mode) {
        this.mode = mode;
    }

    protected void didUndo(Transaction tx) {
        if (this.notifConfigurator != null) {
            this.notifConfigurator.closeNotification();
        }
        super.didUndo(tx);
    }
}

