/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.nattable.filter.validator;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;
import org.eclipse.nebula.widgets.nattable.config.IConfigRegistry;
import org.eclipse.nebula.widgets.nattable.data.validate.IDataValidator;
import org.eclipse.nebula.widgets.nattable.layer.cell.ILayerCell;
import org.eclipse.papyrus.infra.nattable.utils.CellHelper;

public class EnumFilterDataValidator
implements IDataValidator {
    final List<Enumerator> authorizedLiterals;

    public EnumFilterDataValidator(List<Enumerator> authorizedLiterals) {
        this.authorizedLiterals = authorizedLiterals;
    }

    public boolean validate(int columnIndex, int rowIndex, Object newValue) {
        return false;
    }

    public boolean validate(ILayerCell cell, IConfigRegistry configRegistry, Object newValue) {
        if (newValue == null) {
            return true;
        }
        if (newValue instanceof Enumerator && this.authorizedLiterals.contains(newValue)) {
            return true;
        }
        if (newValue instanceof String && newValue.equals(CellHelper.getUnsupportedCellContentsText())) {
            return true;
        }
        if (newValue instanceof Collection) {
            boolean result = true;
            Iterator values = ((Collection)newValue).iterator();
            while (values.hasNext() && result) {
                Object value = values.next();
                result = this.validate(cell, configRegistry, value);
            }
            return result;
        }
        return false;
    }
}

