/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.sirius.properties.uml.services;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.ECrossReferenceAdapter;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.papyrus.sirius.properties.common.utils.ContainerUtil;
import org.eclipse.papyrus.sirius.properties.uml.Activator;
import org.eclipse.papyrus.sirius.properties.uml.services.EditableChecker;
import org.eclipse.papyrus.uml.domain.services.IEditableChecker;
import org.eclipse.papyrus.uml.domain.services.create.CreationStatus;
import org.eclipse.papyrus.uml.domain.services.create.ElementCreator;
import org.eclipse.papyrus.uml.domain.services.destroy.DestroyerStatus;
import org.eclipse.papyrus.uml.domain.services.destroy.ElementDestroyer;
import org.eclipse.papyrus.uml.domain.services.modify.ElementFeatureModifier;
import org.eclipse.papyrus.uml.domain.services.status.State;

public class PropertiesCrudServices {
    public boolean delete(Object selectedObject, EObject target, String refName) {
        boolean isDeleted = false;
        if (selectedObject instanceof EObject) {
            EObject objectToRemove = (EObject)selectedObject;
            ECrossReferenceAdapter crossReferenceAdapter = ECrossReferenceAdapter.getCrossReferenceAdapter((Notifier)objectToRemove);
            EReference eReference = this.getReference(target, refName);
            EditableChecker checker = new EditableChecker();
            if (eReference == null || eReference.isContainment()) {
                ElementDestroyer destroyer = ElementDestroyer.buildDefault((ECrossReferenceAdapter)crossReferenceAdapter, (IEditableChecker)checker);
                DestroyerStatus destroyerStatus = destroyer.destroy(objectToRemove);
                if (destroyerStatus.getState() == State.FAILED) {
                    ComposedAdapterFactory composedAdapterFactory = new ComposedAdapterFactory(ComposedAdapterFactory.Descriptor.Registry.INSTANCE);
                    AdapterFactoryLabelProvider labelProvider = new AdapterFactoryLabelProvider((AdapterFactory)composedAdapterFactory);
                    Activator.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.papyrus.sirius.properties.uml", labelProvider.getText((Object)objectToRemove) + " cannot be deleted."));
                } else {
                    isDeleted = true;
                }
            } else {
                ElementFeatureModifier modifier = new ElementFeatureModifier(crossReferenceAdapter, (IEditableChecker)checker);
                org.eclipse.papyrus.uml.domain.services.status.Status removeValueStatus = null;
                removeValueStatus = !eReference.isMany() ? modifier.setValue(target, refName, null) : modifier.removeValue(target, refName, (Object)objectToRemove);
                if (State.DONE == removeValueStatus.getState()) {
                    isDeleted = true;
                } else {
                    Activator.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.papyrus.sirius.properties.uml", removeValueStatus.getMessage()));
                }
            }
        }
        return isDeleted;
    }

    public EObject create(EObject target, String typeName, String refName) {
        EObject createdElement = null;
        if (this.getReference(target, refName) != null) {
            ECrossReferenceAdapter crossReferenceAdapter = ECrossReferenceAdapter.getCrossReferenceAdapter((Notifier)target);
            EditableChecker checker = new EditableChecker();
            ElementCreator ec = ElementCreator.buildDefault((ECrossReferenceAdapter)crossReferenceAdapter, (IEditableChecker)checker);
            CreationStatus status = ec.create(target, typeName, refName);
            createdElement = status.getElement();
        }
        return createdElement;
    }

    public boolean updateReference(EObject target, Object objectToSet, String refName) {
        EReference eReference;
        boolean isUpdated = false;
        if (target != null && (eReference = this.getReference(target, refName)) != null && !eReference.isContainment()) {
            if (objectToSet instanceof List && eReference.isMany()) {
                isUpdated = this.set(target, refName, objectToSet);
            } else if (objectToSet instanceof EObject) {
                EObject eObject = (EObject)objectToSet;
                ECrossReferenceAdapter crossReferenceAdapter = ECrossReferenceAdapter.getCrossReferenceAdapter((Notifier)eObject);
                ElementFeatureModifier modifier = new ElementFeatureModifier(crossReferenceAdapter, (IEditableChecker)new EditableChecker());
                isUpdated = modifier.addValue(target, refName, (Object)eObject).getState() == State.DONE;
            }
        }
        return isUpdated;
    }

    public boolean set(EObject target, String refName, Object valueToSet) {
        boolean isSetted = false;
        EReference eReference = this.getReference(target, refName);
        if (target != null) {
            isSetted = eReference != null && valueToSet instanceof List && eReference.isMany() ? this.setNewList(target, (List)valueToSet, refName, new EditableChecker()) : this.setUnary(target, refName, valueToSet);
        }
        return isSetted;
    }

    private boolean setNewList(EObject target, List<EObject> listToSet, String refName, EditableChecker checker) {
        boolean isSetted = true;
        ECrossReferenceAdapter crossReferenceAdapter = new ECrossReferenceAdapter();
        ElementFeatureModifier modifier = new ElementFeatureModifier(crossReferenceAdapter, (IEditableChecker)checker);
        EReference eReference = this.getReference(target, refName);
        Object ref = target.eGet((EStructuralFeature)eReference);
        ArrayList oldRef = new ArrayList();
        oldRef.addAll((List)ref);
        for (EObject o : oldRef) {
            if (listToSet.contains(o)) continue;
            modifier.removeValue(target, refName, (Object)o);
        }
        ((List)ref).clear();
        for (EObject o : listToSet) {
            if (oldRef.contains(o)) {
                ContainerUtil.addToContainer((EObject)target, (EStructuralFeature)eReference, (Object)o);
                continue;
            }
            boolean bl = isSetted = isSetted && modifier.addValue(target, refName, (Object)o).getState() == State.DONE;
        }
        return isSetted;
    }

    private boolean setUnary(EObject elementToUpdate, String featureName, Object newValue) {
        ECrossReferenceAdapter crossReferenceAdapter = ECrossReferenceAdapter.getCrossReferenceAdapter((Notifier)elementToUpdate);
        ElementFeatureModifier elementFeatureModifier = new ElementFeatureModifier(crossReferenceAdapter, (IEditableChecker)new EditableChecker());
        return elementFeatureModifier.setValue(elementToUpdate, featureName, newValue).getState() == State.DONE;
    }

    private EReference getReference(EObject target, String refName) {
        EStructuralFeature eStructuralFeature;
        EReference eReference = null;
        if (target != null && refName != null && !refName.isBlank() && (eStructuralFeature = target.eClass().getEStructuralFeature(refName)) instanceof EReference) {
            eReference = (EReference)eStructuralFeature;
        }
        return eReference;
    }
}

