/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.emf.internal.resource;

import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.Sets;
import java.util.Iterator;
import java.util.Set;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.papyrus.infra.emf.internal.resource.StopParsing;
import org.eclipse.papyrus.infra.tools.util.TypeUtils;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class CrossReferenceIndexHandler
extends DefaultHandler {
    private final URI fileURI;
    private final boolean annotationOnly;
    private Set<String> crossReferences = Sets.newHashSet();
    private XMIElement shard;
    private Set<String> subunits = Sets.newHashSet();
    private Set<String> parents = Sets.newHashSet();
    private BiMap<String, String> namespacePrefixes = HashBiMap.create();
    private String xmiContainerQName;
    private String xmiTypeQName;
    private String eAnnotationSourceName;
    private String eAnnotationReferencesName;
    private XMIElement top;

    public CrossReferenceIndexHandler(URI fileURI) {
        this(fileURI, false);
    }

    public CrossReferenceIndexHandler(URI fileURI, boolean annotationOnly) {
        this.fileURI = fileURI;
        this.annotationOnly = annotationOnly;
    }

    public URI getFileURI() {
        return this.fileURI;
    }

    public Set<String> getCrossReferences() {
        return this.crossReferences;
    }

    public boolean isShard() {
        return this.shard != null;
    }

    public Set<String> getSubunits() {
        return this.subunits;
    }

    public Set<String> getParents() {
        return this.parents;
    }

    @Override
    public void startPrefixMapping(String prefix, String uri) throws SAXException {
        this.namespacePrefixes.put((Object)prefix, (Object)uri);
        if ("xmi".equals(prefix)) {
            this.xmiTypeQName = this.qname(prefix, "type");
            this.xmiContainerQName = this.qname(prefix, "XMI");
            this.eAnnotationSourceName = "source";
            this.eAnnotationReferencesName = "references";
        }
    }

    protected final String qname(String prefix, String name) {
        StringBuilder buf = new StringBuilder(prefix.length() + name.length() + 1);
        return buf.append(prefix).append(':').append(name).toString();
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        this.push(qName, attributes);
        this.handleXMIElement(this.top, attributes);
    }

    protected final void push(String qName, Attributes attributes) {
        this.top = new XMIElement(qName, attributes);
    }

    protected final XMIElement pop() {
        XMIElement result = this.top;
        if (this.top != null) {
            this.top = this.top.parent;
        }
        return result;
    }

    protected void handleXMIElement(XMIElement element, Attributes attributes) throws SAXException {
        String source;
        if (element.getHREF() != null) {
            URI xref = element.getHREF().trimFragment();
            if (!xref.equals(this.fileURI)) {
                if (element.isContainment()) {
                    this.subunits.add(xref.toString());
                } else if (this.isShard() && element.parent == this.shard && element.isRole(this.eAnnotationReferencesName)) {
                    this.parents.add(xref.toString());
                } else {
                    this.crossReferences.add(xref.toString());
                }
            }
        } else if (element.isAnnotation() && "http://www.eclipse.org/papyrus/2016/resource/shard".equals(source = attributes.getValue(this.eAnnotationSourceName))) {
            this.shard = element;
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        XMIElement ended = this.pop();
        if (this.annotationOnly && this.isShard() && ended == this.shard) {
            throw new StopParsing();
        }
    }

    protected final class XMIElement {
        final XMIElement parent;
        final String type;
        final String role;
        final String href;
        private EClass eclass;

        XMIElement(String qName, Attributes attributes) {
            this.parent = CrossReferenceIndexHandler.this.top;
            if (this.parent == null || this.parent.isXMIContainer()) {
                this.role = null;
                this.type = qName;
            } else {
                this.role = qName;
                this.type = attributes.getValue(CrossReferenceIndexHandler.this.xmiTypeQName);
            }
            this.href = attributes.getValue("href");
        }

        boolean isXMIContainer() {
            return this.role == null && (this.type == null || this.type.equals(CrossReferenceIndexHandler.this.xmiContainerQName));
        }

        boolean isRoot() {
            return this.parent == null || this.parent.isXMIContainer();
        }

        boolean isRole(String roleName) {
            return roleName.equals(this.role);
        }

        URI getHREF() {
            return Strings.isNullOrEmpty((String)this.href) ? null : URI.createURI((String)this.href).resolve(CrossReferenceIndexHandler.this.fileURI);
        }

        boolean isAnnotation() {
            return this.getEClass() == EcorePackage.Literals.EANNOTATION;
        }

        boolean isContainment() {
            boolean result = false;
            if (!this.isRoot()) {
                EStructuralFeature feature = this.parent.getFeature(this.role);
                result = feature instanceof EReference && ((EReference)feature).isContainment();
            }
            return result;
        }

        EStructuralFeature getFeature(String role) {
            EClass eclass = this.getEClass();
            return eclass == null ? null : eclass.getEStructuralFeature(role);
        }

        EClass getEClass() {
            if (this.eclass == null) {
                EReference ref;
                EClass parentEClass;
                if (this.type != null) {
                    EPackage epackage;
                    Iterator parts = Splitter.on((char)':').split((CharSequence)this.type).iterator();
                    String ns = (String)CrossReferenceIndexHandler.this.namespacePrefixes.get(parts.next());
                    if (ns != null && (epackage = EPackage.Registry.INSTANCE.getEPackage(ns)) != null) {
                        this.eclass = (EClass)TypeUtils.as((Object)epackage.getEClassifier((String)parts.next()), EClass.class);
                    }
                } else if (this.parent != null && (parentEClass = this.parent.getEClass()) != null && (ref = (EReference)TypeUtils.as((Object)parentEClass.getEStructuralFeature(this.role), EReference.class)) != null) {
                    this.eclass = ref.getEReferenceType();
                }
            }
            return this.eclass;
        }
    }
}

