/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.nattable.properties.providers;

import java.net.MalformedURLException;
import java.net.URL;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.edit.ui.provider.ExtendedImageRegistry;
import org.eclipse.gmf.runtime.emf.type.core.ElementTypeRegistry;
import org.eclipse.gmf.runtime.emf.type.core.IElementType;
import org.eclipse.gmf.runtime.emf.type.core.ISpecializationType;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.osgi.util.NLS;
import org.eclipse.papyrus.infra.types.ElementTypeConfiguration;
import org.eclipse.papyrus.infra.types.ElementTypeSetConfiguration;
import org.eclipse.papyrus.infra.types.IconEntry;
import org.eclipse.papyrus.infra.types.MetamodelTypeConfiguration;
import org.eclipse.papyrus.infra.types.SpecializationTypeConfiguration;
import org.eclipse.papyrus.uml.nattable.properties.Activator;
import org.eclipse.papyrus.uml.nattable.properties.providers.ProviderUtils;
import org.eclipse.swt.graphics.Image;
import org.osgi.framework.Bundle;

public class GenericRelationshipMatrixElementTypeLabelProvider
implements ILabelProvider {
    private static final String UML = "UML";
    private static final String UML_TYPE_SET_NAME = "UMLElementTypeSet";
    private static final String SYSML_TYPE_SET_NAME = "elementTypeSetSysML";
    private static final String SYSML = "SysML";
    private static final String SYSML_14 = "SysML 1.4";

    public void addListener(ILabelProviderListener listener) {
    }

    public void dispose() {
    }

    public boolean isLabelProperty(Object element, String property) {
        return false;
    }

    public void removeListener(ILabelProviderListener listener) {
    }

    public Image getImage(Object element) {
        URL url = null;
        if (element instanceof ElementTypeSetConfiguration) {
            String name = ((ElementTypeSetConfiguration)element).getName();
            if (UML_TYPE_SET_NAME.equals(name)) {
                Bundle bundle = Platform.getBundle((String)"org.eclipse.papyrus.uml.architecture");
                url = bundle.getEntry("icons/uml.gif");
            } else if (SYSML_TYPE_SET_NAME.equals(name)) {
                Bundle bundle = Platform.getBundle((String)"org.eclipse.papyrus.sysml.architecture");
                url = bundle.getEntry("icons/sysml.gif");
            } else if (SYSML_14.equals(name) || SYSML.equals(name)) {
                Bundle bundle = Platform.getBundle((String)"org.eclipse.papyrus.sysml.architecture");
                url = bundle.getEntry("icons/sysml.gif");
            }
        }
        if (element instanceof ElementTypeConfiguration && (url = this.getIconURL((ElementTypeConfiguration)element)) == null) {
            IElementType elementType = null;
            if (element instanceof MetamodelTypeConfiguration) {
                elementType = ElementTypeRegistry.getInstance().getType(((MetamodelTypeConfiguration)element).getIdentifier());
            } else if (element instanceof SpecializationTypeConfiguration) {
                elementType = ElementTypeRegistry.getInstance().getType(((SpecializationTypeConfiguration)element).getIdentifier());
            }
            if (elementType != null) {
                url = this.getIconURL(elementType);
            }
        }
        Image im = null;
        if (url != null) {
            im = ExtendedImageRegistry.INSTANCE.getImage((Object)url);
            if (im == null) {
                Activator.log.warn(NLS.bind((String)"The image located at {0} as not been found", (Object)url));
            }
        } else if (element instanceof ElementTypeConfiguration) {
            Activator.log.warn(NLS.bind((String)"No icon defined for ", (Object)element));
        }
        return im;
    }

    private URL getIconURL(IElementType elementType) {
        ISpecializationType subtype;
        IElementType[] supertypes;
        URL result = elementType.getIconURL();
        if (result == null && elementType instanceof ISpecializationType && (supertypes = (subtype = (ISpecializationType)elementType).getSpecializedTypes()) != null) {
            int i = 0;
            while (result == null && i < supertypes.length) {
                result = this.getIconURL(supertypes[i]);
                ++i;
            }
        }
        return result;
    }

    private URL getIconURL(ElementTypeConfiguration elementTypeConfiguration) {
        IconEntry entry = elementTypeConfiguration.getIconEntry();
        URL iconURL = null;
        if (entry != null) {
            iconURL = this.getURLFromEntry(entry);
        }
        return iconURL;
    }

    private URL getURLFromEntry(IconEntry entry) {
        Bundle bundle = Platform.getBundle((String)entry.getBundleId());
        if (bundle == null) {
            Activator.log.warn(NLS.bind((String)"Bundle {0} doesn't exist. I cannot found the expected icon {1}.", (Object)entry.getBundleId(), (Object)entry.getIconPath()));
            return null;
        }
        URL result = bundle.getEntry(entry.getIconPath());
        if (result == null) {
            try {
                result = new URL(entry.getIconPath());
            }
            catch (MalformedURLException e) {
                Activator.log.error(NLS.bind((String)"The icon path {0} seems invalid, I can't found this icon in the bundle {1}.", (Object)entry.getIconPath(), (Object)entry.getBundleId()), (Throwable)e);
                result = null;
            }
        }
        return result;
    }

    public String getText(Object element) {
        String returnedName = "";
        if (element != null) {
            returnedName = element.toString();
            if (element instanceof ElementTypeSetConfiguration) {
                returnedName = ((ElementTypeSetConfiguration)element).getName();
            }
            if (element instanceof ElementTypeConfiguration) {
                returnedName = ProviderUtils.getNameToDisplay((ElementTypeConfiguration)element);
            }
            if (UML_TYPE_SET_NAME.equals(returnedName)) {
                returnedName = UML;
            }
            if (SYSML_TYPE_SET_NAME.equals(returnedName)) {
                returnedName = SYSML;
            }
        }
        return returnedName;
    }
}

