/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.dnd.strategy;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gmf.runtime.common.core.command.CompositeCommand;
import org.eclipse.gmf.runtime.diagram.core.preferences.PreferencesHint;
import org.eclipse.gmf.runtime.diagram.core.services.ViewService;
import org.eclipse.gmf.runtime.diagram.ui.commands.CommandProxy;
import org.eclipse.gmf.runtime.diagram.ui.commands.ICommandProxy;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.infra.gmfdiag.dnd.strategy.TransactionalDropStrategy;
import org.eclipse.papyrus.uml.diagram.composite.custom.edit.parts.ResizablePortEditPart;
import org.eclipse.swt.graphics.Image;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Port;
import org.eclipse.uml2.uml.Type;

public class PortToTypesPortDropStrategy
extends TransactionalDropStrategy {
    public String getLabel() {
        return "Parameter drag and drop inside Parameter Property";
    }

    public String getID() {
        return "org.eclipse.papyrus.sysml14.diagram.parametric.dnd.ParameterDropStrategy";
    }

    public String getDescription() {
        return "This strategy is is a specialization in order to be able to drop a Port inside Port.";
    }

    public Command doGetCommand(Request request, EditPart targetEditPart) {
        CompositeCommand cc = new CompositeCommand(this.getLabel());
        if (targetEditPart instanceof ResizablePortEditPart) {
            Port targetPort;
            Type targetType;
            ResizablePortEditPart graphicalEditPart = (ResizablePortEditPart)targetEditPart;
            List sourceElements = this.getSourceEObjects(request);
            if (sourceElements.isEmpty()) {
                return null;
            }
            ArrayList<EObject> valuesToAdd = new ArrayList<EObject>(sourceElements.size());
            Element target = (Element)graphicalEditPart.resolveSemanticElement();
            if (target instanceof Port && ((Port)target).getType() != null && (targetType = (targetPort = (Port)target).getType()) instanceof Classifier) {
                Classifier targetClassifier = (Classifier)targetType;
                EList targetAllAttributes = targetClassifier.getAllAttributes();
                for (EObject sourceElement : sourceElements) {
                    if (!(sourceElement instanceof Port) || !targetAllAttributes.contains((Object)sourceElement)) continue;
                    this.addCommandDrop(graphicalEditPart, cc, valuesToAdd, sourceElement);
                }
            }
        }
        return cc.canExecute() ? new ICommandProxy(cc.reduce()) : null;
    }

    public Image getImage() {
        return null;
    }

    public int getPriority() {
        return 0;
    }

    protected Command addCommandDrop(final ResizablePortEditPart targetEditPart, CompositeCommand cc, final List<EObject> valuesToAdd, EObject sourceElement) {
        valuesToAdd.add(sourceElement);
        Command cmd = new Command(){

            public void execute() {
                ViewService.createNode((View)targetEditPart.getNotationView(), (EObject)((EObject)valuesToAdd.get(0)), (String)"Port_Shape", (PreferencesHint)targetEditPart.getDiagramPreferencesHint());
            }
        };
        cc.add((IUndoableOperation)new CommandProxy(cmd));
        return cmd;
    }
}

