/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.ecore.tests;

import java.util.Collections;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EcoreFactory;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.ocl.ecore.tests.AbstractTestSuite;
import org.eclipse.ocl.expressions.OCLExpression;
import org.eclipse.ocl.expressions.PropertyCallExp;
import org.eclipse.ocl.expressions.TypeExp;

public class InvariantConstraintsTest
extends AbstractTestSuite {
    public void test_simpleInvariant() {
        this.parseConstraint("package ocltest context Fruit inv: color <> Color::black endpackage");
    }

    public void test_simpleInvariantWithSelf() {
        this.parseConstraint("package ocltest context Fruit inv: self.color <> Color::black endpackage");
    }

    public void test_simpleInvariantWithLet() {
        this.parseConstraint("package ocltest context Fruit inv: let myColor : Color = self.color in myColor <> Color::black endpackage");
    }

    public void test_variablesHidingAttributes() {
        this.parseConstraint("package ocltest context Fruit inv: let color : Boolean = (not self.color.oclIsUndefined()) in   color implies self.color <> Color::black endpackage");
    }

    public void test_propertyNameCoincidesWithTypeName_140347() {
        this.expectModified = true;
        EReference myFruit = EcoreFactory.eINSTANCE.createEReference();
        myFruit.setName("Fruit");
        myFruit.setEType((EClassifier)this.fruit);
        this.apple.getEStructuralFeatures().add((Object)myFruit);
        try {
            OCLExpression expr = this.parseConstraint("package ocltest context Apple inv: self.Fruit <> self implies self.Fruit.oclIsKindOf(Fruit) endpackage");
            int propertyCalls = 0;
            int typeCalls = 0;
            TreeIterator iter = EcoreUtil.getAllContents(Collections.singleton(expr));
            while (iter.hasNext()) {
                TypeExp te;
                Object next = iter.next();
                if (next instanceof PropertyCallExp) {
                    PropertyCallExp pc = (PropertyCallExp)next;
                    if (!"Fruit".equals(((EStructuralFeature)pc.getReferredProperty()).getName())) continue;
                    ++propertyCalls;
                    continue;
                }
                if (!(next instanceof TypeExp) || !"Fruit".equals(((EClassifier)(te = (TypeExp)next).getReferredType()).getName())) continue;
                ++typeCalls;
            }
            InvariantConstraintsTest.assertEquals((String)"property calls", (int)2, (int)propertyCalls);
            InvariantConstraintsTest.assertEquals((String)"type calls", (int)1, (int)typeCalls);
        }
        finally {
            this.apple.getEStructuralFeatures().remove((Object)myFruit);
        }
    }
}

