/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.ecore.helper.tests;

import java.util.Collection;
import java.util.Map;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.impl.ResourceImpl;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.ocl.ParserException;
import org.eclipse.ocl.ecore.Constraint;
import org.eclipse.ocl.ecore.helper.tests.AbstractTestSuite;
import org.eclipse.ocl.ecore.opposites.ExtentMap;
import org.eclipse.ocl.expressions.OCLExpression;

public class EvaluationTest
extends AbstractTestSuite {
    public void test_allInstances() {
        this.helper.setContext((Object)this.fruit);
        try {
            String expr = "Fruit.allInstances()->select(f : Fruit | f.color = Color::black)->isEmpty()";
            ResourceImpl res = new ResourceImpl();
            EObject aFruit = this.fruitFactory.create(this.apple);
            aFruit.eSet((EStructuralFeature)this.fruit_color, (Object)this.color_red);
            res.getContents().add((Object)aFruit);
            aFruit = this.fruitFactory.create(this.apple);
            aFruit.eSet((EStructuralFeature)this.fruit_color, (Object)this.color_yellow);
            res.getContents().add((Object)aFruit);
            aFruit = this.fruitFactory.create(this.apple);
            aFruit.eSet((EStructuralFeature)this.fruit_color, (Object)this.color_orange);
            res.getContents().add((Object)aFruit);
            aFruit = this.fruitFactory.create(this.apple);
            aFruit.eSet((EStructuralFeature)this.fruit_color, (Object)this.color_pink);
            res.getContents().add((Object)aFruit);
            aFruit = this.fruitFactory.create(this.apple);
            aFruit.eSet((EStructuralFeature)this.fruit_color, (Object)this.color_green);
            res.getContents().add((Object)aFruit);
            this.assertTrue(this.evaluate(this.helper, aFruit, expr));
            aFruit.eSet((EStructuralFeature)this.fruit_color, (Object)this.color_black);
            this.assertFalse(this.evaluate(this.helper, aFruit, expr));
        }
        catch (Exception e) {
            EvaluationTest.fail((String)("Parse failed: " + e.getLocalizedMessage()));
        }
    }

    public void test_allInstancesWithRemovingResource() throws ParserException {
        ResourceSetImpl rs = new ResourceSetImpl();
        this.ocl.setExtentMap((Map)new ExtentMap((Notifier)rs));
        ResourceImpl rOld = new ResourceImpl();
        rs.getResources().add((Object)rOld);
        EObject oldApple = this.fruitFactory.create(this.apple);
        rOld.getContents().add((Object)oldApple);
        ResourceImpl rNew = new ResourceImpl();
        EObject newApple = this.fruitFactory.create(this.apple);
        rNew.getContents().add((Object)newApple);
        this.helper.setContext((Object)this.apple);
        OCLExpression ai = this.helper.createQuery("Fruit.allInstances()");
        Object o = this.ocl.evaluate((Object)rs, ai);
        Collection allApples = (Collection)o;
        EvaluationTest.assertFalse((boolean)allApples.contains(newApple));
        rs.getResources().add((Object)rNew);
        Collection allApplesNew = (Collection)this.ocl.evaluate((Object)rs, ai);
        EvaluationTest.assertTrue((boolean)allApplesNew.contains(newApple));
        rs.getResources().remove((Object)rNew);
        Collection allApplesWithResourceRemovedAgain = (Collection)this.ocl.evaluate((Object)rs, ai);
        EvaluationTest.assertFalse((boolean)allApplesWithResourceRemovedAgain.contains(newApple));
        this.ocl.setExtentMap(null);
    }

    public void test_evaluatePrecompiledInvariant_114921() {
        this.helper.setContext((Object)this.fruit);
        try {
            OCLExpression constraint = ((Constraint)this.helper.createInvariant("color <> Color::black")).getSpecification().getBodyExpression();
            EvaluationTest.assertNotNull((Object)constraint);
            EObject instance = this.fruitFactory.create(this.apple);
            instance.eSet((EStructuralFeature)this.fruit_color, (Object)this.color_black);
            EvaluationTest.assertFalse((boolean)this.ocl.check((Object)instance, constraint));
            instance.eSet((EStructuralFeature)this.fruit_color, (Object)this.color_red);
            EvaluationTest.assertTrue((boolean)this.ocl.check((Object)instance, constraint));
        }
        catch (Exception e) {
            EvaluationTest.fail((String)("Parse failed: " + e.getLocalizedMessage()));
        }
    }

    void assertTrue(Object object) {
        EvaluationTest.assertNotNull((Object)object);
        EvaluationTest.assertSame(Boolean.class, object.getClass());
        EvaluationTest.assertTrue((boolean)((Boolean)object));
    }

    void assertFalse(Object object) {
        EvaluationTest.assertNotNull((Object)object);
        EvaluationTest.assertSame(Boolean.class, object.getClass());
        EvaluationTest.assertFalse((boolean)((Boolean)object));
    }
}

