/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.internal.xpand.ast;

import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.gmf.internal.xpand.BuiltinMetaModel;
import org.eclipse.gmf.internal.xpand.ast.AbstractDefinition;
import org.eclipse.gmf.internal.xpand.ast.Statement;
import org.eclipse.gmf.internal.xpand.expression.AnalysationIssue;
import org.eclipse.gmf.internal.xpand.expression.Variable;
import org.eclipse.gmf.internal.xpand.expression.ast.DeclaredParameter;
import org.eclipse.gmf.internal.xpand.expression.ast.Identifier;
import org.eclipse.gmf.internal.xpand.model.XpandAdvice;
import org.eclipse.gmf.internal.xpand.model.XpandDefinition;
import org.eclipse.gmf.internal.xpand.model.XpandExecutionContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Advice
extends AbstractDefinition
implements XpandAdvice {
    public static final String DEF_VAR_NAME = "targetDef";
    private final Identifier pointCut;
    private final boolean wildParams;
    private Pattern p = null;

    public Advice(int start, int end, int line, Identifier pointCut, Identifier type, DeclaredParameter[] params, boolean wildParams, Statement[] body) {
        super(start, end, line, type, params, body);
        this.pointCut = pointCut;
        this.wildParams = wildParams;
    }

    public Identifier getPointCut() {
        return this.pointCut;
    }

    public String toString() {
        return String.valueOf(this.getOwner().getFullyQualifiedName()) + " " + this.pointCut.getValue() + this.getParamString() + " FOR " + this.getType().getValue();
    }

    @Override
    public void analyze(XpandExecutionContext ctx, Set<AnalysationIssue> issues) {
        ctx = (XpandExecutionContext)ctx.cloneWithVariable(new Variable(DEF_VAR_NAME, BuiltinMetaModel.DEFINITION_TYPE));
        super.analyze(ctx, issues);
    }

    private String getParamString() {
        if (this.getParams() == null || this.getParams().length == 0) {
            return this.wildParams ? "(*)" : "";
        }
        StringBuffer buff = new StringBuffer("(");
        int i = 0;
        while (i < this.getParams().length) {
            DeclaredParameter p = this.getParams()[i];
            buff.append(p.getName().getValue()).append(" ").append(p.getType().getValue());
            if (i + 1 < this.getParams().length) {
                buff.append(",");
            }
            ++i;
        }
        if (this.wildParams) {
            buff.append(",*");
        }
        return buff.append(")").toString();
    }

    @Override
    public boolean matches(XpandDefinition def, XpandExecutionContext ctx) {
        if (this.p == null) {
            this.p = Pattern.compile(this.pointCut.getValue().replaceAll("\\*", ".*"));
        }
        Matcher m1 = this.p.matcher(def.getName());
        Matcher m2 = this.p.matcher(String.valueOf(def.getOwner().getFullyQualifiedName()) + "::" + def.getName());
        if (m1.matches() || m2.matches()) {
            EClassifier at;
            ctx = (XpandExecutionContext)ctx.cloneWithResource(def.getOwner());
            EClassifier t = ctx.getTypeForName(def.getTargetType());
            EClassifier[] paramTypes = new EClassifier[def.getParams().length];
            int i = 0;
            while (i < paramTypes.length) {
                paramTypes[i] = ctx.getTypeForName(def.getParams()[i].getType().getValue());
                ++i;
            }
            if ((this.getParams().length == paramTypes.length || this.wildParams && this.getParams().length <= paramTypes.length) && BuiltinMetaModel.isAssignableFrom(at = (ctx = (XpandExecutionContext)ctx.cloneWithResource(def.getOwner())).getTypeForName(this.getTargetType()), t)) {
                int i2 = 0;
                while (i2 < this.getParams().length) {
                    EClassifier pt = ctx.getTypeForName(this.getParams()[i2].getType().getValue());
                    if (!BuiltinMetaModel.isAssignableFrom(pt, paramTypes[i2])) {
                        return false;
                    }
                    ++i2;
                }
                return true;
            }
        }
        return false;
    }
}

